/*
 * Decompiled with CFR 0.152.
 */
package net.java.frej.fuzzy;

import java.util.Collection;

public final class Fuzzy {
    public static int resultStart;
    public static int resultEnd;
    public static int resultIndex;
    public static String matchedPattern;
    public static double result;
    public static double threshold;
    protected static final int MAX_PATTERN = 64;
    protected static final int MAX_SOURCE = 256;
    protected static final int BIG_VALUE = 1000000;
    protected static int[][] e;
    protected static WayType[][] w;

    public static int substrStart(CharSequence charSequence, CharSequence charSequence2) {
        if (Fuzzy.containability(charSequence, charSequence2) < threshold) {
            return resultStart;
        }
        return -1;
    }

    public static int substrEnd(CharSequence charSequence, CharSequence charSequence2) {
        if (Fuzzy.containability(charSequence, charSequence2) < threshold) {
            return resultEnd;
        }
        return -1;
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        return Fuzzy.similarity(charSequence, charSequence2) < threshold;
    }

    public static boolean containsOneOf(CharSequence charSequence, CharSequence ... charSequenceArray) {
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!(Fuzzy.containability(charSequence, charSequence2) < threshold)) continue;
            return true;
        }
        return false;
    }

    public static double containability(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2 = charSequence2.length() + 1;
        int n3 = charSequence.length() + 1;
        for (n = 0; n < n3; ++n) {
            Fuzzy.e[0][n] = 0;
        }
        char c = '\u0000';
        for (n = 1; n < n2; ++n) {
            Fuzzy.e[n][0] = n;
            Fuzzy.w[n][0] = WayType.DELETE;
            char c2 = c;
            c = Character.toUpperCase(charSequence2.charAt(n - 1));
            char c3 = '\u0000';
            for (int i = 1; i < n3; ++i) {
                char c4 = c3;
                c3 = Character.toUpperCase(charSequence.charAt(i - 1));
                int n4 = c == c3 ? 0 : 1;
                int n5 = e[n - 1][i - 1] + n4;
                Fuzzy.w[n][i] = WayType.SUBST;
                int n6 = e[n - 1][i] + 1;
                if (n5 > n6) {
                    n5 = n6;
                    Fuzzy.w[n][i] = WayType.DELETE;
                }
                if (n5 > (n6 = e[n][i - 1] + 1)) {
                    n5 = n6;
                    Fuzzy.w[n][i] = WayType.INSERT;
                }
                if (c2 == c3 && c == c4 && n5 > (n6 = e[n - 2][i - 2] + n4)) {
                    n5 = n6;
                    Fuzzy.w[n][i] = WayType.SWAP;
                }
                Fuzzy.e[n][i] = n5;
            }
        }
        int n7 = n3 - 1;
        for (n = 0; n < n3; ++n) {
            if (e[n2 - 1][n] >= e[n2 - 1][n7]) continue;
            n7 = n;
        }
        int n8 = n7;
        n = n2 - 1;
        block9: while (n > 0) {
            switch (w[n][n8]) {
                case INSERT: {
                    --n8;
                    continue block9;
                }
                case DELETE: {
                    --n;
                    continue block9;
                }
                case SWAP: {
                    n -= 2;
                    n8 -= 2;
                    continue block9;
                }
            }
            --n8;
            --n;
        }
        resultStart = n8 + 1;
        resultEnd = n7;
        result = (double)e[n2 - 1][n7] / (double)charSequence2.length();
        return result;
    }

    public static double bestEqual(String string, Object object, boolean bl) {
        String[] stringArray;
        double d = Double.POSITIVE_INFINITY;
        if (object instanceof String[]) {
            stringArray = (String[])object;
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            stringArray = collection.toArray(new String[collection.size()]);
        } else {
            throw new IllegalArgumentException();
        }
        resultIndex = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            double d2;
            double d3 = d2 = bl ? Fuzzy.similarity(string, stringArray[i]) : Fuzzy.containability(string, stringArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
            resultIndex = i;
            matchedPattern = stringArray[i];
        }
        return d;
    }

    public static double similarity(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2 = charSequence2.length() + 1;
        int n3 = charSequence.length() + 1;
        for (n = 0; n < n3; ++n) {
            Fuzzy.e[0][n] = n;
        }
        char c = '\u0000';
        for (n = 1; n < n2; ++n) {
            Fuzzy.e[n][0] = n;
            char c2 = c;
            c = Character.toUpperCase(charSequence2.charAt(n - 1));
            char c3 = '\u0000';
            for (int i = 1; i < n3; ++i) {
                int n4 = 1000000;
                char c4 = c3;
                c3 = Character.toUpperCase(charSequence.charAt(i - 1));
                int n5 = c3 == c ? 0 : 1;
                n4 = e[n - 1][i - 1] + n5;
                n4 = Math.min(e[n][i - 1] + 1, n4);
                n4 = Math.min(e[n - 1][i] + 1, n4);
                if (c3 == c2 && c == c4) {
                    n4 = Math.min(e[n - 2][i - 2] + n5, n4);
                }
                Fuzzy.e[n][i] = n4;
            }
        }
        result = (double)(2 * e[n2 - 1][n3 - 1]) / ((double)(n2 + n3) - 2.0);
        return result;
    }

    static {
        threshold = 0.34;
        e = new int[65][257];
        w = new WayType[65][257];
    }

    private static enum WayType {
        TRANSIT,
        INSERT,
        DELETE,
        SUBST,
        SWAP;

    }
}

