/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class VideoManage {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Verzeichnis;
    private boolean Test;
    private boolean AnfangsbuchstabenBeiVerschieben;
    private String Trennzeichen;
    private int anzahlRename;
    private String Funktion;
    private final boolean SetzenWerteInGUInachRun = false;
    private final String Stand = "24.8.2011";

    public static void main(String[] args) {
        VideoManage videoManage = new VideoManage(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(videoManage.ArgTab, videoManage.ArgTabDefault, videoManage.getHilfeText())) {
            try {
                videoManage.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + videoManage.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                videoManage.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + videoManage.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + videoManage.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public static void zeigenHilfe() {
        System.out.println("java erstellt oder prueft zu jeder Filmdatei mit der Endung avi, mpg, mp4 oder wmw eine Playlist (Endung m3u) oder prueft vorhandene Playlisten");
        System.out.println("");
    }

    public VideoManage() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public VideoManage(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void checkName1ElementGruppe(String[] element, ArrayList<String> RenameBack) {
        String dateiAlt;
        FProt fProt = FProt.instance();
        boolean rename = false;
        if (element[1].length() > 0) {
            dateiAlt = String.valueOf(element[0]) + this.getTrennzeichen() + element[1] + "." + element[2];
            rename = true;
        } else {
            dateiAlt = String.valueOf(element[0]) + "." + element[2];
        }
        if (!rename) {
            fProt.prot(String.valueOf(dateiAlt) + " :: O.K.", 2);
        } else {
            String dateiNeu = String.valueOf(element[0]) + "." + element[2];
            if (this.isTest()) {
                fProt.prot(String.valueOf(dateiAlt) + " -> " + dateiNeu + " :: rename");
            } else {
                File fileAlt = new File(dateiAlt);
                File fileNeu = new File(dateiNeu);
                fProt.prot(String.valueOf(dateiAlt) + " -> " + dateiNeu + " :: rename erfolgreich " + fileAlt.renameTo(fileNeu));
                RenameBack.add("ren/" + dateiNeu + "/" + dateiAlt);
            }
        }
    }

    private void checkNamesClips(ArrayList<Rename> Clips, ArrayList<String> RenameBack) {
        FProt fProt = FProt.instance();
        FString fString = FString.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        int ListeBeginn = 0;
        String[] DateienSort = new String[Clips.size()];
        String[][] Dateien = new String[Clips.size()][3];
        String letzteGruppe = "";
        Rename rename = new Rename();
        int i = 0;
        while (i < Clips.size()) {
            rename = Clips.get(i);
            DateienSort[i] = rename.toTabbedString();
            ++i;
        }
        fProt.prot("Dateien vor Sort", 3);
        fProt.prot(DateienSort, 3);
        DateienSort = fQuickSort.quickSort(DateienSort, true, true);
        fProt.prot("Dateien nach Sort", 3);
        fProt.prot(DateienSort, 3);
        Dateien = fString.convertStringArrayToTabelle(DateienSort, 3);
        i = 0;
        while (i < Dateien.length) {
            if (Dateien[i][0].compareToIgnoreCase(letzteGruppe) != 0) {
                if (i > 0) {
                    fProt.prot("CheckNames Gruppe <" + letzteGruppe + "<", 3);
                    this.checkNamesGruppe(Dateien, ListeBeginn, i - 1, RenameBack);
                }
                ListeBeginn = i;
            }
            letzteGruppe = Dateien[i][0];
            ++i;
        }
        fProt.prot("CheckNames Gruppe <" + letzteGruppe + "<", 3);
        this.checkNamesGruppe(Dateien, ListeBeginn, i - 1, RenameBack);
    }

    private void checkNamesGruppe(String[][] Liste2, int von, int bis, ArrayList<String> RenameBack) {
        if (von == bis) {
            this.checkName1ElementGruppe(Liste2[von], RenameBack);
        } else {
            FString fString = FString.instance();
            FQuickSort fQuickSort = FQuickSort.instance();
            FProt fProt = FProt.instance();
            int lfdNr = 1;
            int laengeNr = 0;
            String[] Zeile = new String[bis - von + 1];
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumIntegerDigits(String.valueOf(bis - von + 1).length());
            fProt.prot(String.valueOf(Liste2[von][0]) + ", von:" + Liste2[von][1] + ", bis:" + Liste2[bis][1], 3);
            int i = von;
            while (i <= bis) {
                laengeNr = Math.max(laengeNr, Liste2[i][1].length());
                ++i;
            }
            nf.setMinimumIntegerDigits(laengeNr);
            String lfdNrAsString = nf.format(0L);
            i = von;
            while (i <= bis) {
                String work = String.valueOf(lfdNrAsString) + Liste2[i][1];
                Zeile[i - von] = String.valueOf(work.substring(work.length() - laengeNr)) + "\t" + Liste2[i][1] + "\t" + Liste2[i][0] + "\t" + Liste2[i][2];
                ++i;
            }
            Zeile = fQuickSort.quickSort(Zeile, true, true);
            String[][] Gruppe = fString.convertStringArrayToTabelle(Zeile, 3);
            nf.setMinimumIntegerDigits(String.valueOf(bis - von + 1).length());
            i = 0;
            while (i < Gruppe.length) {
                lfdNrAsString = nf.format(lfdNr);
                String dateiAlt = Gruppe[i][1].length() > 0 ? String.valueOf(Gruppe[i][2]) + this.getTrennzeichen() + Gruppe[i][1] + "." + Gruppe[i][3] : String.valueOf(Gruppe[i][2]) + "." + Gruppe[i][3];
                if (Gruppe[i][1].compareTo(lfdNrAsString) == 0) {
                    fProt.prot(String.valueOf(dateiAlt) + " :: O.K.", 2);
                } else {
                    this.incrementAnzahlRename();
                    String dateiNeu = String.valueOf(Gruppe[i][2]) + this.getTrennzeichen() + lfdNrAsString + "." + Gruppe[i][3];
                    if (this.isTest()) {
                        fProt.prot(String.valueOf(dateiAlt) + " -> " + dateiNeu + " :: rename");
                    } else {
                        File fileAlt = new File(dateiAlt);
                        File fileNeu = new File(dateiNeu);
                        fProt.prot(String.valueOf(dateiAlt) + " -> " + dateiNeu + " :: rename erfolgreich " + fileAlt.renameTo(fileNeu));
                        RenameBack.add("ren/" + dateiNeu + "/" + dateiAlt);
                    }
                }
                ++lfdNr;
                ++i;
            }
        }
    }

    private int getAnzahlRename() {
        return this.anzahlRename;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "24.8.2011";
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    private void incrementAnzahlRename() {
        ++this.anzahlRename;
    }

    public boolean isAnfangsbuchstabenBeiVerschieben() {
        return this.AnfangsbuchstabenBeiVerschieben;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTest() {
        return this.Test;
    }

    private void resetAnzahlRename() {
        this.anzahlRename = 0;
    }

    public void run() {
        FProt fProt = FProt.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()));
        char funktion = this.getFunktion().toUpperCase().charAt(0);
        ArrayList<Rename> Renames = new ArrayList<Rename>();
        ArrayList<String> RenameBack = new ArrayList<String>();
        if (this.getVerzeichnis().length() > 0) {
            if (funktion == 'R') {
                this.resetAnzahlRename();
                String[] Files2 = new FFile(this.getVerzeichnis()).listFileNames('D', true);
                int i = 0;
                while (i < Files2.length) {
                    FDatei.DateinamenTeile datei = FDatei.instance().zerlegeDateiname(String.valueOf(this.getVerzeichnis()) + Files2[i], this.getTrennzeichen());
                    if (datei.getExtend().compareToIgnoreCase("avi") == 0 || datei.getExtend().compareToIgnoreCase("gif") == 0 || datei.getExtend().compareToIgnoreCase("mpg") == 0 || datei.getExtend().compareToIgnoreCase("mp4") == 0 || datei.getExtend().compareToIgnoreCase("wmv") == 0) {
                        Rename rename = new Rename();
                        rename.Gruppe = String.valueOf(datei.getPfad()) + System.getProperty("file.separator") + datei.getBaseBis_EndeBaseIgnorierenAbUndNummerisch();
                        rename.Nr = datei.getNumerischesEndeVonBas();
                        rename.Extent = datei.getExtend();
                        Renames.add(rename);
                    }
                    ++i;
                }
                this.checkNamesClips(Renames, RenameBack);
                if (RenameBack.size() > 0) {
                    FFile renameBackFile = new FFile(this.getVerzeichnis(), "Rename.Back." + new FGregorianCalendar().toGermanFormat('L') + ".txt");
                    renameBackFile.StringArrayListToInhalt(RenameBack);
                    fProt.prot("Datei >" + renameBackFile.getAbsolutePath() + "< zum Rename zurueck erstellt!");
                }
                fProt.prot(String.valueOf(this.getVerzeichnis()) + ": " + Renames.size() + " Video" + (Renames.size() == 1 ? "" : "s") + " vorhanden, " + this.getAnzahlRename() + " Video" + (this.getAnzahlRename() == 1 ? "" : "s") + (this.isTest() ? " zu renamen" : " renamed"));
            } else if (funktion == 'V') {
                FDatei.checkAndMoveVideoSammlung(this.getVerzeichnis(), this.isAnfangsbuchstabenBeiVerschieben(), this.isTest(), false);
            }
        }
    }

    public void setAnfangsbuchstabenBeiVerschieben() {
        this.AnfangsbuchstabenBeiVerschieben = FParam.getBooleanParameter("AnfangsbuchstabenBeiVerschieben", this.ArgTab);
    }

    public void setAnfangsbuchstabenBeiVerschieben(boolean anfangsbuchstabenBeiVerschieben) {
        this.AnfangsbuchstabenBeiVerschieben = anfangsbuchstabenBeiVerschieben;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setTest() {
        this.Test = FParam.getBooleanParameter("Test", this.ArgTab);
    }

    public void setTest(boolean test) {
        this.Test = test;
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        FParam.instance();
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setTest();
        this.setFunktion();
        this.setAnfangsbuchstabenBeiVerschieben();
        this.setTrennzeichen();
    }

    public void updateEinzelneListe(ArrayList<Liste> Listen, int von, int bis) {
        FProt fProt = FProt.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        ArrayList<String> Ausgabe = new ArrayList<String>();
        boolean changed = false;
        int i = von;
        while (i <= bis) {
            if (Listen.get((int)i).Status.compareToIgnoreCase("delete") != 0) {
                Ausgabe.add(Listen.get((int)i).Clip);
            }
            if (Listen.get((int)i).Status.length() > 0) {
                changed = true;
            }
            ++i;
        }
        fProt.prot("Inhalt von Playliste >" + Listen.get((int)von).Liste + "< Status: " + changed, 2);
        fProt.prot(FString.arrayListToStringArray(Ausgabe), 2);
        if (!this.isTest()) {
            FFile dat = new FFile(Listen.get((int)von).Liste);
            if (Ausgabe.size() == 0) {
                fProt.prot("Playliste >" + Listen.get((int)von).Liste + "< leer, geloescht: " + dat.delete(), 1);
            } else if (changed) {
                dat.StringArrayToInhalt(fQuickSort.quickSort(FString.arrayListToStringArray(Ausgabe), true, true));
                fProt.prot("Playliste >" + Listen.get((int)von).Liste + "< veraendert", 1);
            }
        }
    }

    public void updateListen(ArrayList<Liste> Listen) {
        int ListeBeginn = 0;
        String LetzteListe = null;
        int i = 0;
        while (i < Listen.size()) {
            String Liste2 = Listen.get((int)i).Liste;
            if (LetzteListe != null && Liste2.compareToIgnoreCase(LetzteListe) != 0) {
                this.updateEinzelneListe(Listen, ListeBeginn, i - 1);
                ListeBeginn = i;
            }
            LetzteListe = Liste2;
            ++i;
        }
        this.updateEinzelneListe(Listen, ListeBeginn, i - 1);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Verzeichnis                                             :" + this.getVerzeichnis());
        fProt.prot("Testmodus, keine Veraenderungen                         :" + this.isTest());
        fProt.prot("Funktion                                                :" + this.getFunktion());
        fProt.prot("bei verschiebe Videos Anfangsbuchstaben beruecksichtigen:" + this.isAnfangsbuchstabenBeiVerschieben());
        fProt.prot("Trennzeichen (vor der Zahl)                             :" + this.getTrennzeichen());
    }

    class Clip {
        public String Clip = "";
        public String Gruppe = "";

        Clip() {
        }

        public String toTabbedString() {
            return this.toTabbedString("\t");
        }

        public String toTabbedString(String Sep) {
            return String.valueOf(this.Clip) + Sep + this.Gruppe;
        }
    }

    class Liste {
        public String Liste = "";
        public String Clip = "";
        public String Gruppe = "";
        public String Status = "";

        Liste() {
        }

        public String toTabbedString() {
            return this.toTabbedString("\t");
        }

        public String toTabbedString(String Sep) {
            return String.valueOf(this.Clip) + Sep + this.Gruppe + Sep + this.Liste + Sep + this.Status;
        }
    }

    class Rename {
        public String Gruppe = "";
        public String Nr = "";
        public String Extent = "";

        Rename() {
        }

        public String toTabbedString() {
            return this.toTabbedString("\t");
        }

        public String toTabbedString(String Sep) {
            return String.valueOf(this.Gruppe) + Sep + this.Nr + Sep + this.Extent;
        }
    }
}

