/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;

public class VglVerz {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String PrimaerVerz;
    private String SekundaerVerz;
    private boolean BenutzenXCOPY;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean Test;
    private int Toleranz;
    private int KuerzenAufLaenge;
    private boolean SekundaerGrenzenBeachten;
    private boolean IgnoreCase;
    private boolean ProtokollohneHeader;
    private int Anzahl_del_Verz;
    private int Anzahl_crea_Verz;
    private int Anzahl_del_Datei;
    private int Anzahl_crea_Datei;
    private int Anzahl_upd_Datei;
    private final String Stand = "20.3.2007";

    public static void main(String[] args) {
        VglVerz vglVerz = new VglVerz(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(vglVerz.ArgTab, vglVerz.ArgTabDefault, vglVerz.getHilfeText())) {
            try {
                vglVerz.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + vglVerz.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                vglVerz.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + vglVerz.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + vglVerz.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public VglVerz() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public VglVerz(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public void abarbeitenDateiliste(String[] DateiListe, String[] DateiListeOrg, String relVerz, String[] Liste2, String[] ListeOrg, HashMap<String, Integer> Sek, HashMap<String, Integer> Kurz) {
        FProt fProt = FProt.instance();
        FGregorianCalendar PrimZeit = new FGregorianCalendar();
        FGregorianCalendar SekZeit = new FGregorianCalendar();
        fProt.prot("DateiListe: alle Dateien in '" + relVerz + "':", 8);
        fProt.prot(DateiListe, 8);
        int i = 0;
        while (i < DateiListe.length) {
            FFile Datei;
            String DateinameOrg;
            String Dateiname;
            if (relVerz.length() > 0) {
                Dateiname = String.valueOf(relVerz) + System.getProperty("file.separator") + DateiListe[i];
                DateinameOrg = String.valueOf(relVerz) + System.getProperty("file.separator") + DateiListeOrg[i];
            } else {
                Dateiname = DateiListe[i];
                DateinameOrg = DateiListeOrg[i];
            }
            String SekDateiname = Dateiname;
            String SekDateinameOrg = DateinameOrg;
            fProt.prot("chk : Prim: " + Dateiname, 4);
            Integer pos = Sek.get(Dateiname);
            if (pos == null && this.getKuerzenAufLaenge() > 0) {
                SekDateiname = FDatei.shortenDateiname(Dateiname, this.getKuerzenAufLaenge());
                SekDateinameOrg = FDatei.shortenDateiname(DateinameOrg, this.getKuerzenAufLaenge());
                fProt.prot("chk1: Prim: " + SekDateiname + "->Sek:" + Dateiname, 5);
                pos = Sek.get(SekDateiname);
            }
            if (pos == null && this.getKuerzenAufLaenge() > 0) {
                fProt.prot("chk2: Prim: " + SekDateiname, 4);
                pos = Kurz.get(Dateiname);
                if (pos != null) {
                    SekDateiname = Liste2[pos];
                    SekDateinameOrg = ListeOrg[pos];
                    fProt.prot("fnd2: Prim: " + Dateiname + "->Sek:" + SekDateiname, 5);
                }
            }
            if (pos == null) {
                fProt.prot("notf: Sek : " + SekDateiname, 3);
                fProt.prot("crec: Sek : " + DateiListeOrg[i], 2);
                if (!this.isTest()) {
                    Datei = new FFile(this.getPrimaerVerz(), Dateiname);
                    Datei.copyFile(String.valueOf(this.getSekundaerVerz()) + SekDateinameOrg);
                    fProt.prot("cre : Sek : " + DateinameOrg, 1);
                }
                ++this.Anzahl_crea_Datei;
            } else {
                Datei = new FFile(this.getPrimaerVerz(), Dateiname);
                FFile DateiSekundaer = new FFile(String.valueOf(this.getSekundaerVerz()) + SekDateiname);
                if (DateiSekundaer.length() != Datei.length()) {
                    fProt.prot("len : Sek : " + SekDateiname + ", " + DateiSekundaer.length(), 4);
                    fProt.prot("len : Prim: " + Dateiname + ", " + Datei.length(), 4);
                    fProt.prot("lenc: Sek : " + SekDateinameOrg, 3);
                    fProt.prot("updc: Sek : " + SekDateinameOrg, 2);
                    if (!this.isTest()) {
                        Datei.copyFile(String.valueOf(this.getSekundaerVerz()) + SekDateinameOrg);
                        fProt.prot("upd : Sek : " + DateinameOrg, 1);
                    }
                    ++this.Anzahl_upd_Datei;
                } else {
                    PrimZeit.setTime(Datei.lastModified());
                    long SekTime = DateiSekundaer.lastModified();
                    SekZeit.setTime(SekTime);
                    if (this.getToleranz() != 0) {
                        SekZeit.add(12, this.getToleranz());
                        SekTime = SekZeit.getTimeInMillis();
                    }
                    String PrimZeitString = PrimZeit.toGermanFormat();
                    String SekZeitString = SekZeit.toGermanFormat();
                    if (SekTime / 1000L < Datei.lastModified() / 1000L) {
                        fProt.prot("mod : Sek : " + SekDateiname + ", " + SekTime, 4);
                        fProt.prot("mod : Prim: " + Dateiname + ", " + Datei.lastModified(), 4);
                        fProt.prot("mod : Sek : " + SekDateiname + ", " + SekZeitString, 4);
                        fProt.prot("mod : Prim: " + Dateiname + ", " + PrimZeitString, 4);
                        fProt.prot("modc: Sek : " + SekDateiname, 3);
                        fProt.prot("updc: Sek : " + this.getSekundaerVerz() + SekDateinameOrg, 2);
                        if (!this.isTest()) {
                            Datei.copyFile(String.valueOf(this.getSekundaerVerz()) + SekDateinameOrg);
                            fProt.prot("upd : Sek : " + SekDateinameOrg, 1);
                        }
                        ++this.Anzahl_upd_Datei;
                    }
                }
            }
            ++i;
        }
    }

    public void alleDateienAusSekundaerAufStandVonPrimaerBringen() {
        FProt fProt = FProt.instance();
        FBefehl.instance();
        fProt.prot("++++ Neue und neuere Dateien in Primaer suchen und nach Sekundaer kopieren ++++", 2);
        HashMap<String, Integer> Sek = new HashMap<String, Integer>();
        HashMap<String, Integer> Kurz = new HashMap<String, Integer>();
        FFile Primaer = new FFile(this.getPrimaerVerz());
        FFile Sekundaer = new FFile(this.getSekundaerVerz());
        if (this.isBenutzenXCOPY() && !this.isTest()) {
            String[] Parm = new String[]{"/D", "/V", "/C", "/E", "/Y", String.valueOf(Primaer.getAbsolutePath()) + System.getProperty("file.separator") + "*.*", String.valueOf(Sekundaer.getAbsolutePath()) + System.getProperty("file.separator") + "*.*"};
            if (this.isProtokollohneHeader()) {
                Parm = FString.verbindenStringMitArray("/Q", Parm);
            }
            FBefehl.aufrufBefehl("XCOPY", Parm, 5);
        } else {
            int i;
            int max;
            int min;
            String[] ListeOrg = Sekundaer.listFileNames('A', true);
            String[] Liste2 = FString.arrayToLowerCase(ListeOrg, this.isIgnoreCase());
            fProt.prot("SekundaerListe alle Dateien:", 8);
            fProt.prot(Liste2, 8);
            Sek = FString.arrayToHashMap(Liste2, Sek);
            fProt.prot("SekundaerListe alle Dateien HashMap:", 8);
            fProt.prot(Sek.toString(), 9);
            if (this.getKuerzenAufLaenge() > 0) {
                String[] ListeKurz = FDatei.shortenDateinamen(Liste2, this.getKuerzenAufLaenge());
                fProt.prot("SekundaerListeKurz alle Dateien:", 8);
                fProt.prot(ListeKurz, 8);
                Kurz = FString.arrayToHashMap(ListeKurz, Kurz);
                fProt.prot("PrimaerListeKurz alle Dateien HashMap:", 8);
                fProt.prot(Kurz.toString(), 9);
            }
            String[] DateiListeOrg = Primaer.listFileNames();
            String[] DateiListe = FString.arrayToLowerCase(DateiListeOrg, this.isIgnoreCase());
            if (this.isSekundaerGrenzenBeachten() && ListeOrg.length > 0 && DateiListeOrg.length > 0) {
                fProt.prot("PrimaerListe vor Grenzen beachten:", 8);
                fProt.prot(DateiListe, 8);
                min = 0;
                max = DateiListe.length;
                i = 0;
                while (i < DateiListe.length) {
                    if (DateiListe[i].compareTo(Liste2[0]) >= 0) {
                        min = i;
                        break;
                    }
                    ++i;
                }
                i = min;
                while (i < DateiListe.length) {
                    if (DateiListe[i].compareTo(Liste2[Liste2.length - 1]) <= 0) {
                        max = i;
                        break;
                    }
                    ++i;
                }
                String[] Zwi = new String[max - min + 1];
                i = 0;
                while (i < Zwi.length) {
                    Zwi[i] = DateiListe[i + min];
                    ++i;
                }
                DateiListe = new String[Zwi.length];
                DateiListe = Zwi;
                i = 0;
                while (i < Zwi.length) {
                    Zwi[i] = DateiListeOrg[i + min];
                    ++i;
                }
                DateiListeOrg = new String[Zwi.length];
                DateiListeOrg = Zwi;
                fProt.prot("PrimaerListe nach Grenzen beachten:", 8);
                fProt.prot(DateiListe, 8);
            }
            this.abarbeitenDateiliste(DateiListe, DateiListeOrg, "", Liste2, ListeOrg, Sek, Kurz);
            String[] PrimaerListeOrg = Primaer.listFileNames('V', true);
            String[] PrimaerListe = FString.arrayToLowerCase(PrimaerListeOrg, this.isIgnoreCase());
            fProt.prot("PrimaerListe alle Verzeichnisse ohne Unterverzeichnisse:", 8);
            fProt.prot(PrimaerListe, 8);
            if (PrimaerListe.length > 0) {
                int erster = 0;
                int letzter = PrimaerListe.length - 1;
                fProt.prot("Min Primaer Original: " + PrimaerListe[erster], 6);
                fProt.prot("Max Primaer Original: " + PrimaerListe[letzter], 6);
                if (this.isSekundaerGrenzenBeachten()) {
                    String[] SekundaerListe = Sekundaer.listFileNames('V', true);
                    SekundaerListe = FString.arrayToLowerCase(SekundaerListe, this.isIgnoreCase());
                    fProt.prot("SekundaerListe alle Verzeichnisse mit Unterverzeichnisse:", 8);
                    fProt.prot(SekundaerListe, 8);
                    if (SekundaerListe.length > 0) {
                        i = 1;
                        while (i < SekundaerListe.length) {
                            fProt.prot(String.valueOf(i) + "-" + SekundaerListe[i], 8);
                            fProt.prot(String.valueOf(i - 1) + "-" + SekundaerListe[i - 1], 8);
                            if (!SekundaerListe[i].startsWith(SekundaerListe[i - 1])) break;
                            ++i;
                        }
                        min = i - 1;
                        max = SekundaerListe.length - 1;
                        fProt.prot("Min Sekundaer: " + SekundaerListe[min], 6);
                        fProt.prot("Max Sekundaer: " + SekundaerListe[max], 6);
                        i = 0;
                        while (i < PrimaerListe.length) {
                            if (PrimaerListe[i].compareToIgnoreCase(SekundaerListe[min]) >= 0 && erster == 0) {
                                erster = i;
                            }
                            if (PrimaerListe[i].compareToIgnoreCase(SekundaerListe[max]) == 0 && letzter == PrimaerListe.length - 1) {
                                letzter = i;
                                break;
                            }
                            if (PrimaerListe[i].compareToIgnoreCase(SekundaerListe[max]) > 0 && letzter == PrimaerListe.length - 1) {
                                letzter = i - 1;
                                break;
                            }
                            ++i;
                        }
                    }
                    fProt.prot("Min Primaer nach Abgleich: " + PrimaerListe[erster], 6);
                    fProt.prot("Max Primaer nach Abgleich: " + PrimaerListe[letzter], 6);
                }
                fProt.prot("Min Primaer: " + PrimaerListe[erster], 2);
                fProt.prot("Max Primaer: " + PrimaerListe[letzter], 2);
                i = erster;
                while (i <= letzter) {
                    fProt.prot("chk : Sek : " + PrimaerListe[i], 5);
                    Integer pos = Sek.get(PrimaerListe[i]);
                    if (pos == null) {
                        fProt.prot("notf: Sek : " + PrimaerListe[i], 5);
                        fProt.prot("mdc : Sek : " + PrimaerListeOrg[i], 2);
                        if (!this.isTest()) {
                            File DateiSekundaer = new File(this.getSekundaerVerz(), PrimaerListe[i]);
                            DateiSekundaer.mkdirs();
                            fProt.prot("md  : Sek : " + PrimaerListeOrg[i], 1);
                        }
                        ++this.Anzahl_crea_Verz;
                    }
                    FFile Verz = new FFile(this.getPrimaerVerz(), PrimaerListe[i]);
                    DateiListeOrg = Verz.listFileNames();
                    DateiListe = FString.arrayToLowerCase(DateiListeOrg, this.isIgnoreCase());
                    this.abarbeitenDateiliste(DateiListe, DateiListeOrg, PrimaerListe[i], Liste2, ListeOrg, Sek, Kurz);
                    ++i;
                }
            }
        }
    }

    public int getAnzahl_crea_Datei() {
        return this.Anzahl_crea_Datei;
    }

    public int getAnzahl_crea_Verz() {
        return this.Anzahl_crea_Verz;
    }

    public int getAnzahl_del_Datei() {
        return this.Anzahl_del_Datei;
    }

    public int getAnzahl_del_Verz() {
        return this.Anzahl_del_Verz;
    }

    public int getAnzahl_upd_Datei() {
        return this.Anzahl_upd_Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public int getKuerzenAufLaenge() {
        return this.KuerzenAufLaenge;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getPrimaerVerz() {
        return this.PrimaerVerz;
    }

    public String getSekundaerVerz() {
        return this.SekundaerVerz;
    }

    public String getStand() {
        return "20.3.2007";
    }

    public int getToleranz() {
        return this.Toleranz;
    }

    public String holenKurzprotokoll() {
        String Zeile = "";
        if (this.Anzahl_del_Verz + this.Anzahl_crea_Verz + this.Anzahl_del_Datei + this.Anzahl_crea_Datei + this.Anzahl_upd_Datei == 0) {
            Zeile = String.valueOf(this.getPrimaerVerz()) + " und " + this.getSekundaerVerz() + " identisch";
        } else {
            Zeile = "P:" + this.getPrimaerVerz() + ", S:" + this.getSekundaerVerz() + ", Abweichungen/Aktionen: ";
            Zeile = String.valueOf(Zeile) + "Verzeichnisse:";
            if (this.Anzahl_crea_Verz > 0) {
                Zeile = String.valueOf(Zeile) + " crea:" + this.Anzahl_crea_Verz;
            }
            if (this.Anzahl_del_Verz > 0) {
                Zeile = String.valueOf(Zeile) + " del:" + this.Anzahl_del_Verz;
            }
            Zeile = String.valueOf(Zeile) + ", Dateien:";
            if (this.Anzahl_crea_Datei > 0) {
                Zeile = String.valueOf(Zeile) + " crea:" + this.Anzahl_crea_Datei;
            }
            if (this.Anzahl_del_Datei > 0) {
                Zeile = String.valueOf(Zeile) + " del:" + this.Anzahl_del_Datei;
            }
            if (this.Anzahl_upd_Datei > 0) {
                Zeile = String.valueOf(Zeile) + " upd:" + this.Anzahl_upd_Datei;
            }
        }
        return Zeile;
    }

    public void initialisierenWerte() {
        this.Anzahl_del_Verz = 0;
        this.Anzahl_crea_Verz = 0;
        this.Anzahl_del_Datei = 0;
        this.Anzahl_crea_Datei = 0;
        this.Anzahl_upd_Datei = 0;
    }

    public boolean isBenutzenXCOPY() {
        return this.BenutzenXCOPY;
    }

    public boolean isIgnoreCase() {
        return this.IgnoreCase;
    }

    public boolean isProtokollohneHeader() {
        return this.ProtokollohneHeader;
    }

    public boolean isSekundaerGrenzenBeachten() {
        return this.SekundaerGrenzenBeachten;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTest() {
        return this.Test;
    }

    public void loeschenInSekundaerFallsNichtMehrInPrimaer() {
        FFile Datei;
        Integer pos;
        String Dateiname;
        FProt fProt = FProt.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        fProt.prot("++++ In Primaer nicht mehr vorhandene Dateien in Sekundaer loeschen ++++", 2);
        String DateinameKurz = "";
        HashMap<String, Integer> Prim = new HashMap<String, Integer>();
        HashMap<String, Integer> Kurz = new HashMap<String, Integer>();
        FFile Sekundaer = new FFile(this.getSekundaerVerz());
        FFile Primaer = new FFile(this.getPrimaerVerz());
        String[] SekundaerListe = Sekundaer.listFileNames('D', true);
        SekundaerListe = FString.arrayToLowerCase(SekundaerListe, this.isIgnoreCase());
        fProt.prot("SekundaerListe alle Dateien:", 8);
        fProt.prot(SekundaerListe, 8);
        String[] Liste2 = Primaer.listFileNames('D', true);
        Liste2 = FString.arrayToLowerCase(Liste2, this.isIgnoreCase());
        fProt.prot("PrimaerListe alle Dateien:", 8);
        fProt.prot(Liste2, 8);
        Prim = FString.arrayToHashMap(Liste2, Prim);
        fProt.prot("PrimaerListe alle Dateien HashMap:", 8);
        fProt.prot(Prim.toString(), 9);
        if (this.getKuerzenAufLaenge() > 0) {
            String[] ListeKurz = FDatei.shortenDateinamen(Liste2, this.getKuerzenAufLaenge());
            fProt.prot("PrimaerListeKurz alle Dateien:", 8);
            fProt.prot(ListeKurz, 8);
            Kurz = FString.arrayToHashMap(ListeKurz, Kurz);
            fProt.prot("PrimaerListeKurz alle Dateien HashMap:", 8);
            fProt.prot(Kurz.toString(), 9);
        }
        int i = 0;
        while (i < SekundaerListe.length) {
            Dateiname = SekundaerListe[i];
            fProt.prot("chk : Prim: " + Dateiname, 4);
            pos = Prim.get(Dateiname);
            if (pos == null && this.getKuerzenAufLaenge() > 0) {
                DateinameKurz = FDatei.shortenDateiname(Dateiname, this.getKuerzenAufLaenge());
                fProt.prot("chk1: Prim: " + DateinameKurz, 4);
                pos = Prim.get(DateinameKurz);
            }
            if (pos == null && this.getKuerzenAufLaenge() > 0) {
                fProt.prot("chk2: Sek : " + Dateiname + "->Prim:" + DateinameKurz, 4);
                pos = Kurz.get(Dateiname);
                if (pos != null) {
                    fProt.prot("fnd2: Sek : " + Dateiname + "->Prim:" + Liste2[pos], 5);
                }
            }
            if (pos == null) {
                fProt.prot("notf: Prim: " + Dateiname, 4);
                fProt.prot("delc: Sek : " + Dateiname, 2);
                Datei = new FFile(Sekundaer, Dateiname);
                if (!this.isTest()) {
                    Datei.delete();
                    fProt.prot("del : Sek : " + Dateiname, 1);
                }
                ++this.Anzahl_del_Datei;
            }
            ++i;
        }
        SekundaerListe = Sekundaer.listFileNames('V', true);
        SekundaerListe = FString.arrayToLowerCase(SekundaerListe, this.isIgnoreCase());
        SekundaerListe = fQuickSort.quickSort(SekundaerListe, false, false);
        fProt.prot("SekundaerListe alle Unterverzeichnisse:", 8);
        fProt.prot(SekundaerListe, 8);
        Primaer = new FFile(this.getPrimaerVerz());
        Liste2 = Primaer.listFileNames('V', true);
        Liste2 = FString.arrayToLowerCase(Liste2, this.isIgnoreCase());
        fProt.prot("PrimaerListe alle Verzeichnisse:", 8);
        fProt.prot(Liste2, 8);
        Prim = FString.arrayToHashMap(Liste2, Prim);
        fProt.prot("PrimaerListe alle Verzeichnisse HashMap:", 8);
        fProt.prot(Prim.toString(), 9);
        i = 0;
        while (i < SekundaerListe.length) {
            Dateiname = SekundaerListe[i];
            fProt.prot("chk : Prim: " + SekundaerListe[i], 4);
            pos = Prim.get(Dateiname);
            if (pos == null) {
                fProt.prot("notf: Prim: " + SekundaerListe[i], 4);
                fProt.prot("delc: Sek : " + SekundaerListe[i], 2);
                Datei = new FFile(Sekundaer, SekundaerListe[i]);
                if (!this.isTest()) {
                    Datei.delete();
                    fProt.prot("del : Sek : " + SekundaerListe[i], 1);
                }
                ++this.Anzahl_del_Verz;
            }
            ++i;
        }
    }

    public void run() {
        this.initialisierenWerte();
        if (this.getPrimaerVerz().length() > 0 && this.getSekundaerVerz().length() > 0) {
            this.loeschenInSekundaerFallsNichtMehrInPrimaer();
            this.alleDateienAusSekundaerAufStandVonPrimaerBringen();
            this.zeigenProtokoll();
        }
    }

    public void setAnzahl_crea_Datei(int anzahl_crea_Datei) {
        this.Anzahl_crea_Datei = anzahl_crea_Datei;
    }

    public void setAnzahl_crea_Verz(int anzahl_crea_Verz) {
        this.Anzahl_crea_Verz = anzahl_crea_Verz;
    }

    public void setAnzahl_del_Datei(int anzahl_del_Datei) {
        this.Anzahl_del_Datei = anzahl_del_Datei;
    }

    public void setAnzahl_del_Verz(int anzahl_del_Verz) {
        this.Anzahl_del_Verz = anzahl_del_Verz;
    }

    public void setAnzahl_upd_Datei(int anzahl_upd_Datei) {
        this.Anzahl_upd_Datei = anzahl_upd_Datei;
    }

    public void setBenutzenXCOPY() {
        this.BenutzenXCOPY = FParam.getBooleanParameter("BenutzenXCOPY", this.ArgTab);
    }

    public void setBenutzenXCOPY(boolean benutzenXCOPY) {
        this.BenutzenXCOPY = benutzenXCOPY;
    }

    public void setIgnoreCase() {
        this.IgnoreCase = FParam.getBooleanParameter("IgnoreCase", this.ArgTab);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.IgnoreCase = ignoreCase;
    }

    public void setKuerzenAufLaenge() {
        this.KuerzenAufLaenge = FParam.getIntParameter("KuerzenAufLaenge", this.ArgTab);
    }

    public void setKuerzenAufLaenge(int kuerzenAufLaenge) {
        FParam.instance();
        this.KuerzenAufLaenge = FParam.checkIntParameter("KuerzenAufLaenge", kuerzenAufLaenge, this.ArgTab);
    }

    public void setKuerzenAufLaenge(String kuerzenAufLaenge) {
        this.KuerzenAufLaenge = FParam.checkIntParameter("KuerzenAufLaenge", kuerzenAufLaenge, this.ArgTab);
    }

    public void setPrimaerVerz() {
        this.PrimaerVerz = FParam.getStringParameter("PrimaerVerz", this.ArgTab);
    }

    public void setPrimaerVerz(String primaerVerz) {
        FParam.instance();
        this.PrimaerVerz = FParam.checkStringParameter("PrimaerVerz", primaerVerz, this.ArgTab);
    }

    public void setProtokollohneHeader() {
        this.ProtokollohneHeader = FParam.getBooleanParameter("ProtokollohneHeader", this.ArgTab);
    }

    public void setProtokollohneHeader(boolean protokollohneHeader) {
        this.ProtokollohneHeader = protokollohneHeader;
    }

    public void setSekundaerGrenzenBeachten() {
        this.SekundaerGrenzenBeachten = FParam.getBooleanParameter("SekundaerGrenzenBeachten", this.ArgTab);
    }

    public void setSekundaerGrenzenBeachten(boolean sekundaerVerzeichnisGrenzenBeachten) {
        this.SekundaerGrenzenBeachten = sekundaerVerzeichnisGrenzenBeachten;
    }

    public void setSekundaerVerz() {
        this.SekundaerVerz = FParam.getStringParameter("SekundaerVerz", this.ArgTab);
    }

    public void setSekundaerVerz(String sekundaerVerz) {
        FParam.instance();
        this.SekundaerVerz = FParam.checkStringParameter("SekundaerVerz", sekundaerVerz, this.ArgTab);
    }

    public void setTest() {
        this.Test = FParam.getBooleanParameter("Test", this.ArgTab);
    }

    public void setTest(boolean test) {
        this.Test = test;
    }

    public void setToleranz() {
        this.Toleranz = FParam.getIntParameter("Toleranz", this.ArgTab);
    }

    public void setToleranz(int toleranz) {
        FParam.instance();
        this.Toleranz = FParam.checkIntParameter("Toleranz", toleranz, this.ArgTab);
    }

    public void setToleranz(String toleranz) {
        this.Toleranz = FParam.checkIntParameter("Toleranz", toleranz, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setPrimaerVerz();
        this.setSekundaerVerz();
        this.setBenutzenXCOPY();
        this.setTest();
        this.setToleranz();
        this.setKuerzenAufLaenge();
        this.setSekundaerGrenzenBeachten();
        this.setIgnoreCase();
        this.setProtokollohneHeader();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Verzeichnis (Primaer, fuehrend)                                                :" + this.getPrimaerVerz());
        fProt.prot("Spiegelverzeichnis (nach Ausf. gleicher Inhalt wie Primaer)                    :" + this.getSekundaerVerz());
        fProt.prot("Benutzen XCOPY                                                                 :" + this.isBenutzenXCOPY());
        fProt.prot("Testmodus                                                                      :" + this.isTest());
        fProt.prot("Toleranz (in Minuten)                                                          :" + this.getToleranz());
        fProt.prot("Dateinamen fuer Vergleich kuerzen auf (ohne Extent), Kuerzung nur falls Wert >0:" + this.getKuerzenAufLaenge());
        fProt.prot("Sekundaer Verzeichnisgrenzen beachten                                          :" + this.isSekundaerGrenzenBeachten());
        fProt.prot("Ignore Case                                                                    :" + this.isIgnoreCase());
        fProt.prot("Protokoll ohne Header                                                          :" + this.isProtokollohneHeader());
    }

    public void zeigenProtokoll() {
        FProt fProt = FProt.instance();
        if (!this.isProtokollohneHeader()) {
            fProt.prot("Protokoll");
            fProt.prot("---------");
        }
        if (this.isTest()) {
            if (this.Anzahl_del_Verz + this.Anzahl_crea_Verz + this.Anzahl_del_Datei + this.Anzahl_crea_Datei + this.Anzahl_upd_Datei == 0) {
                fProt.prot(String.valueOf(this.getPrimaerVerz()) + " und " + this.getSekundaerVerz() + " identisch");
            } else {
                fProt.prot("Durchzugefuehrende Aenderungen in: " + this.getSekundaerVerz());
                fProt.prot("Verzeichnisse zu erstellen : " + this.Anzahl_crea_Verz);
                fProt.prot("              zu loeschen  : " + this.Anzahl_del_Verz);
                fProt.prot("Dateien       zu erstellen : " + this.Anzahl_crea_Datei);
                fProt.prot("              zu loeschen  : " + this.Anzahl_del_Datei);
                fProt.prot("              zu erneuern  : " + this.Anzahl_upd_Datei);
            }
        } else if (this.isBenutzenXCOPY()) {
            if (this.Anzahl_del_Verz + this.Anzahl_del_Datei == 0) {
                fProt.prot("Keine Verzeichnisse oder Dateien aus '" + this.getSekundaerVerz() + "' geloescht");
            } else {
                fProt.prot("Durchgefuehrte Aenderungen in: " + this.getPrimaerVerz());
                fProt.prot("Verzeichnisse geloescht : " + this.Anzahl_del_Verz);
                fProt.prot("Dateien       geloescht : " + this.Anzahl_del_Datei);
            }
            fProt.prot("Statistik zur Erstellung und Erneuerung von Dateien siehe XCOPY-output");
        } else if (this.Anzahl_del_Verz + this.Anzahl_crea_Verz + this.Anzahl_del_Datei + this.Anzahl_crea_Datei + this.Anzahl_upd_Datei == 0) {
            fProt.prot(String.valueOf(this.getPrimaerVerz()) + " und " + this.getSekundaerVerz() + " identisch");
        } else {
            fProt.prot("Durchgefuehrte Aenderungen in: " + this.getSekundaerVerz());
            if (this.Anzahl_crea_Verz > 0) {
                fProt.prot("Verzeichnisse erstellt  : " + this.Anzahl_crea_Verz);
            }
            if (this.Anzahl_del_Verz > 0) {
                fProt.prot("Verzeichnisse geloescht : " + this.Anzahl_del_Verz);
            }
            if (this.Anzahl_crea_Datei > 0) {
                fProt.prot("Dateien       erstellt  : " + this.Anzahl_crea_Datei);
            }
            if (this.Anzahl_del_Datei > 0) {
                fProt.prot("Dateien       geloescht : " + this.Anzahl_del_Datei);
            }
            if (this.Anzahl_upd_Datei > 0) {
                fProt.prot("Dateien       erneuert  : " + this.Anzahl_upd_Datei);
            }
        }
    }
}

