/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.ChangeChars;
import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import de.nss.jfi.Uti.JpegExif;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class FFile
extends File {
    private static final long serialVersionUID = 1L;
    FileInputStream LesenDatei = null;
    private final ArrayList<String> Dateien = new ArrayList();
    private BufferedWriter Liste = null;
    private String listBasisPfad;
    private int TiefeListRekursiv = 0;
    final int Ausgabe_alle_X = 1000;
    private String auswahlDatei = "";
    private boolean auswahlDateiExclude = false;
    private boolean ausgabeNurNamen = false;
    private boolean ausgabeVerzeichnisRelativ = false;
    private boolean auswahlVerzeichnisExclude = false;
    private boolean auswahlDateiIgnoreCase = true;
    private boolean auswahlVerzeichnisIgnoreCase = true;
    private String auswahlVerzeichnis = "";
    private String auswahlAusgabeListe = "";
    private long auswahlGroesse = 0L;
    private char auswahlDatumZeitArt = (char)68;
    private int auswahlAnzahlDateien = 0;
    private int auswahlTiefe = -1;
    private int auswahlHardLinkCount = 1;
    private boolean auswahlAusgabeNurInDatei = false;
    private boolean auswahlNurBilder = false;
    private boolean auswahlNurVideos = false;
    private boolean presortFiles = false;
    private boolean ausgabeDateien = true;
    private boolean ausgabeVerzeichnisse = false;
    private boolean SortiereAufsteigend = true;
    private boolean SortiereNachDatum = false;
    private boolean SortiereNachGroesse = false;
    private boolean SortiereNachNamen = true;
    private long auswahlStichtag = 0L;
    private boolean auswahlStichVergleichAelter = false;

    public static int findAndCountChar(char[] tab, int anzahlSpalten, char charIn) {
        int pos = -1;
        int i = 0;
        while (i < anzahlSpalten) {
            if (tab[i] == charIn) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            tab[anzahlSpalten] = charIn;
            pos = anzahlSpalten;
        }
        return pos;
    }

    private static boolean isAudio(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".WAV") || Name.endsWith(".MP3") || Name.endsWith(".OGG") || Name.endsWith(".FLAC") || Name.endsWith(".AIFF");
    }

    private static boolean isGIF(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".GIF");
    }

    private static boolean isMovie(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".AVI") || Name.endsWith(".MP4") || Name.endsWith(".MPEG") || Name.endsWith(".MPG") || Name.endsWith(".TS") || Name.endsWith(".MOV");
    }

    private static boolean isMP3File(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".MP3");
    }

    private static boolean isPDF(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".PDF");
    }

    private static boolean isPicture(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".JPG") || Name.endsWith(".JPEG") || Name.endsWith(".GIF") || Name.endsWith(".TIF") || Name.endsWith(".BMP") || Name.endsWith(".PNG") || Name.endsWith(".TIF");
    }

    private static boolean isVideo(String inName) {
        String Name = inName.toUpperCase();
        return Name.endsWith(".MPG") || Name.endsWith(".MPEG") || Name.endsWith(".MP4") || Name.endsWith(".MOV") || Name.endsWith(".MV4") || Name.endsWith(".M4V");
    }

    public FFile(File dir, String name) {
        super(dir, name);
    }

    public FFile(String path) {
        super(path);
    }

    public FFile(String path, String name) {
        super(path, name);
    }

    public FFile(URI uri) {
        super(uri);
    }

    public boolean checkDateiGegenAuswahl(File file, String verz) {
        FProt fProt = FProt.instance();
        fProt.prot("checkD: V:" + verz + ", F:" + file.getName(), 3);
        boolean found = true;
        if (this.isAuswahlNurBilder() && !FFile.isPicture(file.getName())) {
            found = false;
        }
        if (this.isAuswahlNurVideos() && !FFile.isMovie(file.getName())) {
            found = false;
        }
        if (found) {
            if (this.getAuswahlDatei().length() > 0) {
                try {
                    if (this.isAuswahlDateiIgnoreCase()) {
                        if (file.getName().toUpperCase().matches(this.getAuswahlDatei().toUpperCase()) == this.isAuswahlDateiExclude()) {
                            found = false;
                        }
                    } else if (file.getName().matches(this.getAuswahlDatei()) == this.isAuswahlDateiExclude()) {
                        found = false;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (found && this.getAuswahlVerzeichnis().length() > 0) {
                try {
                    if (this.isAuswahlVerzeichnisIgnoreCase()) {
                        if (verz.toUpperCase().matches(this.getAuswahlVerzeichnis().toUpperCase()) == this.isAuswahlVerzeichnisExclude()) {
                            found = false;
                        }
                    } else if (verz.matches(this.getAuswahlVerzeichnis()) == this.isAuswahlVerzeichnisExclude()) {
                        found = false;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (found && this.getGroesse() != 0L) {
                if (this.getGroesse() > 0L && file.length() < this.getGroesse()) {
                    found = false;
                }
                if (this.getGroesse() < 0L && file.length() >= -this.getGroesse()) {
                    found = false;
                }
            }
            if (found && this.getHardLinkCount() != 0) {
                if (this.getHardLinkCount() > 0 && FDatei.getHardlinkCount(file.getAbsolutePath()) < this.getHardLinkCount()) {
                    found = false;
                }
                if (this.getHardLinkCount() < 0 && FDatei.getHardlinkCount(file.getAbsolutePath()) >= -this.getHardLinkCount()) {
                    found = false;
                }
            }
            if (found && this.getAuswahlStichtag() > 0L) {
                if (this.isAuswahlStichVergleichAelter() && file.lastModified() >= this.getAuswahlStichtag()) {
                    found = false;
                }
                if (!this.isAuswahlStichVergleichAelter() && file.lastModified() <= this.getAuswahlStichtag()) {
                    found = false;
                }
            }
        }
        return found;
    }

    public boolean checkVerzeichnisGegenAuswahl(String verz, int anzahl) {
        FProt fProt = FProt.instance();
        fProt.prot("checkV: V:" + verz + ", A:" + anzahl, 3);
        boolean found = true;
        this.isAusgabeVerzeichnisse();
        if (found) {
            if (this.getAuswahlVerzeichnis().length() > 0) {
                try {
                    if (this.isAuswahlVerzeichnisIgnoreCase()) {
                        if (verz.toUpperCase().matches(this.getAuswahlVerzeichnis().toUpperCase()) == this.isAuswahlVerzeichnisExclude()) {
                            found = false;
                        }
                    } else if (verz.matches(this.getAuswahlVerzeichnis()) == this.isAuswahlVerzeichnisExclude()) {
                        found = false;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (found && this.getAuswahlAnzahlDateien() != 0L) {
                if (this.getAuswahlAnzahlDateien() > 0L && (long)anzahl < this.getAuswahlAnzahlDateien()) {
                    found = false;
                }
                if (this.getAuswahlAnzahlDateien() < 0L && (long)anzahl >= -this.getAuswahlAnzahlDateien()) {
                    found = false;
                }
            }
        }
        return found;
    }

    public void close() {
        this.inhaltToByteArray(1, true);
    }

    public void copyFile(String toDatei) {
        this.copyFile(toDatei, Short.MAX_VALUE, true, false);
    }

    public void copyFile(String toDatei, boolean ResetDate) {
        this.copyFile(toDatei, Short.MAX_VALUE, ResetDate, false);
    }

    public void copyFile(String toDatei, boolean ResetDate, boolean LeereDatei) {
        this.copyFile(toDatei, Short.MAX_VALUE, ResetDate, LeereDatei);
    }

    public void copyFile(String toDatei, int PufferGroesse) {
        this.copyFile(toDatei, PufferGroesse, true, false);
    }

    public void copyFile(String toDatei, int PufferGroesse, boolean ResetDate) {
        this.copyFile(toDatei, PufferGroesse, ResetDate, false);
    }

    public void copyFile(String toDatei, int PufferGroesse, boolean ResetDate, boolean LeereDatei) {
        byte[] Array2 = new byte[PufferGroesse];
        if (this.exists() && this.canRead()) {
            String ZielPfads;
            FFile Ziel = new FFile(toDatei);
            if (!Ziel.exists() && (ZielPfads = Ziel.getParent()) != null) {
                FFile ZielPfad = new FFile(ZielPfads);
                ZielPfad.mkdirs();
            }
            try {
                FileInputStream in = new FileInputStream(this);
                FileOutputStream out = new FileOutputStream(toDatei);
                if (!LeereDatei) {
                    int Anzahl;
                    while ((Anzahl = in.read(Array2)) >= 0) {
                        out.write(Array2, 0, Anzahl);
                    }
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            if (ResetDate) {
                File mod = new File(toDatei);
                mod.setLastModified(this.lastModified());
            }
        }
    }

    public int CountChar(char charIn) {
        int anzahl = 0;
        BufferedReader in = FDatei.openBufferedReader(this.getAbsolutePath());
        if (in != null) {
            try {
                String zeile;
                while ((zeile = in.readLine()) != null) {
                    int i = 0;
                    while (i < zeile.length()) {
                        if (zeile.charAt(i) == charIn) {
                            ++anzahl;
                        }
                        ++i;
                    }
                }
                in.close();
            }
            catch (IOException e) {
                FProt.instance().prot(e.getMessage());
                e.printStackTrace();
            }
        }
        return anzahl;
    }

    public String[][] CountChars() {
        int posChar = 0;
        int anzahlSpalten = 0;
        int maxChars = 2000;
        char[] chars = new char[2000];
        int[] anzahl = new int[2000];
        BufferedReader in = FDatei.openBufferedReader(this.getAbsolutePath());
        String[][] aus = new String[][]{{"", "0"}};
        if (in != null) {
            try {
                String zeile;
                while ((zeile = in.readLine()) != null) {
                    int i = 0;
                    while (i < zeile.length()) {
                        int n = posChar = FFile.findAndCountChar(chars, anzahlSpalten, zeile.charAt(i));
                        anzahl[n] = anzahl[n] + 1;
                        anzahlSpalten = Math.max(anzahlSpalten, posChar + 1);
                        ++i;
                    }
                }
                in.close();
            }
            catch (IOException e) {
                FProt.instance().prot(e.getMessage());
                e.printStackTrace();
            }
            aus = new String[anzahlSpalten][2];
            int i = 0;
            while (i < anzahlSpalten) {
                aus[i][0] = Character.toString(chars[i]);
                aus[i][1] = String.valueOf(anzahl[i]);
                ++i;
            }
        }
        return aus;
    }

    public boolean delete(boolean erase) {
        Futi futi = Futi.instance();
        boolean RC = false;
        if (erase) {
            RC = this.delete();
        } else {
            String papierkorb = futi.getPapierkorb();
            if (papierkorb.length() > 0) {
                FDatei.DateinamenTeile Teile = FDatei.instance().zerlegeDateiname(this.getAbsolutePath());
                String toPath = String.valueOf(papierkorb) + Teile.getPfad().substring(Teile.getPfad().indexOf(System.getProperty("file.separator")));
                FDatei.checkDatei(toPath, 'V', 'W', "Verzeichnis im Papierkorb");
                File toPapierkorb = new File(toPath, String.valueOf(Teile.getName()) + "." + Teile.getExtend());
                int lfdNr = 1;
                while (toPapierkorb.exists()) {
                    toPapierkorb = new File(toPath, String.valueOf(Teile.getName()) + ";(" + lfdNr++ + ")." + Teile.getExtend());
                }
                try {
                    RC = this.renameTo(toPapierkorb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return RC;
    }

    public void deleteDirectory() {
        this.deleteDirectory(this);
    }

    public void deleteDirectory(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        directory.delete();
    }

    public void deleteDirectoryIfExist() {
        if (this.exists()) {
            this.deleteDirectory(this);
        }
    }

    public void deleteIfExits() {
        if (this.exists()) {
            this.delete();
        }
    }

    public void disableSortieren() {
        this.SortiereNachNamen = false;
        this.SortiereNachDatum = false;
        this.SortiereNachGroesse = false;
    }

    public String getAttributes() {
        String attributes = "";
        if (!this.exists()) {
            attributes = String.valueOf(attributes) + "file not found";
        }
        if (this.isDirectory()) {
            attributes = String.valueOf(attributes) + "D";
        }
        if (this.canWrite()) {
            attributes = String.valueOf(attributes) + "W";
        }
        if (this.canRead()) {
            attributes = String.valueOf(attributes) + "R";
        }
        if (this.isPicture()) {
            attributes = String.valueOf(attributes) + "P";
        }
        if (this.isVideo()) {
            attributes = String.valueOf(attributes) + "V";
        }
        if (this.isMP3File()) {
            attributes = String.valueOf(attributes) + "M";
        }
        if (this.isHidden()) {
            attributes = String.valueOf(attributes) + "H";
        }
        return attributes;
    }

    public long getAuswahlAnzahlDateien() {
        return this.auswahlAnzahlDateien;
    }

    public String getAuswahlAusgabeListe() {
        return this.auswahlAusgabeListe;
    }

    public String getAuswahlDatei() {
        return this.auswahlDatei;
    }

    public char getAuswahlDatumZeitArt() {
        return this.auswahlDatumZeitArt;
    }

    public long getAuswahlGroesse() {
        return this.auswahlGroesse;
    }

    public long getAuswahlStichtag() {
        return this.auswahlStichtag;
    }

    public int getAuswahlTiefe() {
        return this.auswahlTiefe;
    }

    public String getAuswahlVerzeichnis() {
        return this.auswahlVerzeichnis;
    }

    public long getGroesse() {
        return this.auswahlGroesse;
    }

    public int getHardLinkCount() {
        return this.auswahlHardLinkCount;
    }

    public String getJpegExifBildbeschreibung() {
        String Beschreibung = JpegExif.getJpegExifWichtigeTags(this).getBeschreibung();
        if (Beschreibung.length() > 0) {
            ChangeChars changeChars = ChangeChars.instance();
            changeChars.setExterneZeile(Beschreibung);
            changeChars.setKonvertierung("U");
            changeChars.run();
            Beschreibung = changeChars.getExterneZeile();
        }
        return Beschreibung;
    }

    public String getListBasisPfad() {
        return this.listBasisPfad;
    }

    public String getStandardWerte() {
        String Ausgabe = "";
        if (this.exists()) {
            Ausgabe = String.valueOf(this.lastModifiedString()) + "\t" + this.length() + "\t" + this.getName() + "\t" + this.getAbsolutePath().substring(0, this.getAbsolutePath().lastIndexOf("\\"));
        }
        return Ausgabe;
    }

    public ArrayList<Byte> inhaltToByteArray() {
        return this.inhaltToByteArrayList(-1);
    }

    public byte[] inhaltToByteArray(int anzahl) {
        return this.inhaltToByteArray(anzahl, false);
    }

    public byte[] inhaltToByteArray(int anzahl, boolean close) {
        byte[] Ausgabe = new byte[(int)(this.length() < (long)anzahl ? this.length() : (long)anzahl)];
        if (this.exists()) {
            try {
                if (this.LesenDatei == null) {
                    this.LesenDatei = new FileInputStream(this);
                }
                this.LesenDatei.read(Ausgabe);
                if (close) {
                    this.LesenDatei.close();
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return Ausgabe;
    }

    public ArrayList<Byte> inhaltToByteArrayList(int anzahl) {
        ArrayList<Byte> Ausgabe = new ArrayList<Byte>();
        if (this.exists()) {
            try {
                FileInputStream lesenDatei = new FileInputStream(this);
                byte[] b = new byte[1];
                while (lesenDatei.available() > 0) {
                    lesenDatei.read(b);
                    Ausgabe.add(new Byte(b[0]));
                    if (anzahl > 0 && Ausgabe.size() > anzahl) break;
                }
                lesenDatei.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return Ausgabe;
    }

    public String inhaltToString() {
        return this.inhaltToString("");
    }

    public String inhaltToString(String charset) {
        return FString.stringArrayToString(this.inhaltToStringArray(charset));
    }

    public String[] inhaltToStringArray() {
        return this.inhaltToStringArray("");
    }

    public String[] inhaltToStringArray(String charset) {
        return FString.arrayListToStringArray(this.inhaltToStringArrayList(charset));
    }

    public ArrayList<String> inhaltToStringArrayList() {
        return this.inhaltToStringArrayList("");
    }

    public ArrayList<String> inhaltToStringArrayList(String charset) {
        ArrayList<String> Ausgabe = new ArrayList<String>();
        if (this.exists()) {
            try {
                String Zeile;
                BufferedReader lesenDatei = null;
                lesenDatei = charset.length() > 1 && Charset.isSupported(charset) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this), charset)) : new BufferedReader(new FileReader(this));
                while ((Zeile = lesenDatei.readLine()) != null) {
                    Ausgabe.add(Zeile);
                }
                lesenDatei.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return Ausgabe;
    }

    public boolean isAudio() {
        return FFile.isAudio(this.getName());
    }

    public boolean isAusgabeDateien() {
        return this.ausgabeDateien;
    }

    public boolean isAusgabeNurNamen() {
        return this.ausgabeNurNamen;
    }

    public boolean isAusgabeVerzeichnisRelativ() {
        return this.ausgabeVerzeichnisRelativ;
    }

    public boolean isAusgabeVerzeichnisse() {
        return this.ausgabeVerzeichnisse;
    }

    public boolean isAuswahlAusgabeNurInDatei() {
        return this.auswahlAusgabeNurInDatei;
    }

    public boolean isAuswahlDateiExclude() {
        return this.auswahlDateiExclude;
    }

    public boolean isAuswahlDateiIgnoreCase() {
        return this.auswahlDateiIgnoreCase;
    }

    public boolean isAuswahlNurBilder() {
        return this.auswahlNurBilder;
    }

    public boolean isAuswahlNurVideos() {
        return this.auswahlNurVideos;
    }

    public boolean isAuswahlStichVergleichAelter() {
        return this.auswahlStichVergleichAelter;
    }

    public boolean isAuswahlVerzeichnisExclude() {
        return this.auswahlVerzeichnisExclude;
    }

    public boolean isAuswahlVerzeichnisIgnoreCase() {
        return this.auswahlVerzeichnisIgnoreCase;
    }

    public boolean isBinaryEqualTo(File test) {
        boolean rc = false;
        if (this.length() == test.length()) {
            try {
                int value1;
                BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(this));
                BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(test));
                rc = true;
                do {
                    int value2;
                    if ((value1 = ((InputStream)in1).read()) == (value2 = ((InputStream)in2).read())) continue;
                    rc = false;
                    break;
                } while (value1 >= 0);
                ((InputStream)in1).close();
                ((InputStream)in2).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rc;
    }

    public boolean isGIF() {
        return FFile.isGIF(this.getName());
    }

    public boolean isMP3File() {
        return FFile.isMP3File(this.getName());
    }

    public boolean isPDF() {
        return FFile.isPDF(this.getName());
    }

    public boolean isPicture() {
        return FFile.isPicture(this.getName());
    }

    private boolean isPresortFiles() {
        return this.presortFiles;
    }

    public boolean isSortiereAufsteigend() {
        return this.SortiereAufsteigend;
    }

    public boolean isSortiereNachDatum() {
        return this.SortiereNachDatum;
    }

    public boolean isSortiereNachGroesse() {
        return this.SortiereNachGroesse;
    }

    public boolean isSortiereNachNamen() {
        return this.SortiereNachNamen;
    }

    public boolean isVideo() {
        return FFile.isVideo(this.getName());
    }

    public String lastModifiedString() {
        return this.lastModifiedString(' ');
    }

    public String lastModifiedString(char Art) {
        FGregorianCalendar ZeitCal = new FGregorianCalendar();
        ZeitCal.clear();
        ZeitCal.setTime(this.lastModified());
        return ZeitCal.toGermanFormat(Art);
    }

    public String[] listFileNames() {
        return this.listFileNames('D', false);
    }

    public String[] listFileNames(boolean mitUnterverzeichnissen) {
        return this.listFileNames('D', mitUnterverzeichnissen);
    }

    public String[] listFileNames(char Auswahl, boolean mitUnterverzeichnissen) {
        return this.listFileNames(Auswahl, mitUnterverzeichnissen ? -1 : 0, "");
    }

    public String[] listFileNames(char Auswahl, int unterverzeichnisTiefe, String auswahlVerzeichnisse) {
        FQuickSort fQuickSort = FQuickSort.instance();
        this.setAusgabeVerzeichnisRelativ(true);
        this.setAusgabeNurNamen(true);
        this.setAuswahlTiefe(unterverzeichnisTiefe);
        this.setAuswahlVerzeichnis(auswahlVerzeichnisse);
        switch (Character.toUpperCase(Auswahl)) {
            case 'B': 
            case 'b': {
                this.setAuswahlNurBilder(true);
                this.setAusgabeDateien(true);
                break;
            }
            case 'M': 
            case 'm': {
                this.setAuswahlNurVideos(true);
                this.setAusgabeDateien(true);
                break;
            }
            case 'D': 
            case 'd': {
                this.setAusgabeDateien(true);
                break;
            }
            case 'V': 
            case 'v': {
                this.setAusgabeVerzeichnisse(true);
                break;
            }
            case 'A': 
            case 'a': {
                this.setAusgabeDateien(true);
                break;
            }
            default: {
                this.setAusgabeDateien(true);
            }
        }
        String[] FileNames = this.listjfi();
        if (Auswahl == 'A') {
            this.setAusgabeVerzeichnisse(true);
            FileNames = FString.verbindenStringArray(FileNames, this.listjfi());
            FileNames = fQuickSort.quickSort(FileNames, true, true);
        }
        return FileNames;
    }

    public String[] listjfi() {
        FProt fProt = FProt.instance();
        FString fString = FString.instance();
        NumberFormat nf = NumberFormat.getInstance();
        ArrayList<String> work = new ArrayList<String>();
        this.writeInDateiInit();
        this.Dateien.clear();
        this.TiefeListRekursiv = 0;
        this.setListBasisPfad(this.toString());
        long[] Upper = this.listjfi("");
        Upper[7] = Upper[7] + 1L;
        if (this.checkVerzeichnisGegenAuswahl(this.toString(), (int)Upper[0])) {
            Upper[4] = Upper[4] + 1L;
            Upper[5] = Upper[5] + 1L;
            if (this.isAusgabeVerzeichnisse()) {
                FGregorianCalendar ZeitCal = new FGregorianCalendar();
                ZeitCal.setTimeInMillis(this.lastModified());
                String Zeile = String.valueOf(ZeitCal.toGermanFormat(this.getAuswahlDatumZeitArt())) + "\t" + Upper[0] + "\t" + Upper[1] + "\t" + this.getPath();
                this.writeInDatei(Zeile);
                if (!this.isAuswahlAusgabeNurInDatei()) {
                    this.Dateien.add(Zeile);
                }
            }
        }
        this.writeInDateiClose();
        fProt.prot("Statitik gesamt:" + this.toString() + "\t #DK:" + nf.format(Upper[0]) + "\t #D:" + nf.format(Upper[1]) + "\t GK:" + nf.format(Upper[2]) + "\t G:" + nf.format(Upper[3]) + "\t #VK:" + nf.format(Upper[4]) + "\t #V:" + nf.format(Upper[5]) + "\t #SD:" + nf.format(Upper[6]) + "\t #SV:" + nf.format(Upper[7]) + "\t #SG:" + nf.format(Upper[8]), 3);
        fProt.prot(String.valueOf(this.toString()) + " gefunden: " + nf.format(Upper[0]) + " Dat., " + nf.format(Upper[4]) + " Verz., " + nf.format(Upper[2]) + " Bytes, durchsucht: " + nf.format(Upper[6]) + " Dat., " + nf.format(Upper[7]) + " Verz., " + nf.format(Upper[8]) + " Bytes", 1);
        fProt.prot("Auswahl Dateien: " + this.zeigeAuswahlDateien(), 1);
        fProt.prot("!-Verzeichnisse: " + this.zeigeAuswahlVerzeichnisse(), 1);
        fProt.prot("!-------Ausgabe: " + this.zeigeAusgabeTypen(), 1);
        String[] ausgabe = FString.arrayListToStringArray(this.Dateien);
        this.Dateien.clear();
        if (ausgabe.length > 0) {
            if (this.isSortiereNachNamen() || this.isSortiereNachDatum() || this.isSortiereNachGroesse()) {
                ausgabe = this.sortierenListe(ausgabe);
            }
            if (this.isAusgabeNurNamen()) {
                String[][] tab = fString.convertStringArrayToTabelle(ausgabe, 5);
                if (this.isAusgabeVerzeichnisRelativ()) {
                    int j = this.getListBasisPfad().length() + 1;
                    int i = 0;
                    while (i < tab.length) {
                        String zeile;
                        if (tab[i][3].length() > j) {
                            zeile = String.valueOf(tab[i][3].substring(j)) + (this.isAusgabeVerzeichnisse() ? "" : String.valueOf(System.getProperty("file.separator")) + tab[i][2]);
                        } else {
                            String string = zeile = this.isAusgabeVerzeichnisse() ? "" : tab[i][2];
                        }
                        if (zeile.length() > 0) {
                            work.add(zeile);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < tab.length) {
                        String zeile = String.valueOf(tab[i][3]) + (this.isAusgabeVerzeichnisse() ? "" : String.valueOf(System.getProperty("file.separator")) + tab[i][2]);
                        if (zeile.length() > 0) {
                            work.add(zeile);
                        }
                        ++i;
                    }
                }
                ausgabe = FString.arrayListToStringArray(work);
            } else if (this.isAusgabeVerzeichnisRelativ()) {
                String[][] tab = fString.convertStringArrayToTabelle(ausgabe, 5);
                int j = this.getListBasisPfad().length() + 1;
                int i = 0;
                while (i < tab.length) {
                    ausgabe[i] = tab[i][3].length() > j ? String.valueOf(tab[i][0]) + "\t" + tab[i][1] + "\t" + tab[i][2] + "\t" + tab[i][3].substring(j) + "\t" + tab[i][4] : String.valueOf(tab[i][0]) + "\t" + tab[i][1] + "\t" + tab[i][2] + "\t" + tab[i][3] + "\t" + tab[i][4];
                    ++i;
                }
            }
        }
        return ausgabe;
    }

    public long[] listjfi(String verz) {
        File[] Files2;
        FProt fProt = FProt.instance();
        long[] RC = new long[9];
        long[] Upper = new long[9];
        String Verz = verz;
        ++this.TiefeListRekursiv;
        FGregorianCalendar ZeitCal = new FGregorianCalendar();
        if (Verz != null && Verz.length() > 0) {
            File VerzF = new File(Verz);
            Files2 = VerzF.listFiles();
        } else {
            Files2 = this.listFiles();
            Verz = this.getPath();
        }
        fProt.prot("list  : V:" + Verz + ", D Start:" + this.TiefeListRekursiv, 3);
        if (Files2 != null) {
            int[] ix = new int[Files2.length];
            if (this.isPresortFiles()) {
                String[] FileSort = new String[Files2.length];
                int i = 0;
                while (i < Files2.length) {
                    FileSort[i] = String.valueOf(Files2[i].getName()) + "\t" + i;
                    ++i;
                }
                FileSort = FQuickSort.instance().quickSort(FileSort);
                i = 0;
                while (i < FileSort.length) {
                    ix[i] = Integer.parseInt(FileSort[i].split("\t")[1]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < Files2.length) {
                    ix[i] = i;
                    ++i;
                }
            }
            int lfdNr = 1;
            int[] nArray = ix;
            int n = ix.length;
            int n2 = 0;
            while (n2 < n) {
                String Zeile;
                int element2 = nArray[n2];
                File element = Files2[element2];
                if (element.isDirectory()) {
                    RC[7] = RC[7] + 1L;
                    if (this.getAuswahlTiefe() < 0 || this.TiefeListRekursiv <= this.getAuswahlTiefe()) {
                        Upper = this.listjfi(element.getPath());
                        RC[0] = RC[0] + Upper[0];
                        RC[2] = RC[2] + Upper[2];
                        RC[4] = RC[4] + Upper[4];
                        RC[6] = RC[6] + Upper[6];
                        RC[7] = RC[7] + Upper[7];
                        RC[8] = RC[8] + Upper[8];
                    }
                    if (this.checkVerzeichnisGegenAuswahl(element.getPath(), (int)Upper[0])) {
                        RC[4] = RC[4] + 1L;
                        RC[5] = RC[5] + 1L;
                        if (this.isAusgabeVerzeichnisse()) {
                            ZeitCal.setTimeInMillis(element.lastModified());
                            Zeile = Upper[0] != 0L && Upper[0] == Upper[1] ? String.valueOf(ZeitCal.toGermanFormat(this.getAuswahlDatumZeitArt())) + "\t" + Upper[0] + "\t-" + Upper[3] + "\t" + element.getPath() : String.valueOf(ZeitCal.toGermanFormat(this.getAuswahlDatumZeitArt())) + "\t" + Upper[0] + "\t" + Upper[1] + "\t" + element.getPath();
                            this.writeInDatei(Zeile);
                            if (!this.isAuswahlAusgabeNurInDatei()) {
                                this.Dateien.add(Zeile);
                            }
                        }
                    }
                } else {
                    RC[6] = RC[6] + 1L;
                    long dateiGroesse = element.length();
                    RC[8] = RC[8] + dateiGroesse;
                    if (this.checkDateiGegenAuswahl(element, Verz)) {
                        RC[0] = RC[0] + 1L;
                        RC[1] = RC[1] + 1L;
                        RC[2] = RC[2] + dateiGroesse;
                        RC[3] = RC[3] + dateiGroesse;
                        if (this.isAusgabeDateien()) {
                            ZeitCal.setTimeInMillis(element.lastModified());
                            Zeile = String.valueOf(ZeitCal.toGermanFormat(this.getAuswahlDatumZeitArt())) + "\t" + element.length() + "\t" + element.getName() + "\t";
                            int pos = element.getPath().length() - element.getName().length();
                            if (pos > 1) {
                                Zeile = String.valueOf(Zeile) + element.getPath().substring(0, pos - 1);
                            }
                            this.writeInDatei(Zeile);
                            if (!this.isAuswahlAusgabeNurInDatei()) {
                                this.Dateien.add(String.valueOf(Zeile) + "\t" + lfdNr++);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        fProt.prot("D Ende :" + this.TiefeListRekursiv + ", V:" + Verz, 3);
        fProt.prot("Statistik:" + Verz + "\t #DK:" + RC[0] + "\t #D:" + RC[1] + "\t GK:" + RC[2] + "\t G:" + RC[3] + "\t #VK:" + RC[4] + "\t #V:" + RC[5] + "\t #SD:" + RC[6] + "\t #SV:" + RC[7] + "\t #SG:" + RC[8], 3);
        --this.TiefeListRekursiv;
        return RC;
    }

    public String renameTo(String toDatei) {
        return this.renameTo(toDatei, 100);
    }

    public String renameTo(String toDatei, int anzVersuche) {
        boolean done = false;
        String neuerName = "";
        if (this.exists()) {
            int i = 0;
            String dateiNeu = toDatei;
            FDatei.DateinamenTeile teile = FDatei.instance().zerlegeDateiname(toDatei);
            String base = String.valueOf(teile.getPfad()) + System.getProperty("file.separator") + teile.getName();
            while (!done && i < anzVersuche) {
                File test = new File(dateiNeu);
                if (!test.exists() && (done = this.renameTo(test))) {
                    neuerName = dateiNeu;
                }
                dateiNeu = String.valueOf(base) + "(" + ++i + ")." + teile.getExtend();
            }
        }
        return neuerName;
    }

    public String renameTo(String toPath, String toDatei) {
        return this.renameTo(String.valueOf(FDatei.pruefenPfadname(toPath, true)) + toDatei, 100);
    }

    public String renameTo(String toPath, String toDatei, int anzVersuche) {
        return this.renameTo(String.valueOf(FDatei.pruefenPfadname(toPath, true)) + toDatei, anzVersuche);
    }

    public void setAusgabeDateien(boolean auswahlNurDateien1) {
        this.ausgabeDateien = auswahlNurDateien1;
        if (this.isAusgabeDateien()) {
            this.ausgabeVerzeichnisse = false;
        }
    }

    public void setAusgabeNurNamen(boolean ausgabeNurNamen1) {
        this.ausgabeNurNamen = ausgabeNurNamen1;
    }

    public void setAusgabeVerzeichnisRelativ(boolean ausgabeVerzeichnisRelativ1) {
        this.ausgabeVerzeichnisRelativ = ausgabeVerzeichnisRelativ1;
    }

    public void setAusgabeVerzeichnisse(boolean auswahlNurVerzeichnisse1) {
        this.ausgabeVerzeichnisse = auswahlNurVerzeichnisse1;
        if (this.isAusgabeVerzeichnisse()) {
            this.ausgabeDateien = false;
        }
    }

    public void setAuswahlAlles(boolean auswahlAlles) {
        if (auswahlAlles) {
            this.ausgabeVerzeichnisse = true;
            this.ausgabeDateien = true;
            this.auswahlNurBilder = false;
            this.auswahlNurVideos = false;
        } else {
            this.setAusgabeDateien(true);
        }
    }

    public void setAuswahlAnzahlDateien(int auswahlAnzahlDateien1) {
        this.auswahlAnzahlDateien = auswahlAnzahlDateien1;
    }

    public void setAuswahlAusgabeListe(String auswahlAusgabeListe1) {
        this.auswahlAusgabeListe = auswahlAusgabeListe1;
    }

    public void setAuswahlAusgabeNurInDatei(boolean auswahlAusgabeNurInDatei1) {
        this.auswahlAusgabeNurInDatei = auswahlAusgabeNurInDatei1;
        if (this.isAuswahlAusgabeNurInDatei() && (this.getAuswahlAusgabeListe() == null || this.getAuswahlAusgabeListe().length() == 0)) {
            this.auswahlAusgabeNurInDatei = false;
        }
    }

    public void setAuswahlDatei(String auswahlDatei1) {
        this.auswahlDatei = auswahlDatei1;
    }

    public void setAuswahlDateiExclude(boolean auswahlDateiExclude1) {
        this.auswahlDateiExclude = auswahlDateiExclude1;
    }

    public void setAuswahlDateiIgnoreCase(boolean auswahlDateiIgnoreCase1) {
        this.auswahlDateiIgnoreCase = auswahlDateiIgnoreCase1;
    }

    public void setAuswahlDatumZeitArt(char auswahlDatumZeitArt1) {
        this.auswahlDatumZeitArt = auswahlDatumZeitArt1;
    }

    public void setAuswahlGroesse(long auswahlGroesse1) {
        this.auswahlGroesse = auswahlGroesse1;
    }

    public void setAuswahlHardLinkCount(int auswahlHardLinkCount) {
        this.auswahlHardLinkCount = auswahlHardLinkCount;
    }

    public void setAuswahlNurBilder(boolean auswahlNurBilder1) {
        this.auswahlNurBilder = auswahlNurBilder1;
        if (this.isAuswahlNurBilder()) {
            this.ausgabeDateien = true;
        }
    }

    public void setAuswahlNurVideos(boolean auswahlNurVideos1) {
        this.auswahlNurVideos = auswahlNurVideos1;
        if (this.isAuswahlNurVideos()) {
            this.ausgabeDateien = true;
        }
    }

    public void setAuswahlStichtag(int AuswahlStichtag) {
        if (AuswahlStichtag != 0) {
            FGregorianCalendar Stichtag_Cal = new FGregorianCalendar();
            if (this.getAuswahlStichtag() > 0L) {
                Stichtag_Cal.setTimeInMillis(this.getAuswahlStichtag());
            }
            Stichtag_Cal.add(11, -AuswahlStichtag * 24);
            this.auswahlStichtag = Stichtag_Cal.getTimeInMillis();
        }
    }

    public void setAuswahlStichtag(String AuswahlStichtag) {
        if (AuswahlStichtag.length() >= 10) {
            FGregorianCalendar Stichtag_Cal = new FGregorianCalendar();
            if (this.getAuswahlStichtag() > 0L) {
                Stichtag_Cal.setTimeInMillis(this.getAuswahlStichtag());
            }
            Stichtag_Cal.set(1, Integer.parseInt(AuswahlStichtag.substring(6, 10)));
            Stichtag_Cal.set(2, Integer.parseInt(AuswahlStichtag.substring(3, 5)) - 1);
            Stichtag_Cal.set(5, Integer.parseInt(AuswahlStichtag.substring(0, 2)));
            this.auswahlStichtag = Stichtag_Cal.getTimeInMillis();
        }
    }

    public void setAuswahlStichtagUhrzeit(String auswahlUhrzeit) {
        if (auswahlUhrzeit.length() >= 8) {
            FGregorianCalendar Stichtag_Cal = new FGregorianCalendar();
            if (this.getAuswahlStichtag() > 0L) {
                Stichtag_Cal.setTimeInMillis(this.getAuswahlStichtag());
            }
            Stichtag_Cal.set(11, Integer.parseInt(auswahlUhrzeit.substring(0, 2)));
            try {
                Stichtag_Cal.set(12, Integer.parseInt(auswahlUhrzeit.substring(3, 5)));
                Stichtag_Cal.set(13, Integer.parseInt(auswahlUhrzeit.substring(6, 8)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.auswahlStichtag = Stichtag_Cal.getTimeInMillis();
        }
    }

    public void setAuswahlStichVergleichAelter(boolean auswahlStichVergleichAelter1) {
        FProt fProt = FProt.instance();
        this.auswahlStichVergleichAelter = auswahlStichVergleichAelter1;
        if (this.isAuswahlStichVergleichAelter()) {
            fProt.prot("Dateien (last modified) muessen aelter als Stichtag sein", 2);
        } else {
            fProt.prot("Dateien (last modified) muessen juenger als Stichtag sein", 2);
        }
    }

    public void setAuswahlTiefe(int auswahlTiefe1) {
        this.auswahlTiefe = auswahlTiefe1;
    }

    public void setAuswahlVerzeichnis(String auswahlVerzeichnis1) {
        this.auswahlVerzeichnis = auswahlVerzeichnis1;
    }

    public void setAuswahlVerzeichnisExclude(boolean auswahlVerzeichisExclude) {
        this.auswahlVerzeichnisExclude = auswahlVerzeichisExclude;
    }

    public void setAuswahlVerzeichnisIgnoreCase(boolean auswahlVerzeichnisIgnoreCase1) {
        this.auswahlVerzeichnisIgnoreCase = auswahlVerzeichnisIgnoreCase1;
    }

    public void setHidden() {
        this.setHidden(true);
    }

    public void setHidden(boolean hidden) {
        if (this.isHidden() != hidden) {
            if (Futi.isMac()) {
                FBefehl.aufrufBefehl("chflags", new String[]{hidden ? "hidden" : "nohidden", this.getAbsolutePath()});
            } else {
                FBefehl.aufrufBefehl("attrib", new String[]{String.valueOf(hidden ? "+" : "-") + "H", this.getAbsolutePath()});
            }
        }
    }

    public boolean setLastModified(int Jahr, int Monat, int Tag2, int Stunde, int Minute, int Sekunde) {
        GregorianCalendar ZeitCal = new GregorianCalendar();
        ZeitCal.clear();
        ZeitCal.set(Jahr, Monat - 1, Tag2, Stunde, Minute, Sekunde);
        Date ZeitDate = ZeitCal.getTime();
        return this.setLastModified(ZeitDate.getTime());
    }

    public void setListBasisPfad(String basisPfad) {
        this.listBasisPfad = basisPfad;
    }

    public void setPresortFiles(boolean presortFiles) {
        this.presortFiles = presortFiles;
    }

    public void setSortiereAufsteigend(boolean sortiereAufsteigend) {
        this.SortiereAufsteigend = sortiereAufsteigend;
    }

    public void setSortiereNachDatum(boolean sortiereNachDatum) {
        this.SortiereNachDatum = sortiereNachDatum;
        if (sortiereNachDatum) {
            this.SortiereNachGroesse = false;
            this.SortiereNachNamen = false;
        }
    }

    public void setSortiereNachGroesse(boolean sortiereNachGroesse) {
        this.SortiereNachGroesse = sortiereNachGroesse;
        if (sortiereNachGroesse) {
            this.SortiereNachDatum = false;
            this.SortiereNachNamen = false;
        }
    }

    public void setSortiereNachNamen(boolean sortiereNachNamen) {
        this.SortiereNachNamen = sortiereNachNamen;
        if (sortiereNachNamen) {
            this.SortiereNachDatum = false;
            this.SortiereNachGroesse = false;
        }
    }

    public String[] sortierenListe(String[] ausgabe) {
        int j;
        FString fString = FString.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        String[] Ausgabe = new String[ausgabe.length];
        String[][] tab = fString.convertStringArrayToTabelle(ausgabe, 5);
        int[] SpaltenLaenge = new int[4];
        int i = 0;
        while (i < tab.length) {
            j = 0;
            while (j < SpaltenLaenge.length) {
                SpaltenLaenge[j] = Math.max(SpaltenLaenge[j], tab[i][j].length());
                ++j;
            }
            ++i;
        }
        int max = SpaltenLaenge[0];
        j = 1;
        while (j < SpaltenLaenge.length) {
            max = Math.max(SpaltenLaenge[j], max);
            ++j;
        }
        ++max;
        String Filler = "";
        i = 0;
        while (i < max) {
            Filler = String.valueOf(Filler) + " ";
            ++i;
        }
        if (this.isSortiereNachNamen()) {
            i = 0;
            while (i < tab.length) {
                Ausgabe[i] = String.valueOf((String.valueOf(tab[i][3]) + Filler).substring(0, SpaltenLaenge[3] + 1)) + "\t" + (String.valueOf(tab[i][2]) + Filler).substring(0, SpaltenLaenge[2] + 1) + "\t" + (String.valueOf(tab[i][1]) + Filler).substring(0, SpaltenLaenge[1] + 1) + "\t" + (String.valueOf(tab[i][0]) + Filler).substring(0, SpaltenLaenge[0] + 1) + "\t" + tab[i][4];
                ++i;
            }
        }
        if (this.isSortiereNachDatum()) {
            i = 0;
            while (i < tab.length) {
                tab[i][0] = String.valueOf(tab[i][0].substring(6, 10)) + tab[i][0].substring(2, 6) + tab[i][0].substring(0, 2) + tab[i][0].substring(10);
                Ausgabe[i] = String.valueOf(tab[i][0]) + "\t" + (String.valueOf(tab[i][3]) + Filler).substring(0, SpaltenLaenge[3] + 1) + "\t" + (String.valueOf(tab[i][2]) + Filler).substring(0, SpaltenLaenge[2] + 1) + "\t" + (String.valueOf(tab[i][1]) + Filler).substring(0, SpaltenLaenge[1] + 1) + "\t" + tab[i][4];
                ++i;
            }
        }
        if (this.isSortiereNachGroesse()) {
            i = 0;
            while (i < tab.length) {
                j = (String.valueOf(Filler) + tab[i][1]).length();
                Ausgabe[i] = String.valueOf((String.valueOf(Filler) + tab[i][1]).substring(j - SpaltenLaenge[1])) + "\t" + (String.valueOf(tab[i][3]) + Filler).substring(0, SpaltenLaenge[3] + 1) + "\t" + (String.valueOf(tab[i][2]) + Filler).substring(0, SpaltenLaenge[2] + 1) + "\t" + (String.valueOf(tab[i][0]) + Filler).substring(0, SpaltenLaenge[0] + 1) + "\t" + tab[i][4];
                ++i;
            }
        }
        Ausgabe = fQuickSort.quickSort(Ausgabe, this.isSortiereAufsteigend(), this.isAuswahlDateiIgnoreCase());
        tab = fString.convertStringArrayToTabelle(Ausgabe, 5);
        if (this.isSortiereNachNamen()) {
            i = 0;
            while (i < tab.length) {
                Ausgabe[i] = String.valueOf(tab[i][3].trim()) + "\t" + tab[i][2].trim() + "\t" + tab[i][1].trim() + "\t" + tab[i][0].trim() + "\t" + tab[i][4];
                ++i;
            }
        }
        if (this.isSortiereNachDatum()) {
            i = 0;
            while (i < tab.length) {
                Ausgabe[i] = String.valueOf(tab[i][0].substring(8, 10)) + tab[i][0].substring(4, 8) + tab[i][0].substring(0, 4) + tab[i][0].substring(10) + "\t" + tab[i][3].trim() + "\t" + tab[i][2].trim() + "\t" + tab[i][1].trim() + "\t" + tab[i][4];
                ++i;
            }
        }
        if (this.isSortiereNachGroesse()) {
            i = 0;
            while (i < tab.length) {
                Ausgabe[i] = String.valueOf(tab[i][3].trim()) + "\t" + tab[i][0].trim() + "\t" + tab[i][2].trim() + "\t" + tab[i][1].trim() + "\t" + tab[i][4];
                ++i;
            }
        }
        return Ausgabe;
    }

    public String[] StringArrayListToInhalt(ArrayList<String> Zeile) {
        return this.StringArrayListToInhalt(Zeile, true, "", 0, false);
    }

    public String[] StringArrayListToInhalt(ArrayList<String> Zeile, boolean nichtSchreibenWennUnveraendert) {
        return this.StringArrayListToInhalt(Zeile, true, "", 0, nichtSchreibenWennUnveraendert);
    }

    public String[] StringArrayListToInhalt(ArrayList<String> ZeileIn, boolean NeueZeileSchreiben, String charset, int maxZeilen, boolean nichtSchreibenWennUnveraendert) {
        ArrayList<String> msg = new ArrayList<String>();
        boolean write = true;
        ArrayList<String> Zeile = new ArrayList();
        if (ZeileIn != null) {
            Zeile = ZeileIn;
        }
        if (nichtSchreibenWennUnveraendert) {
            if (!this.exists()) {
                msg.add("create   : " + this.getAbsolutePath() + " neu, noch nicht vorhanden");
            } else if (FString.compareArrayLists(Zeile, this.inhaltToStringArrayList(charset))) {
                msg.add("nowrite  : " + this.getAbsolutePath() + " nicht geschrieben, da unveraendert");
                write = false;
            } else {
                msg.add("overwrite: " + this.getAbsolutePath() + " zurueckgeschrieben, da veraendert");
            }
        }
        if (write) {
            try {
                if (FDatei.checkDatei(this.getCanonicalPath(), 'D', 'W', "Ausgabedatei").length() > 0) {
                    BufferedWriter SchreibenDatei = null;
                    SchreibenDatei = charset.length() > 1 && Charset.isSupported(charset) ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this), charset)) : new BufferedWriter(new FileWriter(this));
                    if (Zeile.size() == 0) {
                        SchreibenDatei.write("");
                    } else {
                        int i = 0;
                        while (i < Zeile.size() && (maxZeilen == 0 || maxZeilen > 0 && i < maxZeilen)) {
                            SchreibenDatei.write(Zeile.get(i));
                            if (NeueZeileSchreiben) {
                                SchreibenDatei.newLine();
                            }
                            ++i;
                        }
                    }
                    SchreibenDatei.close();
                }
            }
            catch (IOException e) {
                msg.add("writeError: " + e.getMessage());
            }
        }
        return FString.arrayListToStringArray(msg);
    }

    public String[] StringArrayListToInhalt(ArrayList<String> Zeile, String charset) {
        return this.StringArrayListToInhalt(Zeile, true, charset, 0, false);
    }

    public String[] StringArrayListToInhalt(ArrayList<String> Zeile, String charset, boolean nichtSchreibenWennUnveraendert) {
        return this.StringArrayListToInhalt(Zeile, true, charset, 0, nichtSchreibenWennUnveraendert);
    }

    public String[] StringArrayToInhalt(String[] Zeile) {
        return this.StringArrayToInhalt(Zeile, true, "", 0, false);
    }

    public String[] StringArrayToInhalt(String[] Zeile, boolean NeueZeileSchreiben) {
        return this.StringArrayToInhalt(Zeile, NeueZeileSchreiben, "", 0, false);
    }

    public String[] StringArrayToInhalt(String[] Zeile, boolean NeueZeileSchreiben, String charset) {
        return this.StringArrayToInhalt(Zeile, NeueZeileSchreiben, charset, 0, false);
    }

    public String[] StringArrayToInhalt(String[] ZeileIn, boolean NeueZeileSchreiben, String charset, int maxZeilen, boolean nichtSchreibenWennUnveraendert) {
        boolean write = true;
        ArrayList<String> error = new ArrayList<String>();
        String[] Zeile = new String[]{};
        if (ZeileIn != null) {
            Zeile = ZeileIn;
        }
        if (nichtSchreibenWennUnveraendert && this.exists() && FString.compareArrays(Zeile, this.inhaltToStringArray(charset), false)) {
            write = false;
        }
        if (write) {
            try {
                if (FDatei.checkDatei(this.getCanonicalPath(), 'D', 'W', "Ausgabedatei").length() > 0) {
                    BufferedWriter SchreibenDatei = null;
                    SchreibenDatei = charset.length() > 1 && Charset.isSupported(charset) ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this), charset)) : new BufferedWriter(new FileWriter(this));
                    if (Zeile.length == 0) {
                        SchreibenDatei.write("");
                    } else {
                        int i = 0;
                        while (i < Zeile.length && (maxZeilen == 0 || maxZeilen > 0 && i < maxZeilen)) {
                            SchreibenDatei.write(Zeile[i]);
                            if (NeueZeileSchreiben) {
                                SchreibenDatei.newLine();
                            }
                            ++i;
                        }
                    }
                    SchreibenDatei.close();
                }
            }
            catch (IOException e) {
                error.add(e.getMessage());
            }
        }
        return FString.arrayListToStringArray(error);
    }

    public String[] StringArrayToInhalt(String[] Zeile, String charset) {
        return this.StringArrayToInhalt(Zeile, true, charset, 0, false);
    }

    public String[] StringArrayToInhalt(String[] Zeile, String charset, boolean nichtSchreibenWennUnveraendert) {
        return this.StringArrayToInhalt(Zeile, true, charset, 0, nichtSchreibenWennUnveraendert);
    }

    public String[] StringArrayToInhalt(String[] Zeile, String charset, int maxZeilen) {
        return this.StringArrayToInhalt(Zeile, true, charset, maxZeilen, false);
    }

    public String[] StringToInhalt(String Zeile) {
        return this.StringArrayToInhalt(new String[]{Zeile}, true);
    }

    public String[] StringToInhaltAppendText(String Zeile) {
        return this.StringToInhaltAppendText(Zeile, false);
    }

    public String[] StringToInhaltAppendText(String Zeile, boolean appendNurNeues) {
        ArrayList<String> inhalt = this.inhaltToStringArrayList();
        if (appendNurNeues) {
            if (FString.findFirstString(inhalt, Zeile) < 0) {
                inhalt.add(Zeile);
            }
        } else {
            inhalt.add(Zeile);
        }
        return this.StringArrayListToInhalt(inhalt);
    }

    public void writeInDatei(String zeile) {
        if (this.Liste != null) {
            try {
                this.Liste.write(zeile);
                this.Liste.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeInDateiClose() {
        if (this.Liste != null) {
            try {
                this.Liste.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.Liste = null;
        }
    }

    public void writeInDateiInit() {
        if (this.getAuswahlAusgabeListe().length() > 0) {
            try {
                this.Liste = new BufferedWriter(new FileWriter(this.getAuswahlAusgabeListe()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String zeigeAusgabeTypen() {
        String Zeile = "";
        Zeile = String.valueOf(Zeile) + (this.isAusgabeDateien() ? "Nur Dateien;" : "");
        Zeile = String.valueOf(Zeile) + (this.isAusgabeVerzeichnisse() ? "Nur Verz.;" : "");
        Zeile = Zeile.length() == 0 ? "keine" : Zeile.substring(0, Zeile.length() - 1);
        return Zeile;
    }

    public String zeigeAuswahlDateien() {
        String Zeile = "";
        if (this.getAuswahlDatei().length() > 0) {
            Zeile = String.valueOf(Zeile) + (this.isAuswahlDateiExclude() ? "(not)" : "") + this.getAuswahlDatei() + ";";
        }
        Zeile = String.valueOf(Zeile) + (this.isAuswahlDateiIgnoreCase() ? "IgnoreCase;" : "");
        if (this.getAuswahlStichtag() != 0L) {
            Zeile = String.valueOf(Zeile) + (this.isAuswahlStichVergleichAelter() ? "aelter " : "juenger ") + new FGregorianCalendar(this.getAuswahlStichtag()).toGermanFormat() + ";";
        }
        if (this.getAuswahlGroesse() != 0L) {
            Zeile = String.valueOf(Zeile) + (this.getAuswahlGroesse() > 0L ? "groesser " + this.getAuswahlGroesse() : "kleiner " + -this.getAuswahlGroesse()) + ";";
        }
        Zeile = String.valueOf(Zeile) + (this.isAuswahlNurBilder() ? "Nur BildBewegen;" : "");
        Zeile = Zeile.length() == 0 ? "alle" : Zeile.substring(0, Zeile.length() - 1);
        return Zeile;
    }

    public String zeigeAuswahlVerzeichnisse() {
        String Zeile = "";
        if (this.getAuswahlVerzeichnis().length() > 0) {
            Zeile = String.valueOf(Zeile) + (this.isAuswahlVerzeichnisExclude() ? "(not)" : "") + this.getAuswahlVerzeichnis() + ";";
        }
        Zeile = String.valueOf(Zeile) + (this.isAuswahlVerzeichnisIgnoreCase() ? "IgnoreCase;" : "");
        Zeile = String.valueOf(Zeile) + "Tiefe der Rekurs.:" + (this.getAuswahlTiefe() >= 0 ? String.valueOf(this.getAuswahlTiefe()) : "unbegrenzt") + ";";
        if (this.getAuswahlAnzahlDateien() != 0L) {
            Zeile = String.valueOf(Zeile) + "Anzahl Dat. in Verz." + (this.getAuswahlAnzahlDateien() > 0L ? " groesser " + this.getAuswahlAnzahlDateien() : " kleiner " + -this.getAuswahlAnzahlDateien()) + ";";
        }
        Zeile = Zeile.length() == 0 ? "alle" : Zeile.substring(0, Zeile.length() - 1);
        return Zeile;
    }
}

