/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FBild {
    private static FBild instance;

    public static BufferedImage aendernFarbe(BufferedImage imageEin, String farbraum) {
        BufferedImage imageAus = imageEin;
        if (imageEin != null) {
            ColorSpace colorSpace = null;
            if (farbraum != null) {
                if (farbraum.compareToIgnoreCase("sRGB") == 0) {
                    colorSpace = ColorSpace.getInstance(1000);
                } else if (farbraum.compareToIgnoreCase("linear-RGB") == 0) {
                    colorSpace = ColorSpace.getInstance(1004);
                } else if (farbraum.compareToIgnoreCase("grau") == 0) {
                    colorSpace = ColorSpace.getInstance(1003);
                } else if (farbraum.compareToIgnoreCase("PYCC") == 0) {
                    colorSpace = ColorSpace.getInstance(1002);
                } else if (farbraum.compareToIgnoreCase("CIEXYZ") == 0) {
                    colorSpace = ColorSpace.getInstance(1001);
                }
            }
            if (colorSpace != null) {
                imageAus = new BufferedImage(imageEin.getWidth(), imageEin.getHeight(), imageEin.getType());
                Graphics2D g2d = imageAus.createGraphics();
                g2d.drawImage(imageEin, new ColorConvertOp(colorSpace, null), 0, 0);
                g2d.dispose();
            }
        }
        return imageAus;
    }

    public static BufferedImage ausgrauen(BufferedImage imageEin) {
        return FBild.aendernFarbe(imageEin, "grau");
    }

    public static BufferedImage drehen3D(BufferedImage image, int drehenX, int drehenY) {
        FMath.instance();
        BufferedImage imageAus = null;
        imageAus = drehenX == 0 && drehenY == 0 ? image : FBild.setzenGroesse(image, (int)Math.round(FMath.checkRange(Math.cos(Math.toRadians(drehenY)), 0.0, 1.0) * (double)image.getWidth(null)), (int)Math.round(FMath.checkRange(Math.cos(Math.toRadians(drehenX)), 0.0, 1.0) * (double)image.getHeight(null)), true, -1, null);
        return imageAus;
    }

    public static BufferedImage drehen90Grad(BufferedImage imageEin) {
        return FBild.drehen90Grad(imageEin, true);
    }

    public static BufferedImage drehen90Grad(BufferedImage imageEin, boolean imUhrzeigersinn) {
        BufferedImage imageAus = imageEin;
        if (imageEin != null) {
            imageAus = new BufferedImage(imageEin.getHeight(), imageEin.getWidth(), imageEin.getType());
            Graphics2D g2d = imageAus.createGraphics();
            AffineTransform xform = new AffineTransform();
            xform.rotate(Math.toRadians(imUhrzeigersinn ? 90 : -90), 0.0, 0.0);
            g2d.transform(xform);
            g2d.drawImage((Image)imageEin, imUhrzeigersinn ? 0 : -imageEin.getWidth(), imUhrzeigersinn ? -imageEin.getHeight() : 0, null);
            g2d.dispose();
        }
        return imageAus;
    }

    public static BufferedImage getBufferedImage(String imageName) {
        FProt fProt = FProt.instance();
        BufferedImage bufferedImage = null;
        Image image = new ImageIcon(imageName).getImage();
        if (image.getWidth(null) == -1) {
            fProt.prot("Datei >" + imageName + "< ist kein Image");
        } else {
            bufferedImage = FBild.image2BufferedImage(image);
        }
        return bufferedImage;
    }

    public static int getDrehwinkel(int winkelOrg, int winkelZiel) {
        return FBild.getDrehwinkel(winkelOrg, winkelZiel, false, false);
    }

    public static int getDrehwinkel(int winkelOrg, int winkelZiel, boolean drehenGesetzt, boolean drehenImUZS) {
        int w1 = winkelZiel - winkelOrg;
        int w2 = w1 > 0 ? w1 - 360 : 360 + w1;
        int wAus = 0;
        wAus = !drehenGesetzt ? (Math.abs(w1) <= Math.abs(w2) ? w1 : w2) : (drehenImUZS ? (w1 >= 0 ? w1 : w2) : (w1 < 0 ? w1 : w2));
        return wAus;
    }

    public static int[] getGroesse(String BildEin) {
        int[] Masse = new int[2];
        try {
            Image inImage = new ImageIcon(BildEin).getImage();
            Masse[0] = inImage.getWidth(null);
            Masse[1] = inImage.getHeight(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Masse;
    }

    public static Rectangle getSurroundingRectangle(int breite, int hoehe, AffineTransform xForm) {
        AffineTransformOp op = new AffineTransformOp(xForm, 2);
        Point[] moved = new Point[4];
        moved[0] = new Point();
        moved[0].setLocation(op.getPoint2D(new Point(0, 0), moved[0]));
        moved[1] = new Point();
        moved[1].setLocation(op.getPoint2D(new Point(0 + breite, 0), null));
        moved[2] = new Point();
        moved[2].setLocation(op.getPoint2D(new Point(0, hoehe), null));
        moved[3] = new Point();
        moved[3].setLocation(op.getPoint2D(new Point(breite, hoehe), null));
        int minX = 10000;
        int minY = 10000;
        int maxX = -10000;
        int maxY = -10000;
        Point[] pointArray = moved;
        int n = moved.length;
        int n2 = 0;
        while (n2 < n) {
            Point element = pointArray[n2];
            minX = Math.min(minX, element.x);
            minY = Math.min(minY, element.y);
            maxX = Math.max(maxX, element.x);
            maxY = Math.max(maxY, element.y);
            ++n2;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle getSurroundingRectangle(int breite, int hoehe, int winkel, int drehPunktX, int drehPunktY) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(winkel), drehPunktX, drehPunktY);
        return FBild.getSurroundingRectangle(breite, hoehe, affineTransform);
    }

    public static BufferedImage image2BufferedImage(Image imageEin) {
        FProt fProt = FProt.instance();
        BufferedImage imageAus = new BufferedImage(Math.min(imageEin.getWidth(null), 1500), Math.min(imageEin.getHeight(null), 1500), 1);
        Graphics2D g2d = imageAus.createGraphics();
        g2d.drawImage(imageEin, 0, 0, null);
        g2d.dispose();
        if (imageAus.getWidth() != imageEin.getWidth(null) || imageAus.getHeight() != imageEin.getHeight(null)) {
            fProt.prot("Bildanzeige verkleinert, da nicht gen\u00fcgend Speicher. " + imageEin.toString());
        }
        return imageAus;
    }

    public static synchronized FBild instance() {
        if (instance == null) {
            instance = new FBild();
        }
        return instance;
    }

    public static int normiereWinkel180(int w) {
        int e = w;
        if (w <= -180 || w > 180) {
            int r = w % 360;
            e = r <= -180 ? 360 + r : (r > 180 ? r - 360 : r);
        }
        return e;
    }

    public static int normiereWinkel90plus(int w) {
        int e = w;
        if ((w < 0 || w > 90) && (e = Math.abs(FBild.normiereWinkel180(w))) > 90) {
            e = 180 - e;
        }
        return e;
    }

    public static boolean schreibenBufferedImage2File(BufferedImage image, String fileName, String fileTyp) {
        boolean ok = false;
        if (FString.findFirstString(ImageIO.getWriterFileSuffixes(), fileTyp, true) < 0) {
            System.err.println("ImageIO.write(image, " + fileTyp + "): Bildtyp:" + fileTyp + " nicht unterstuetzt");
        } else if (FDatei.checkDatei(String.valueOf(fileName) + System.getProperty("file.separator") + fileTyp, 'D', 'W', "Ausgabedatei fuer Bild", true).length() > 0) {
            try {
                ImageIO.write((RenderedImage)image, fileTyp, new File(String.valueOf(fileName) + "." + fileTyp));
                ok = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }

    public static boolean schreibenComponent2File(JComponent component, String fileName, String fileTyp, int breite, int hoehe) {
        boolean ok = false;
        if (FString.findFirstString(ImageIO.getWriterFileSuffixes(), fileTyp, true) < 0) {
            System.err.println("ImageIO.write(image, " + fileTyp + "): Bildtyp:" + fileTyp + " nicht unterstuetzt");
        } else if (FDatei.checkDatei(String.valueOf(fileName) + System.getProperty("file.separator") + fileTyp, 'D', 'W', "Ausgabedatei fuer Bild", true).length() > 0) {
            Rectangle rectangle = null;
            if (component == null) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle = new Rectangle(0, 0, screenSize.width, screenSize.height);
            } else {
                rectangle = new Rectangle(component.getLocationOnScreen().x, component.getLocationOnScreen().y, breite == 0 ? component.getWidth() : breite, hoehe == 0 ? component.getHeight() : hoehe);
                component.grabFocus();
            }
            try {
                Robot robot = new Robot();
                ImageIO.write((RenderedImage)robot.createScreenCapture(rectangle), fileTyp, new File(String.valueOf(fileName) + "." + fileTyp));
                ok = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }

    public static boolean schreibenImage2File(Image image, String fileName, String fileTyp) {
        boolean ok = false;
        if (FString.findFirstString(ImageIO.getWriterFileSuffixes(), fileTyp, true) < 0) {
            System.err.println("ImageIO.write(image, " + fileTyp + "): Bildtyp:" + fileTyp + " nicht unterstuetzt");
        } else if (FDatei.checkDatei(String.valueOf(fileName) + System.getProperty("file.separator") + fileTyp, 'D', 'W', "Ausgabedatei fuer Bild", true).length() > 0) {
            try {
                ImageIO.write((RenderedImage)FBild.image2BufferedImage(image), fileTyp, new File(String.valueOf(fileName) + "." + fileTyp));
                ok = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }

    public static BufferedImage setzenGroesse(BufferedImage imageEin, float faktor) {
        return FBild.setzenGroesse(imageEin, Math.round((float)imageEin.getWidth() * faktor), Math.round((float)imageEin.getHeight() * faktor), false, -1, null);
    }

    public static BufferedImage setzenGroesse(BufferedImage imageEin, int input_maxBreite, int input_maxHoehe) {
        return FBild.setzenGroesse(imageEin, input_maxBreite, input_maxHoehe, false, -1, null);
    }

    public static BufferedImage setzenGroesse(BufferedImage imageEin, int input_maxBreite, int input_maxHoehe, boolean verzerren) {
        return FBild.setzenGroesse(imageEin, input_maxBreite, input_maxHoehe, verzerren, -1, null);
    }

    public static BufferedImage setzenGroesse(BufferedImage imageEin, int input_maxBreite, int input_maxHoehe, boolean verzerren, int input_minProzentRahmen, Color gewuenschteFarbe) {
        return FBild.setzenGroesse(imageEin, input_maxBreite, input_maxHoehe, verzerren, input_minProzentRahmen, gewuenschteFarbe, false);
    }

    public static BufferedImage setzenGroesse(BufferedImage imageEin, int input_maxBreite, int input_maxHoehe, boolean verzerren, int input_minProzentRahmen, Color gewuenschteFarbe, boolean nurVerkleinern) {
        FMath.instance();
        BufferedImage imageAus = imageEin;
        if (imageEin != null) {
            boolean mitRahmen = input_minProzentRahmen >= 0;
            int maxBreite = FMath.checkRange(input_maxBreite, 8, 10000);
            int maxHoehe = FMath.checkRange(input_maxHoehe, 8, 10000);
            double skalierungsFaktorBreite = (double)maxBreite / (double)imageEin.getWidth(null);
            double skalierungsFaktorHoehe = (double)maxHoehe / (double)imageEin.getHeight(null);
            double skalierungsFaktor = Math.min(skalierungsFaktorBreite, skalierungsFaktorHoehe);
            int rahmenBreite = maxBreite;
            int rahmenHoehe = maxHoehe;
            int minProzentRahmen = FMath.checkRange(input_minProzentRahmen, 0, 50);
            double faktorBasis = (double)minProzentRahmen / 100.0;
            if (mitRahmen) {
                skalierungsFaktor *= 1.0 - faktorBasis;
                skalierungsFaktorBreite *= 1.0 - faktorBasis;
                skalierungsFaktorHoehe *= 1.0 - faktorBasis;
            }
            skalierungsFaktor = FMath.checkRange(skalierungsFaktor, 0.0, nurVerkleinern ? 1.0 : 10.0);
            if (!verzerren) {
                skalierungsFaktorBreite = skalierungsFaktor;
                skalierungsFaktorHoehe = skalierungsFaktor;
            }
            int bildBreite = (int)(skalierungsFaktorBreite * (double)imageEin.getWidth(null));
            int bildHoehe = (int)(skalierungsFaktorHoehe * (double)imageEin.getHeight(null));
            Color farbe = gewuenschteFarbe != null ? gewuenschteFarbe : Color.gray;
            double faktorBreite = 1.0;
            double faktorHoehe = 1.0;
            if (mitRahmen) {
                faktorBreite = (double)rahmenBreite / (double)bildBreite;
                faktorHoehe = (double)rahmenHoehe / (double)bildHoehe;
            } else {
                rahmenBreite = bildBreite;
                rahmenHoehe = bildHoehe;
            }
            try {
                BufferedImage outImage = new BufferedImage(rahmenBreite, rahmenHoehe, 1);
                AffineTransform transform = new AffineTransform();
                transform.scale(skalierungsFaktorBreite, skalierungsFaktorHoehe);
                transform.translate((faktorBreite - 1.0) / 2.0 / skalierungsFaktorBreite * (double)bildBreite, (faktorHoehe - 1.0) / 2.0 / skalierungsFaktorHoehe * (double)bildHoehe);
                Graphics2D g2d = outImage.createGraphics();
                if (mitRahmen) {
                    g2d.setColor(farbe);
                    g2d.fill3DRect(0, 0, rahmenBreite, rahmenHoehe, true);
                }
                g2d.drawImage(imageEin, transform, null);
                imageAus = outImage;
                g2d.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imageAus;
    }

    public static void setzenGroesse(String BildEin, String BildAus, int input_maxBreite, int input_maxHoehe, int input_minProzentRahmen, Color gewuenschteFarbe, boolean erstellenBackup) {
        FMath.instance();
        boolean mitRahmen = true;
        boolean erzeugenBild = false;
        double faktorBasis = 0.0;
        int maxBreite = input_maxBreite;
        int maxHoehe = input_maxHoehe;
        int rahmenBreite = maxBreite;
        int rahmenHoehe = maxHoehe;
        int minProzentRahmen = input_minProzentRahmen;
        maxBreite = FMath.checkRange(maxBreite, 8, 10000);
        maxHoehe = FMath.checkRange(maxHoehe, 8, 10000);
        if (minProzentRahmen < 0) {
            mitRahmen = false;
        }
        minProzentRahmen = FMath.checkRange(minProzentRahmen, 0, 50);
        try {
            Image imageEin = new ImageIcon(BildEin).getImage();
            double skalierungsFaktor = Math.min((double)maxBreite / (double)imageEin.getWidth(null), (double)maxHoehe / (double)imageEin.getHeight(null));
            if (!mitRahmen) {
                rahmenBreite = (int)(skalierungsFaktor * (double)imageEin.getWidth(null));
                rahmenHoehe = (int)(skalierungsFaktor * (double)imageEin.getHeight(null));
            } else {
                faktorBasis = (double)minProzentRahmen / 100.0;
                skalierungsFaktor *= 1.0 - faktorBasis;
            }
            if (skalierungsFaktor < 1.0) {
                erzeugenBild = true;
            } else if (mitRahmen) {
                erzeugenBild = true;
                skalierungsFaktor = 1.0;
            }
            if (erzeugenBild) {
                int bildBreite = (int)(skalierungsFaktor * (double)imageEin.getWidth(null));
                int bildHoehe = (int)(skalierungsFaktor * (double)imageEin.getHeight(null));
                Color farbe = Color.gray;
                if (gewuenschteFarbe != null) {
                    farbe = gewuenschteFarbe;
                }
                double faktorBreite = 1.0;
                double faktorHoehe = 1.0;
                if (mitRahmen) {
                    faktorBreite = (double)rahmenBreite / (double)bildBreite;
                    faktorHoehe = (double)rahmenHoehe / (double)bildHoehe;
                }
                BufferedImage outImage = new BufferedImage(rahmenBreite, rahmenHoehe, 1);
                AffineTransform tx = new AffineTransform();
                tx.scale(skalierungsFaktor, skalierungsFaktor);
                tx.translate((faktorBreite - 1.0) / 2.0 / skalierungsFaktor * (double)bildBreite, (faktorHoehe - 1.0) / 2.0 / skalierungsFaktor * (double)bildHoehe);
                Graphics2D g2d = outImage.createGraphics();
                g2d.setColor(farbe);
                g2d.fill3DRect(0, 0, rahmenBreite, rahmenHoehe, true);
                g2d.drawImage(imageEin, tx, null);
                g2d.dispose();
                if (BildEin.compareToIgnoreCase(BildAus) == 0 && erstellenBackup) {
                    FFile Kopie = new FFile(BildEin);
                    Kopie.copyFile(String.valueOf(BildAus) + ".jpg");
                }
                File outputfile = new File(BildAus);
                ImageIO.write((RenderedImage)outImage, "jpeg", outputfile);
            } else if (BildEin.compareToIgnoreCase(BildAus) != 0) {
                FFile Kopie = new FFile(BildEin);
                Kopie.copyFile(BildAus);
            }
            imageEin.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage spiegeln(BufferedImage imageEin) {
        return FBild.spiegeln(imageEin, true);
    }

    public static BufferedImage spiegeln(BufferedImage imageEin, boolean spiegelnAnDerYAchse) {
        BufferedImage imageAus;
        block6: {
            imageAus = imageEin;
            if (imageEin == null) break block6;
            imageAus = new BufferedImage(imageEin.getWidth(), imageEin.getHeight(), imageEin.getType());
            if (spiegelnAnDerYAchse) {
                int i = 0;
                while (i < imageEin.getWidth()) {
                    int j = 0;
                    while (j < imageEin.getHeight()) {
                        imageAus.setRGB(imageEin.getWidth() - (i + 1), j, imageEin.getRGB(i, j));
                        ++j;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < imageEin.getWidth()) {
                    int j = 0;
                    while (j < imageEin.getHeight()) {
                        imageAus.setRGB(i, imageEin.getHeight() - (j + 1), imageEin.getRGB(i, j));
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return imageAus;
    }

    public static BufferedImage transparent(BufferedImage imageEin, float transperancy) {
        FMath.instance();
        BufferedImage imageAus = imageEin;
        if (imageEin != null) {
            imageAus = new BufferedImage(imageEin.getWidth(), imageEin.getHeight(), imageEin.getType());
            Graphics2D g2d = imageAus.createGraphics();
            g2d.setComposite(AlphaComposite.getInstance(3, FMath.checkRange(transperancy, 0.0f, 1.0f)));
            g2d.drawImage((Image)imageEin, 0, 0, null);
            g2d.dispose();
        }
        return imageAus;
    }

    public static boolean vergleicheImages(String fotoA, String fotoB) {
        boolean identisch = false;
        try {
            BufferedImage biA = ImageIO.read(new File(fotoA));
            DataBuffer dbA = biA.getData().getDataBuffer();
            int sizeA = dbA.getSize();
            BufferedImage biB = ImageIO.read(new File(fotoB));
            DataBuffer dbB = biB.getData().getDataBuffer();
            int sizeB = dbB.getSize();
            if (sizeA == sizeB) {
                int i = 0;
                while (i < sizeA) {
                    if (dbA.getElem(i) != dbB.getElem(i)) break;
                    ++i;
                }
                identisch = i == sizeA;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to compare image files ...");
        }
        return identisch;
    }

    public static BufferedImage verwischen(BufferedImage imageEin, float faktor) {
        FMath.instance();
        BufferedImage imageAus = imageEin;
        if (imageEin != null && faktor >= 0.11f) {
            imageAus = new BufferedImage(imageEin.getWidth(), imageEin.getHeight(), imageEin.getType());
            Graphics2D g2d = imageAus.createGraphics();
            float f = FMath.checkRange(faktor, 0.11f, 0.9f);
            g2d.drawImage(imageEin, new ConvolveOp(new Kernel(3, 3, new float[]{f, f, f, f, f, f, f, f, f})), 0, 0);
            int j = 0;
            while (j < imageEin.getHeight()) {
                imageAus.setRGB(0, j, imageEin.getRGB(0, j));
                imageAus.setRGB(imageEin.getWidth() - 1, j, imageEin.getRGB(imageEin.getWidth() - 1, j));
                ++j;
            }
            int i = 0;
            while (i < imageEin.getWidth()) {
                imageAus.setRGB(i, 0, imageEin.getRGB(i, 0));
                imageAus.setRGB(i, imageEin.getHeight() - 1, imageEin.getRGB(i, imageEin.getHeight() - 1));
                ++i;
            }
            g2d.dispose();
        }
        return imageAus;
    }
}

