/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class Tabelle2Datei {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Ausgabedatei;
    private String Charset;
    private boolean DateiAppend;
    private String DBName;
    private int AnzahlZeilen;
    private String Where;
    private String Tabelle;
    private final boolean SetzenWerteInGUInachRun = false;
    private String Felder;
    private String Trennzeichen;
    private boolean TrimFeldinhalte;
    private boolean MitHeader;
    private String[][] ExterneListe;
    private boolean OhneFeldtypen;
    private String Befehle;
    private final String Stand = "25.6.12";

    public static void main(String[] args) {
        Tabelle2Datei tabelle2Datei = new Tabelle2Datei(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(tabelle2Datei.ArgTab, tabelle2Datei.ArgTabDefault, tabelle2Datei.getHilfeText())) {
            try {
                tabelle2Datei.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + tabelle2Datei.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                tabelle2Datei.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + tabelle2Datei.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + tabelle2Datei.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Tabelle2Datei() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Tabelle2Datei(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String createColumn(String ColumnName, int ColumnType) {
        String Column = "";
        if (!this.isOhneFeldtypen()) {
            if (ColumnType == 91 || ColumnType == 92 || ColumnType == 93) {
                Column = String.valueOf(Column) + "$";
            }
            if (ColumnType == 3 || ColumnType == 7 || ColumnType == 2 || ColumnType == 8) {
                Column = String.valueOf(Column) + ".";
            }
            if (ColumnType == 4 || ColumnType == 5 || ColumnType == -6) {
                Column = String.valueOf(Column) + "#";
            }
        }
        Column = String.valueOf(Column) + ColumnName;
        return Column;
    }

    public void extrahiereTabelle(String dBName, String tabelleIn, String felder, String befehle) throws Exception {
        block20: {
            Statement DBStatement;
            block21: {
                String Zeile;
                FProt fProt = FProt.instance();
                FString fString = FString.instance();
                FDB fDB = FDB.instance();
                String[] Befehl = befehle.split(";");
                String tabelle = tabelleIn;
                String[] Feld = felder.split(";");
                ArrayList<String> Ausgabe = new ArrayList<String>();
                ResultSet rs = null;
                int numberOfColumns = 0;
                DBStatement = FDB.createDBStatement(dBName);
                if (DBStatement == null) break block20;
                int i = 0;
                while (i < Befehl.length) {
                    if (Befehl[i].length() > 0) {
                        FDB.executeUpdate(DBStatement, Befehl[i]);
                    }
                    ++i;
                }
                rs = FDB.executeQuery(DBStatement, "SELECT " + felder + " FROM " + fDB.getName4Query(tabelle) + " " + this.getWhere());
                if (rs == null) break block21;
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    numberOfColumns = rsmd.getColumnCount();
                    Feld = new String[numberOfColumns];
                    Zeile = "";
                    i = 1;
                    while (i <= numberOfColumns) {
                        Feld[i - 1] = rsmd.getColumnName(i);
                        fProt.prot("Feld [" + i + "]: " + rsmd.getColumnName(i) + ", " + rsmd.getColumnTypeName(i), 2);
                        if (this.isMitHeader()) {
                            if (i > 1) {
                                Zeile = String.valueOf(Zeile) + this.getTrennzeichen();
                            }
                            Zeile = String.valueOf(Zeile) + this.createColumn(rsmd.getColumnName(i), rsmd.getColumnType(i));
                        }
                        ++i;
                    }
                    if (Zeile.length() > 0 && (this.getAnzahlZeilen() < 1 || Ausgabe.size() < this.getAnzahlZeilen())) {
                        Ausgabe.add(Zeile);
                    }
                }
                catch (SQLException e) {
                    FDB.handleException(e);
                }
                try {
                    while (rs.next()) {
                        Zeile = "";
                        i = 1;
                        while (i <= numberOfColumns) {
                            String zelle = rs.getString(i);
                            if (zelle != null) {
                                Zeile = String.valueOf(Zeile) + (this.isTrimFeldinhalte() ? zelle.trim() : zelle);
                            }
                            Zeile = String.valueOf(Zeile) + (i < numberOfColumns ? this.getTrennzeichen() : "");
                            ++i;
                        }
                        if (this.getAnzahlZeilen() >= 1 && Ausgabe.size() >= this.getAnzahlZeilen()) continue;
                        Ausgabe.add(Zeile);
                    }
                }
                catch (SQLException e) {
                    FDB.handleException(e);
                }
                String[] Zeilen = FString.arrayListToStringArray(Ausgabe);
                if (this.getAusgabedatei().length() > 0) {
                    FFile File2 = new FFile(this.getAusgabedatei());
                    if (File2.isDirectory()) {
                        File2 = new FFile(String.valueOf(FDatei.checkFileSeperator(this.getAusgabedatei(), true)) + FDatei.instance().zerlegeDateiname(dBName).getName());
                        if (!File2.exists()) {
                            File2.mkdirs();
                        }
                        File2 = new FFile(String.valueOf(FDatei.checkFileSeperator(this.getAusgabedatei(), true)) + FDatei.instance().zerlegeDateiname(dBName).getName() + System.getProperty("file.separator") + tabelleIn + ".txt");
                    }
                    if (this.isDateiAppend()) {
                        Zeilen = FString.verbindenStringArray(File2.inhaltToStringArray(this.getCharset()), Zeilen);
                    }
                    File2.StringArrayToInhalt(Zeilen, this.getCharset());
                } else if (this.getExterneListe() != null) {
                    this.setExterneListe(fString.convertStringArrayToTabelle(Zeilen, numberOfColumns));
                } else {
                    fProt.prot(FString.arrayListToStringArray(Ausgabe));
                }
                fProt.prot(String.valueOf(Ausgabe.size()) + " Zeilen aus " + fDB.getName4Query(tabelle) + " extrahiert" + (Ausgabe.size() == 0 ? (this.isDateiAppend() ? ", nichts hinzugefuegt" : ", Ausgabe geloescht") : ""));
            }
            FDB.closeDBStatement(DBStatement);
        }
    }

    public int getAnzahlZeilen() {
        return this.AnzahlZeilen;
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getBefehle() {
        return this.Befehle;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[][] getExterneListe() {
        return this.ExterneListe;
    }

    public String getFelder() {
        return this.Felder;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public final String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "25.6.12";
    }

    public String getTabelle() {
        return this.Tabelle;
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public String getWhere() {
        return this.Where;
    }

    public boolean isDateiAppend() {
        return this.DateiAppend;
    }

    public boolean isMitHeader() {
        return this.MitHeader;
    }

    public boolean isOhneFeldtypen() {
        return this.OhneFeldtypen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTrimFeldinhalte() {
        return this.TrimFeldinhalte;
    }

    public void run() {
        FDB.instance();
        Futi.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()));
        String[] Tabellen = new String[]{this.getTabelle()};
        if (this.getTabelle().startsWith("*")) {
            Tabellen = this.getTabelle().split(",").length > 1 ? FDB.getTables(this.getDBName(), this.getTabelle().split(",")[1]) : FDB.getTables(this.getDBName());
        }
        String[] stringArray = Tabellen;
        int n = Tabellen.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                this.extrahiereTabelle(this.getDBName(), element, this.getFelder(), this.getBefehle());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void setAnzahlZeilen() {
        this.AnzahlZeilen = FParam.getIntParameter("AnzahlZeilen", this.ArgTab);
    }

    public void setAnzahlZeilen(int anzahlZeilen) {
        this.AnzahlZeilen = FParam.checkIntParameter("AnzahlZeilen", anzahlZeilen, this.ArgTab);
    }

    public void setAnzahlZeilen(String anzahlZeilen) {
        this.AnzahlZeilen = FParam.checkIntParameter("AnzahlZeilen", anzahlZeilen, this.ArgTab);
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setBefehle() {
        this.Befehle = FParam.getStringParameter("Befehle", this.ArgTab);
    }

    public void setBefehle(String befehle) {
        FParam.instance();
        this.Befehle = FParam.checkStringParameter("Befehle", befehle, this.ArgTab);
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setDateiAppend() {
        this.DateiAppend = FParam.getBooleanParameter("DateiAppend", this.ArgTab);
    }

    public void setDateiAppend(boolean ausgabedateiAppend) {
        this.DateiAppend = ausgabedateiAppend;
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setExterneListe(String[][] externeListe) {
        this.ExterneListe = externeListe;
    }

    public void setFelder() {
        this.Felder = FParam.getStringParameter("Felder", this.ArgTab);
    }

    public void setFelder(String felder) {
        this.Felder = FParam.checkStringParameter("Felder", felder, this.ArgTab);
    }

    public void setMitHeader() {
        this.MitHeader = FParam.getBooleanParameter("MitHeader", this.ArgTab);
    }

    public void setMitHeader(boolean mitHeader) {
        this.MitHeader = mitHeader;
    }

    public void setOhneFeldtypen() {
        this.OhneFeldtypen = FParam.getBooleanParameter("OhneFeldtypen", this.ArgTab);
    }

    public void setOhneFeldtypen(boolean ohneFeldnamen) {
        this.OhneFeldtypen = ohneFeldnamen;
    }

    public void setTabelle() {
        this.Tabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.Tabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setTrimFeldinhalte() {
        this.TrimFeldinhalte = FParam.getBooleanParameter("TrimFeldinhalte", this.ArgTab);
    }

    public void setTrimFeldinhalte(boolean trimFeldinhalte) {
        this.TrimFeldinhalte = trimFeldinhalte;
    }

    public void setWerteAusArgTab() {
        this.setAusgabedatei();
        this.setCharset();
        this.setDateiAppend();
        this.setDBName();
        this.setTabelle();
        this.setFelder();
        this.setWhere();
        this.setBefehle();
        this.setAnzahlZeilen();
        this.setTrennzeichen();
        this.setMitHeader();
        this.setOhneFeldtypen();
        this.setTrimFeldinhalte();
    }

    public void setWhere() {
        this.Where = FParam.getStringParameter("Where", this.ArgTab);
    }

    public void setWhere(String where) {
        FParam.instance();
        this.Where = FParam.checkStringParameter("Where", where, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Ausgabe: Datei bzw. Verzeichnis                                            :" + this.getAusgabedatei());
        fProt.prot("Charset (Codepage) fuer Ausgabedatei                                       :" + this.getCharset());
        fProt.prot("an Ausgabedatei anhaengen, falls vorhanden                                 :" + this.isDateiAppend());
        fProt.prot("DBName                                                                     :" + this.getDBName());
        fProt.prot("Tabelle                                                                    :" + this.getTabelle());
        fProt.prot("Feld(er), durch Komma getrennt anzugeben, es werden nur String extrahiert  :" + this.getFelder());
        fProt.prot("zusaetzliche Angaben zum Select, z.B. Where                                :" + this.getWhere());
        fProt.prot("Befehl(e) vor Ausfuehrung des Auslesens, durch Strichpunkt getrennt angeben:" + this.getBefehle());
        fProt.prot("Anzahl Zeilen                                                              :" + this.getAnzahlZeilen());
        fProt.prot("Trennzeichen (Separator)                                                   :" + this.getTrennzeichen());
        fProt.prot("Header mit Feldnamen ausgeben                                              :" + this.isMitHeader());
        fProt.prot("Ohne Feldtypen                                                             :" + this.isOhneFeldtypen());
        fProt.prot("Feldinhalte trimmen                                                        :" + this.isTrimFeldinhalte());
    }
}

