/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class SchreibenLog {
    private String Datei;
    private String Text;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean Overwrite;
    private String Trennzeichen;
    private boolean Swap;
    private boolean Prepend;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "20.12.2007";

    public static void main(String[] args) {
        SchreibenLog schreibenLog = new SchreibenLog(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(schreibenLog.ArgTab, schreibenLog.ArgTabDefault, schreibenLog.getHilfeText())) {
            try {
                schreibenLog.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + schreibenLog.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                schreibenLog.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + schreibenLog.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + schreibenLog.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public SchreibenLog() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public SchreibenLog(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "20.12.2007";
    }

    public String getText() {
        return this.Text;
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public boolean isOverwrite() {
        return this.Overwrite;
    }

    public boolean isPrepend() {
        return this.Prepend;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isSwap() {
        return this.Swap;
    }

    public void run() {
        FProt fProt = FProt.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()));
        String[] ZeileNeu = new String[1];
        String string = ZeileNeu[0] = this.isSwap() ? String.valueOf(this.getText()) + this.getTrennzeichen() + Futi.getZeit() : String.valueOf(Futi.getZeit()) + this.getTrennzeichen() + this.getText();
        if (this.getDatei().length() > 0) {
            FFile DateiF = new FFile(this.getDatei());
            if (this.isOverwrite()) {
                DateiF.StringArrayToInhalt(ZeileNeu);
                fProt.prot("String >" + ZeileNeu[0] + "< in Datei >" + this.getDatei() + "< geschrieben");
            } else {
                String[] Zeile = DateiF.inhaltToStringArray();
                if (this.isPrepend()) {
                    DateiF.StringArrayToInhalt(FString.verbindenStringArray(ZeileNeu, Zeile));
                    fProt.prot("String >" + ZeileNeu[0] + "< an Anfang der Datei >" + this.getDatei() + "< gestellt");
                } else {
                    DateiF.StringArrayToInhalt(FString.verbindenStringArray(Zeile, ZeileNeu));
                    fProt.prot("An Datei >" + this.getDatei() + "< String >" + ZeileNeu[0] + "< angefuegt");
                }
                fProt.prot(Zeile, 1);
            }
        }
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setOverwrite() {
        this.Overwrite = FParam.getBooleanParameter("Overwrite", this.ArgTab);
    }

    public void setOverwrite(boolean overwrite) {
        this.Overwrite = overwrite;
    }

    public void setPrepend() {
        this.Prepend = FParam.getBooleanParameter("Prepend", this.ArgTab);
    }

    public void setPrepend(boolean prepend) {
        this.Prepend = prepend;
    }

    public void setSwap() {
        this.Swap = FParam.getBooleanParameter("Swap", this.ArgTab);
    }

    public void setSwap(boolean swap) {
        this.Swap = swap;
    }

    public void setText() {
        this.Text = FParam.getStringParameter("Text", this.ArgTab);
    }

    public void setText(String text) {
        FParam.instance();
        this.Text = FParam.checkStringParameter("Text", text, this.ArgTab);
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        this.Trennzeichen = Futi.checkTrennzeichen(FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab), true, " ");
    }

    public void setWerteAusArgTab() {
        this.setDatei();
        this.setText();
        this.setTrennzeichen();
        this.setSwap();
        this.setOverwrite();
        this.setPrepend();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Logdatei                          :" + this.getDatei());
        fProt.prot("Text                              :" + this.getText());
        fProt.prot("Trennzeichen (Separator)          :" + this.getTrennzeichen());
        fProt.prot("Timestamp und Text vertauschen    :" + this.isSwap());
        fProt.prot("Datei ueberschreiben              :" + this.isOverwrite());
        fProt.prot("Am Anfang einfuegen, sonst am Ende:" + this.isPrepend());
    }
}

