/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class SQLBatch {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String DBName;
    private final boolean SetzenWerteInGUInachRun = false;
    private String Befehl;
    private boolean OhneFeldtypen;
    private boolean ShortForm;
    private String Datei;
    private String Ausgabe;
    private final String Stand = "2.1.2010";

    public static void main(String[] args) {
        SQLBatch sQLBatch = new SQLBatch(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(sQLBatch.ArgTab, sQLBatch.ArgTabDefault, sQLBatch.getHilfeText())) {
            try {
                sQLBatch.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + sQLBatch.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                sQLBatch.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + sQLBatch.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + sQLBatch.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public SQLBatch() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public SQLBatch(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getAusgabe() {
        return this.Ausgabe;
    }

    public String getBefehl() {
        return this.Befehl;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "2.1.2010";
    }

    public boolean isOhneFeldtypen() {
        return this.OhneFeldtypen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isShortForm() {
        return this.ShortForm;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FDB.instance();
        String[] Befehle = new String[]{this.getBefehl()};
        ArrayList<String> ausgabe = new ArrayList<String>();
        if (!this.isShortForm()) {
            ausgabe.add("Ausgabe SQL-Batch");
        }
        if (this.getDatei().length() > 0) {
            FFile bef = new FFile(this.getDatei());
            Befehle = FString.verbindenStringArray(Befehle, bef.inhaltToStringArray());
        }
        fProt.prot("DBName:" + this.getDBName() + ", Befehl:" + this.getDatei() + ", Datei mit Befehlen:" + this.getDatei(), 2);
        fProt.prot(Befehle, 2);
        Statement DBStatement = FDB.createDBStatement(this.getDBName());
        int i = 0;
        while (i < Befehle.length) {
            if (Befehle[i].length() > 0) {
                if (Befehle[i].toUpperCase().startsWith("SELECT ")) {
                    if (this.getAusgabe().length() > 0) {
                        String[] ergebnis;
                        if (!this.isShortForm()) {
                            ausgabe.add("Befehl Nr. " + (i + 1) + " : " + Befehle[i]);
                        }
                        String[] stringArray = ergebnis = FDB.resultSet2StringArray(FDB.executeQuery(DBStatement, Befehle[i], true, 0));
                        int n = ergebnis.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String Ergebnis = stringArray[n2];
                            ausgabe.add(Ergebnis);
                            ++n2;
                        }
                    } else {
                        fProt.prot(FDB.resultSet2StringArray(FDB.executeQuery(DBStatement, Befehle[i], true, 0)));
                    }
                } else {
                    FDB.executeUpdate(DBStatement, Befehle[i], true, 0);
                }
            }
            ++i;
        }
        if (this.getAusgabe().length() > 0) {
            FFile dat = new FFile(this.getAusgabe());
            dat.StringArrayListToInhalt(ausgabe);
        }
        FDB.closeDBStatement(DBStatement);
    }

    public void setAusgabe() {
        this.Ausgabe = FParam.getStringParameter("Ausgabe", this.ArgTab);
    }

    public void setAusgabe(String ausgabe) {
        FParam.instance();
        this.Ausgabe = FParam.checkStringParameter("Ausgabe", ausgabe, this.ArgTab);
    }

    public void setBefehl() {
        this.Befehl = FParam.getStringParameter("Befehl", this.ArgTab);
    }

    public void setBefehl(String befehl) {
        FParam.instance();
        this.Befehl = FParam.checkStringParameter("Befehl", befehl, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setOhneFeldtypen() {
        this.OhneFeldtypen = FParam.getBooleanParameter("OhneFeldtypen", this.ArgTab);
    }

    public void setOhneFeldtypen(boolean ohneFeldtypen) {
        this.OhneFeldtypen = ohneFeldtypen;
    }

    public void setShortForm() {
        this.ShortForm = FParam.getBooleanParameter("ShortForm", this.ArgTab);
    }

    public void setShortForm(boolean shortForm) {
        this.ShortForm = shortForm;
    }

    public void setWerteAusArgTab() {
        this.setDBName();
        this.setBefehl();
        this.setDatei();
        this.setAusgabe();
        this.setOhneFeldtypen();
        this.setShortForm();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("DBName                                         :" + this.getDBName());
        fProt.prot("SQL-Befehl                                     :" + this.getBefehl());
        fProt.prot("Eingabedatei                                   :" + this.getDatei());
        fProt.prot("Ausgabedatei                                   :" + this.getAusgabe());
        fProt.prot("Ohne Feldtypen                                 :" + this.isOhneFeldtypen());
        fProt.prot("Kurzform: bei Select nur Ergebnisdaten ausgeben:" + this.isShortForm());
    }
}

