/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class Rezepte {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String DBName;
    private String RezeptTabelle;
    private int Auswahl_letzte_Tage;
    private String SchlagwortTabelle;
    private String SchlagwortAusnahmenTabelle;
    private String Funktion;
    private int Von;
    private int Bis;
    private boolean Schlagworte_loeschen;
    private boolean Zubereitung_in_Schlagworte;
    private String Verzeichnis;
    private final boolean SetzenWerteInGUInachRun = false;
    private int Auswahl_neueste;
    private final String Stand = "25.9.09";

    private static String getClearAndEncloseVariable(String str) {
        String rc = str;
        rc = rc != null && rc.length() > 0 ? rc.replace('\"', '\'') : "";
        return "\"" + rc + "\"";
    }

    public static void main(String[] args) {
        Rezepte rezepte = new Rezepte(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(rezepte.ArgTab, rezepte.ArgTabDefault, rezepte.getHilfeText())) {
            try {
                rezepte.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + rezepte.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                rezepte.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + rezepte.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + rezepte.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Rezepte() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Rezepte(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private String checkAndSetVariable() {
        FDB fDB = FDB.instance();
        String sqlStatement = "";
        this.setVerzeichnis(FDatei.checkFileSeperator(this.getVerzeichnis(), true));
        Statement DBStatement = FDB.createDBStatement(this.getDBName());
        if (DBStatement != null) {
            ResultSet rs;
            if (this.getAuswahl_neueste() > 0 && (rs = FDB.executeQuery(DBStatement, "SELECT COUNT(*) as Anzahl from (SELECT RezeptNr FROM " + fDB.getName4Query(this.getRezeptTabelle()) + " GROUP BY RezeptNr)")) != null) {
                try {
                    while (rs.next()) {
                        this.setVon(rs.getInt("Anzahl") - this.getAuswahl_neueste() + 1);
                        FProt.instance().prot("Auswahl neueste: Von auf >" + this.getVon() + "< gesetzt!");
                    }
                }
                catch (SQLException SQLe) {
                    FDB.handleException(SQLe);
                }
            }
            if (this.getAuswahl_letzte_Tage() > 0) {
                FGregorianCalendar cal = new FGregorianCalendar(System.currentTimeMillis());
                cal.add(6, -this.getAuswahl_letzte_Tage());
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 1);
                long stichtag = cal.getTimeInMillis();
                int letzteNr = 0;
                rs = FDB.executeQuery(DBStatement, "SELECT RezeptNr, Datum FROM (SELECT RezeptNr, Datum FROM " + fDB.getName4Query(this.getRezeptTabelle()) + " GROUP BY RezeptNr, Datum) ORDER BY Datum DESC");
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            long datumRezept = rs.getTimestamp("Datum").getTime();
                            if (datumRezept > stichtag) {
                                letzteNr = rs.getInt("RezeptNr");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SQLException SQLe) {
                        FDB.handleException(SQLe);
                    }
                }
                this.setVon(Math.max(letzteNr, this.getVon()));
                FProt.instance().prot("Auswahl letzte Tage: Von auf >" + this.getVon() + "< gesetzt!");
            }
        }
        FDB.closeDBStatement(DBStatement);
        if (this.getFunktion().compareTo("B") == 0 || this.getFunktion().compareTo("A") == 0) {
            sqlStatement = "SELECT RezeptNr, ZutatenNr, Name, Einheit, Zutat,  Art, Autor, Bild, Bemerkung, Sonstiges, Zutaten_Zusatz, Zubereitung, Datum FROM " + fDB.getName4Query(this.getRezeptTabelle()) + " where RezeptNr >= " + this.getVon() + " and RezeptNr <=" + this.getBis() + " Order by " + (this.getFunktion().compareTo("A") == 0 ? "Art, " : "") + "RezeptNr, ZutatenNr";
        } else {
            sqlStatement = "SELECT RezeptNr, Name, Art, Autor, vollst\u00e4ndig, Bemerkung, Einheit, Zutat, Zutaten_Zusatz, Zubereitung FROM " + fDB.getName4Query(this.getRezeptTabelle()) + " where RezeptNr >= " + this.getVon() + " and RezeptNr <=" + this.getBis();
            if (this.getAuswahl_neueste() > 0) {
                sqlStatement = String.valueOf(sqlStatement) + " Order by RezeptNr Desc";
            }
        }
        return sqlStatement;
    }

    private void fillSchlagworte(HashMap<String, Integer> Werte, HashMap<String, Integer> Ausnahmen) {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        String Schlagwort = "";
        Statement DBStatement = FDB.createDBStatement(this.getDBName());
        if (DBStatement != null) {
            ResultSet rs;
            if (!this.isSchlagworte_loeschen()) {
                rs = FDB.executeQuery(DBStatement, "SELECT RezeptNr, Schlagwort FROM " + fDB.getName4Query(this.getSchlagwortTabelle()));
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            int RezeptNr = rs.getInt("RezeptNr");
                            Schlagwort = rs.getString("Schlagwort").trim();
                            fProt.prot(String.valueOf(RezeptNr) + " " + Schlagwort, 2);
                            Werte.put(String.valueOf(RezeptNr) + Schlagwort, new Integer(1));
                        }
                    }
                    catch (SQLException SQLe) {
                        FDB.handleException(SQLe);
                    }
                }
            } else {
                FDB.executeUpdate(DBStatement, "DELETE * FROM " + fDB.getName4Query(this.getSchlagwortTabelle()), true, 1);
            }
            if ((rs = FDB.executeQuery(DBStatement, "SELECT Schlagwort FROM " + fDB.getName4Query(this.getSchlagwortAusnahmenTabelle()))) != null) {
                try {
                    while (rs.next()) {
                        Schlagwort = rs.getString("Schlagwort").trim();
                        fProt.prot(Schlagwort, 2);
                        Ausnahmen.put(Schlagwort, new Integer(1));
                    }
                }
                catch (SQLException SQLe) {
                    FDB.handleException(SQLe);
                }
            }
            FDB.closeDBStatement(DBStatement);
        }
    }

    public int getAuswahl_letzte_Tage() {
        return this.Auswahl_letzte_Tage;
    }

    public int getAuswahl_neueste() {
        return this.Auswahl_neueste;
    }

    public int getBis() {
        return this.Bis;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getRezeptTabelle() {
        return this.RezeptTabelle;
    }

    public String getSchlagwortAusnahmenTabelle() {
        return this.SchlagwortAusnahmenTabelle;
    }

    public String getSchlagwortTabelle() {
        return this.SchlagwortTabelle;
    }

    public String getStand() {
        return "25.9.09";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public int getVon() {
        return this.Von;
    }

    public boolean isSchlagworte_loeschen() {
        return this.Schlagworte_loeschen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isZubereitung_in_Schlagworte() {
        return this.Zubereitung_in_Schlagworte;
    }

    public void run() {
        Statement DBStatement;
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        int LRezeptNr = -1;
        String Art = "";
        String LArt = null;
        FGregorianCalendar kal = new FGregorianCalendar();
        String Schlagwort = "";
        String Zutaten = "";
        String sqlStatement = "";
        String Zeile = "";
        String Name = "";
        String Zutaten_Zusatz = "";
        String Zubereitung = "";
        String Autor = "";
        String Bild = "";
        String Bemerkung = "";
        String Sonstiges = "";
        long Datum = 0L;
        HashMap<String, Integer> Werte = new HashMap<String, Integer>();
        HashMap<String, Integer> Ausnahmen = new HashMap<String, Integer>();
        ArrayList<String> CSVDatei = new ArrayList<String>();
        ArrayList<String> Array2 = new ArrayList<String>();
        sqlStatement = this.checkAndSetVariable();
        if (this.getFunktion().compareTo("S") == 0) {
            this.fillSchlagworte(Werte, Ausnahmen);
        }
        if ((DBStatement = FDB.createDBStatement(this.getDBName())) != null) {
            ResultSet rs = FDB.executeQuery(DBStatement, sqlStatement);
            if (rs != null) {
                int i;
                try {
                    while (rs.next()) {
                        int RezeptNr = rs.getInt("RezeptNr");
                        String Einheit = rs.getString("Einheit").trim();
                        String Zutat = rs.getString("Zutat").trim();
                        if (this.getFunktion().compareTo("S") == 0) {
                            Integer Pos2;
                            Zutat = FDB.replaceSonderzeichen(Zutat);
                            String[] Teile = FString.deleteDoppelte(Zutat.split(" "), 2);
                            fProt.prot(Teile, 3);
                            i = 0;
                            while (i < Teile.length) {
                                Schlagwort = Teile[i].trim();
                                if (Schlagwort.length() > 0) {
                                    fProt.prot(String.valueOf(RezeptNr) + " " + Schlagwort, 2);
                                    Pos2 = Ausnahmen.get(Schlagwort);
                                    if (Pos2 == null && (Pos2 = Werte.get(String.valueOf(RezeptNr) + Schlagwort)) == null) {
                                        Werte.put(String.valueOf(RezeptNr) + Schlagwort, new Integer(1));
                                        fProt.prot(String.valueOf(RezeptNr) + " " + Schlagwort + " insert", 2);
                                        Array2.add("INSERT INTO " + this.getSchlagwortTabelle() + " VALUES (" + RezeptNr + ", '" + Schlagwort.replace("'", "''") + "')");
                                    }
                                }
                                ++i;
                            }
                            if (LRezeptNr != RezeptNr) {
                                Zeile = rs.getString("Name").trim();
                                if (this.isZubereitung_in_Schlagworte()) {
                                    Zeile = String.valueOf(Zeile) + rs.getString("Zubereitung").trim();
                                }
                                Zeile = FDB.replaceSonderzeichen(Zeile);
                                Teile = FString.deleteDoppelte(Zeile.split(" "), 2);
                                fProt.prot(Teile, 3);
                                i = 0;
                                while (i < Teile.length) {
                                    Schlagwort = Teile[i].trim();
                                    if (Schlagwort.length() > 0) {
                                        fProt.prot(String.valueOf(RezeptNr) + " " + Schlagwort, 2);
                                        Pos2 = Werte.get(String.valueOf(RezeptNr) + Schlagwort);
                                        if (Pos2 == null) {
                                            Werte.put(String.valueOf(RezeptNr) + Schlagwort, new Integer(1));
                                            fProt.prot(String.valueOf(RezeptNr) + " " + Schlagwort + " insert", 2);
                                            Array2.add("INSERT INTO " + this.getSchlagwortTabelle() + " VALUES (" + RezeptNr + ", '" + Schlagwort.replace("'", "''") + "')");
                                        }
                                    }
                                    ++i;
                                }
                                LRezeptNr = RezeptNr;
                            }
                        }
                        if (this.getFunktion().compareTo("B") != 0 && this.getFunktion().compareTo("A") != 0) continue;
                        if (LRezeptNr != RezeptNr && LRezeptNr > 0) {
                            if (this.getFunktion().compareTo("A") == 0) {
                                if (LArt != null && LArt.compareTo(Art) != 0) {
                                    new FFile(String.valueOf(this.getVerzeichnis()) + "Bento-" + LArt + ".csv").StringArrayToInhalt(FString.arrayListToStringArray(CSVDatei));
                                    CSVDatei.clear();
                                    fProt.prot(String.valueOf(LArt) + "->" + Art, 2);
                                }
                                LArt = Art;
                            }
                            if (CSVDatei.size() == 0) {
                                Zeile = "Nr;Name;Zutaten;ZutatenZusatz;Zubereitung;Art;Autor;Bild;Bemerkung;Sonstiges;Erfassungsdatum";
                                fProt.prot(Zeile, 2);
                                CSVDatei.add(Zeile);
                            }
                            kal.setTime(Datum);
                            if (kal.get(11) == 0) {
                                kal.set(11, 10);
                            }
                            Zeile = String.valueOf(Rezepte.getClearAndEncloseVariable(String.valueOf(LRezeptNr))) + ";" + Name + ";" + Rezepte.getClearAndEncloseVariable(Zutaten) + ";" + Zutaten_Zusatz + ";" + Zubereitung + ";" + Art + ";" + Autor + ";" + Bild + ";" + Bemerkung + ";" + Sonstiges + ";" + kal.toGermanFormat('B');
                            fProt.prot(Zeile, 2);
                            CSVDatei.add(Zeile);
                            Zutaten = "";
                        }
                        Zutaten = String.valueOf(Zutaten) + (Zutaten.length() > 0 ? System.getProperty("line.separator") : "") + Einheit + " " + Zutat;
                        Name = Rezepte.getClearAndEncloseVariable(rs.getString("Name"));
                        Zutaten_Zusatz = Rezepte.getClearAndEncloseVariable(rs.getString("Zutaten_Zusatz"));
                        Zubereitung = Rezepte.getClearAndEncloseVariable(rs.getString("Zubereitung"));
                        Art = rs.getString("Art");
                        Autor = Rezepte.getClearAndEncloseVariable(rs.getString("Autor"));
                        Bild = Rezepte.getClearAndEncloseVariable(rs.getString("Bild"));
                        Bemerkung = Rezepte.getClearAndEncloseVariable(rs.getString("Bemerkung"));
                        Sonstiges = Rezepte.getClearAndEncloseVariable(rs.getString("Sonstiges"));
                        Datum = rs.getTimestamp("Datum").getTime();
                        LRezeptNr = RezeptNr;
                    }
                }
                catch (SQLException SQLe) {
                    FDB.handleException(SQLe);
                }
                if (this.getFunktion().compareTo("S") == 0) {
                    Array2.add("DELETE * FROM " + fDB.getName4Query(this.getSchlagwortTabelle()) + " WHERE Schlagwort In (SELECT * FROM " + fDB.getName4Query(this.getSchlagwortAusnahmenTabelle()) + ")");
                    i = 0;
                    while (i < Array2.size()) {
                        FDB.executeUpdate(DBStatement, (String)Array2.get(i), true, 2);
                        ++i;
                    }
                }
                if (this.getFunktion().compareTo("B") == 0 || this.getFunktion().compareTo("A") == 0) {
                    kal.setTime(Datum);
                    if (kal.get(11) == 0) {
                        kal.set(11, 10);
                    }
                    Zeile = String.valueOf(Rezepte.getClearAndEncloseVariable(String.valueOf(LRezeptNr))) + ";" + Name + ";" + Art + ";" + Autor + ";" + Bild + ";" + Bemerkung + ";" + Sonstiges + ";" + kal.toGermanFormat('B') + ";" + Rezepte.getClearAndEncloseVariable(Zutaten) + ";" + Zutaten_Zusatz + ";" + Zubereitung;
                    fProt.prot(Zeile, 2);
                    CSVDatei.add(Zeile);
                    new FFile(String.valueOf(this.getVerzeichnis()) + "Bento" + (this.getFunktion().compareTo("A") == 0 ? "-" + Art : "") + ".csv").StringArrayListToInhalt(CSVDatei);
                }
            }
            FDB.closeDBStatement(DBStatement);
        }
    }

    public void setAuswahl_letzte_Tage() {
        this.Auswahl_letzte_Tage = FParam.getIntParameter("Auswahl_letzte_Tage", this.ArgTab);
    }

    public void setAuswahl_letzte_Tage(int auswahl_letzte_Tage) {
        this.Auswahl_letzte_Tage = FParam.checkIntParameter("Auswahl_letzte_Tage", auswahl_letzte_Tage, this.ArgTab);
    }

    public void setAuswahl_letzte_Tage(String auswahl_letzte_Tage) {
        this.Auswahl_letzte_Tage = FParam.checkIntParameter("Auswahl_letzte_Tage", auswahl_letzte_Tage, this.ArgTab);
    }

    public void setAuswahl_neueste() {
        this.Auswahl_neueste = FParam.getIntParameter("Auswahl_neueste", this.ArgTab);
    }

    public void setAuswahl_neueste(int auswahl_neueste) {
        FParam.instance();
        this.Auswahl_neueste = FParam.checkIntParameter("Auswahl_neueste", auswahl_neueste, this.ArgTab);
    }

    public void setAuswahl_neueste(String auswahl_neueste) {
        this.Auswahl_neueste = FParam.checkIntParameter("Auswahl_neueste", auswahl_neueste, this.ArgTab);
    }

    public void setBis() {
        this.Bis = FParam.getIntParameter("Bis", this.ArgTab);
    }

    public void setBis(int bis) {
        FParam.instance();
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setBis(String bis) {
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setRezeptTabelle() {
        this.RezeptTabelle = FParam.getStringParameter("RezeptTabelle", this.ArgTab);
    }

    public void setRezeptTabelle(String rezeptTabelle) {
        FParam.instance();
        this.RezeptTabelle = FParam.checkStringParameter("RezeptTabelle", rezeptTabelle, this.ArgTab);
    }

    public void setSchlagwortAusnahmenTabelle() {
        this.SchlagwortAusnahmenTabelle = FParam.getStringParameter("SchlagwortAusnahmenTabelle", this.ArgTab);
    }

    public void setSchlagwortAusnahmenTabelle(String schlagwortAusnahmenTabelle) {
        this.SchlagwortAusnahmenTabelle = FParam.checkStringParameter("SchlagwortAusnahmenTabelle", schlagwortAusnahmenTabelle, this.ArgTab);
    }

    public void setSchlagworte_loeschen() {
        this.Schlagworte_loeschen = FParam.getBooleanParameter("Schlagworte_loeschen", this.ArgTab);
    }

    public void setSchlagworte_loeschen(boolean schlagworte_loeschen) {
        this.Schlagworte_loeschen = schlagworte_loeschen;
    }

    public void setSchlagwortTabelle() {
        this.SchlagwortTabelle = FParam.getStringParameter("SchlagwortTabelle", this.ArgTab);
    }

    public void setSchlagwortTabelle(String schlagwortTabelle) {
        FParam.instance();
        this.SchlagwortTabelle = FParam.checkStringParameter("SchlagwortTabelle", schlagwortTabelle, this.ArgTab);
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setVon() {
        this.Von = FParam.getIntParameter("Von", this.ArgTab);
    }

    public void setVon(int von) {
        FParam.instance();
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setVon(String von) {
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setDBName();
        this.setRezeptTabelle();
        this.setSchlagwortTabelle();
        this.setSchlagwortAusnahmenTabelle();
        this.setSchlagworte_loeschen();
        this.setZubereitung_in_Schlagworte();
        this.setVerzeichnis();
        this.setAuswahl_neueste();
        this.setAuswahl_letzte_Tage();
        this.setVon();
        this.setBis();
    }

    public void setZubereitung_in_Schlagworte() {
        this.Zubereitung_in_Schlagworte = FParam.getBooleanParameter("Zubereitung_in_Schlagworte", this.ArgTab);
    }

    public void setZubereitung_in_Schlagworte(boolean zubereitung_in_Schlagworte) {
        this.Zubereitung_in_Schlagworte = zubereitung_in_Schlagworte;
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Funktion                                       :" + this.getFunktion());
        fProt.prot("DBName                                         :" + this.getDBName());
        fProt.prot("Name der Tabelle mit Rezepten                  :" + this.getRezeptTabelle());
        fProt.prot("Name der Tabelle mit Schlagworten              :" + this.getSchlagwortTabelle());
        fProt.prot("Name der Tabelle unbedeutenden Schlagworten    :" + this.getSchlagwortAusnahmenTabelle());
        fProt.prot("Schlagworte loeschen (bei Funktion=S)          :" + this.isSchlagworte_loeschen());
        fProt.prot("Zubereitung in Schlagworte (bei Funktion=S)    :" + this.isZubereitung_in_Schlagworte());
        fProt.prot("Verzeichnis fuer Ausgabe (bei Funktion=B, H, V):" + this.getVerzeichnis());
        fProt.prot("Auswahl neueste Rezepte                        :" + this.getAuswahl_neueste());
        fProt.prot("Auswahl Rezepte der letzten Tage               :" + this.getAuswahl_letzte_Tage());
        fProt.prot("von Rezepte Nr.                                :" + this.getVon());
        fProt.prot("bis Rezepte Nr.                                :" + this.getBis());
    }
}

