/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBild;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class Homepage {
    private String Verzeichnis;
    private int Max_1;
    private int Max_2;
    private String[][][] Titel;
    private String[][][] Punkt;
    private final char ArtBilder = (char)98;
    private final char ArtSeiten = (char)115;
    private final char ArtVerweis = (char)118;
    private final char ArtLink = (char)108;
    private final char ArtVerzeichnis = (char)100;
    private final char ArtMenue = (char)109;
    private int Max_3;
    private int[][][] Ebene;
    private String Datei;
    private final int BreiteSteuerung = 10;
    private int BreiteText;
    private int BreiteBilder;
    private String NameVerweisDateien;
    private boolean PruefenBildgroesse;
    private boolean AlsHomepage;
    private boolean KeinBackupOriginalbild;
    private int Breite;
    private int Hoehe;
    private boolean NeueDias;
    private int DiaBreite;
    private int DiaHoehe;
    private int ProzentRahmen;
    private final String BilderExtent = "jpg";
    private final String[] SeitenExtent = new String[]{"htm", "html", "pdf"};
    private final String MenueName = "Menue." + this.SeitenExtent[0];
    private final String DatenName = "Daten." + this.SeitenExtent[0];
    private final String IndexName = "Index." + this.SeitenExtent[0];
    private final String PlusName = "Symbole/Plus.gif";
    private final String MinusName = "Symbole/Minus.gif";
    private final String[] Rueckwaerts = new String[]{"", "../", "../../", "../../../"};
    private final String[] Blank = new String[]{"", " ", "  ", "   "};
    private final String[] Spalte = new String[]{"", "<td width=\"" + 10 + "\">&nbsp;</td>", "<td width=\"" + 10 + "\">&nbsp;</td><td width=\"" + 10 + "\">&nbsp;</td>", "<td width=\"" + 10 + "\">&nbsp;</td><td width=\"" + 10 + "\">&nbsp;</td><td width=\"" + 10 + "\">&nbsp;</td>"};
    private final String HintergrundName = "Symbole/Hintergrund.jpg";
    private final String DiaOrig = ".jpg_t";
    private final String DiaSuffix = "_dia";
    private final String IndexOrig = "~1";
    private final String SmallSuffix = "_small";
    private final String Aufsetzpunkt = "Aufsetzpunkt";
    private boolean NeueIndexbilder;
    private final boolean SetzenWerteInGUInachRun = false;
    private int IndexBreite;
    private int IndexHoehe;
    private String Schriftart;
    private int Schriftgroesse;
    private char[][][] Art;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "1.6.2009";

    public static void main(String[] args) {
        Homepage homepage = new Homepage(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(homepage.ArgTab, homepage.ArgTabDefault, homepage.getHilfeText())) {
            try {
                homepage.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + homepage.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                homepage.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + homepage.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + homepage.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Homepage() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Homepage(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public void erstellenIndexSeite(BufferedWriter HtmlDatei) {
        FProt fProt = FProt.instance();
        try {
            HtmlDatei.write("<html>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<head>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<meta http-equiv=\"Content-Type\"");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("content=\"text/html; charset=iso-8859-1\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<meta name=\"GENERATOR\" content=\"Java-Applikation java by J.Fischer\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<title>Homepage von Gerlinde und Johann Fischer</title>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</head>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<frameset cols=\"" + (this.getBreiteText() + 40) + ",*\" frameborder=\"NO\" border=\"0\" framespacing=\"0\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<frame src=\"" + this.getMenueName() + "\" name=\"Menue\" frameborder=\"NO\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<frame src=\"" + this.getDatenName() + "\" name=\"Daten\" frameborder=\"NO\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</frameset>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<body>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</body>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</html>");
            HtmlDatei.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            fProt.prot("IO-Exception in erstellenIndexSeite bei " + e.getMessage());
        }
    }

    public String[] erstellenListe(File Dir, char aArt) {
        FProt fProt = FProt.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        FBild.instance();
        String[] Liste2 = null;
        String[] file = new String[]{};
        FFile WorkDatei = null;
        File CheckDia = null;
        File CheckIndex = null;
        ArrayList<String> Dateien = new ArrayList<String>();
        FDatei.renameDateien(Dir.toString(), this.getBilderExtent(), this.getDiaOrig(), this.getDiaSuffix(), 0, false);
        FDatei.renameDateien(Dir.toString(), this.getBilderExtent(), this.getIndexOrig(), this.getSmallSuffix(), 0, false);
        if (aArt == this.getArtVerweis() || aArt == this.getArtLink()) {
            FFile Verweise = new FFile(Dir, this.getNameVerweisDateien());
            if (!Verweise.exists()) {
                fProt.prot("VerweisDatei >" + Verweise.getName() + "< nicht vorhanden!");
            } else {
                file = Verweise.inhaltToStringArray();
            }
        } else {
            file = Dir.list();
            file = fQuickSort.quickSort(file, true, true);
        }
        fProt.prot("Dateien vor Pruefung", 2);
        fProt.prot(file, 2);
        int i = 0;
        while (i < file.length) {
            int j;
            boolean isValidSeitenExtent;
            if (aArt == this.getArtBilder() || aArt == this.getArtVerweis()) {
                if (file[i].endsWith("." + this.getBilderExtent()) && !file[i].endsWith("_small." + this.getBilderExtent()) && !file[i].endsWith("_dia." + this.getBilderExtent()) && !file[i].endsWith("." + this.getBilderExtent() + "." + this.getBilderExtent())) {
                    String DateiName = Dir + System.getProperty("file.separator") + file[i];
                    WorkDatei = new FFile(DateiName);
                    String CheckDiaName = Dir + System.getProperty("file.separator") + file[i].substring(0, file[i].length() - (1 + this.getBilderExtent().length())) + this.getDiaSuffix() + "." + this.getBilderExtent();
                    CheckDia = new File(CheckDiaName);
                    String CheckIndexName = Dir + System.getProperty("file.separator") + file[i].substring(0, file[i].length() - (1 + this.getBilderExtent().length())) + this.getSmallSuffix() + "." + this.getBilderExtent();
                    CheckIndex = new File(CheckIndexName);
                    if (this.isPruefenBildgroesse()) {
                        FBild.setzenGroesse(DateiName, DateiName, this.getBreite(), this.getHoehe(), -1, null, !this.isKeinBackupOriginalbild());
                        fProt.prot("Datei >" + DateiName + "< Groesse checken", 5);
                    }
                    if (!CheckDia.exists() || this.isNeueDias()) {
                        FBild.setzenGroesse(DateiName, CheckDiaName, this.getDiaBreite(), this.getDiaHoehe(), this.getProzentRahmen(), null, !this.isKeinBackupOriginalbild());
                        fProt.prot("Datei >" + DateiName + "<, Dia >" + CheckDiaName + "<", 5);
                    }
                    if (!CheckIndex.exists() || this.isNeueIndexbilder()) {
                        FBild.setzenGroesse(DateiName, CheckIndexName, this.getIndexBreite(), this.getIndexHoehe(), -1, null, !this.isKeinBackupOriginalbild());
                        fProt.prot("Datei >" + DateiName + "<, Indexbild >" + CheckIndexName + "<", 5);
                    }
                    if (WorkDatei.exists() && CheckIndex.exists()) {
                        Dateien.add(file[i]);
                    }
                }
            } else if (aArt == this.getArtLink()) {
                isValidSeitenExtent = false;
                j = 0;
                while (j < this.getSeitenExtent().length) {
                    if (file[i].endsWith("." + this.getSeitenExtent()[j])) {
                        isValidSeitenExtent = true;
                        break;
                    }
                    ++j;
                }
                if (isValidSeitenExtent && file[i].compareTo(this.getMenueName()) != 0 && !file[i].endsWith("_Druck." + this.getSeitenExtent()) && (WorkDatei = new FFile(Dir + System.getProperty("file.separator") + file[i])).exists()) {
                    Dateien.add(file[i]);
                }
            } else {
                isValidSeitenExtent = false;
                j = 0;
                while (j < this.getSeitenExtent().length) {
                    if (file[i].endsWith("." + this.getSeitenExtent()[j])) {
                        isValidSeitenExtent = true;
                        break;
                    }
                    ++j;
                }
                if (isValidSeitenExtent && file[i].compareTo(this.getMenueName()) != 0 && !file[i].endsWith("_Druck." + this.getSeitenExtent())) {
                    Dateien.add(file[i]);
                }
            }
            ++i;
        }
        Liste2 = FString.arrayListToStringArray(Dateien);
        return Liste2;
    }

    public void fuellenStrukturtabellen() {
        FProt fProt = FProt.instance();
        File Struktur = null;
        BufferedReader LesenStruktur = null;
        this.setMax_1(0);
        this.setMax_2(0);
        this.setMax_3(0);
        Struktur = new File(this.getDatei());
        if (!Struktur.exists()) {
            fProt.prot("Strukturdatei >" + this.getDatei() + "< nicht vorhanden!");
        } else {
            try {
                LesenStruktur = new BufferedReader(new FileReader(Struktur));
                LesenStruktur.mark(1000000);
                int Durchlauf = 1;
                while (Durchlauf <= 2) {
                    String Zeile;
                    int Anzahl_3 = 0;
                    int Anzahl_2 = 0;
                    int Anzahl_1 = 0;
                    while ((Zeile = LesenStruktur.readLine()) != null) {
                        int Ebene_x;
                        if (Zeile.length() <= 1) continue;
                        if (Zeile.charAt(1) != ' ') {
                            Ebene_x = 1;
                            ++Anzahl_1;
                            Anzahl_2 = 0;
                            Anzahl_3 = 0;
                        } else if (Zeile.charAt(2) != ' ') {
                            Ebene_x = 2;
                            if (Durchlauf == 1 && ++Anzahl_2 > this.getMax_2()) {
                                this.setMax_2(Anzahl_2);
                            }
                            Anzahl_3 = 0;
                        } else {
                            Ebene_x = 3;
                            if (Durchlauf == 1 && ++Anzahl_3 > this.getMax_3()) {
                                this.setMax_3(Anzahl_3);
                            }
                        }
                        if (Durchlauf != 2) continue;
                        this.Ebene[Anzahl_1][Anzahl_2][Anzahl_3] = Ebene_x;
                        this.Art[Anzahl_1][Anzahl_2][Anzahl_3] = Zeile.charAt(0);
                        if (Zeile.indexOf(32, Ebene_x) > 0) {
                            this.Punkt[Anzahl_1][Anzahl_2][Anzahl_3] = Zeile.substring(Ebene_x, Zeile.indexOf(32, Ebene_x));
                            this.Titel[Anzahl_1][Anzahl_2][Anzahl_3] = Zeile.substring(Zeile.indexOf(32, Ebene_x)).trim();
                        } else {
                            this.Punkt[Anzahl_1][Anzahl_2][Anzahl_3] = Zeile.substring(Ebene_x);
                            this.Titel[Anzahl_1][Anzahl_2][Anzahl_3] = Zeile.substring(Ebene_x);
                        }
                        fProt.prot(String.valueOf(Anzahl_1) + "." + Anzahl_2 + "." + Anzahl_3 + ". " + this.Ebene[Anzahl_1][Anzahl_2][Anzahl_3] + " - " + this.Art[Anzahl_1][Anzahl_2][Anzahl_3] + " - " + this.getBlank()[Ebene_x - 1] + this.Punkt[Anzahl_1][Anzahl_2][Anzahl_3] + " - " + this.Titel[Anzahl_1][Anzahl_2][Anzahl_3], 1);
                    }
                    if (Durchlauf == 1) {
                        LesenStruktur.reset();
                        this.setMax_1(Anzahl_1 + 1);
                        this.setMax_2(this.getMax_2() + 1);
                        this.setMax_3(this.getMax_3() + 1);
                        this.Titel = new String[this.getMax_1()][this.getMax_2()][this.getMax_3()];
                        this.Punkt = new String[this.getMax_1()][this.getMax_2()][this.getMax_3()];
                        this.Art = new char[this.getMax_1()][this.getMax_2()][this.getMax_3()];
                        this.Ebene = new int[this.getMax_1()][this.getMax_2()][this.getMax_3()];
                    }
                    ++Durchlauf;
                }
            }
            catch (IOException e) {
                fProt.prot("IO-Exception in fuellenStrukturTabellen bei " + e.getMessage());
            }
        }
    }

    public char getArtBilder() {
        return 'b';
    }

    public char getArtLink() {
        return 'l';
    }

    public char getArtMenue() {
        return 'm';
    }

    public char getArtSeiten() {
        return 's';
    }

    public char getArtVerweis() {
        return 'v';
    }

    public char getArtVerzeichnis() {
        return 'd';
    }

    public String getAufsetzpunkt() {
        return "Aufsetzpunkt";
    }

    public String getBilderExtent() {
        return "jpg";
    }

    public String[] getBlank() {
        return this.Blank;
    }

    public int getBreite() {
        return this.Breite;
    }

    public int getBreiteBilder() {
        return this.BreiteBilder;
    }

    public int getBreiteSteuerung() {
        return 10;
    }

    public int getBreiteText() {
        return this.BreiteText;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDatenName() {
        return this.DatenName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public int getDiaBreite() {
        return this.DiaBreite;
    }

    public int getDiaHoehe() {
        return this.DiaHoehe;
    }

    public String getDiaOrig() {
        return ".jpg_t";
    }

    public String getDiaSuffix() {
        return "_dia";
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getHintergrundName() {
        return "Symbole/Hintergrund.jpg";
    }

    public int getHoehe() {
        return this.Hoehe;
    }

    public int getIndexBreite() {
        return this.IndexBreite;
    }

    public int getIndexHoehe() {
        return this.IndexHoehe;
    }

    public String getIndexName() {
        return this.IndexName;
    }

    public String getIndexOrig() {
        return "~1";
    }

    public int getMax_1() {
        return this.Max_1;
    }

    public int getMax_2() {
        return this.Max_2;
    }

    public int getMax_3() {
        return this.Max_3;
    }

    public String getMenueName() {
        return this.MenueName;
    }

    public String getMinusName() {
        return "Symbole/Minus.gif";
    }

    public String getNameVerweisDateien() {
        return this.NameVerweisDateien;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getPlusName() {
        return "Symbole/Plus.gif";
    }

    public int getProzentRahmen() {
        return this.ProzentRahmen;
    }

    public String[] getRueckwaerts() {
        return this.Rueckwaerts;
    }

    public String getSchriftart() {
        return this.Schriftart;
    }

    public int getSchriftgroesse() {
        return this.Schriftgroesse;
    }

    public String[] getSeitenExtent() {
        return this.SeitenExtent;
    }

    public String getSmallSuffix() {
        return "_small";
    }

    public String[] getSpalte() {
        return this.Spalte;
    }

    public String getStand() {
        return "1.6.2009";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public boolean isAlsHomepage() {
        return this.AlsHomepage;
    }

    public boolean isKeinBackupOriginalbild() {
        return this.KeinBackupOriginalbild;
    }

    public boolean isNeueDias() {
        return this.NeueDias;
    }

    public boolean isNeueIndexbilder() {
        return this.NeueIndexbilder;
    }

    public boolean isPruefenBildgroesse() {
        return this.PruefenBildgroesse;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        FProt fProt = FProt.instance();
        if (this.getVerzeichnis().length() > 0 && this.getDatei().length() > 0) {
            File Dir = null;
            File Menue = null;
            File Daten = null;
            BufferedWriter SchreibenMenue = null;
            BufferedWriter SchreibenDaten = null;
            String[] Name = new String[3];
            this.fuellenStrukturtabellen();
            try {
                Menue = new File(this.getVerzeichnis(), this.getMenueName());
                SchreibenMenue = new BufferedWriter(new FileWriter(Menue));
                this.schreibenKopf(SchreibenMenue, "Home", 0, this.getArtMenue());
                int i = 1;
                while (i < this.getMax_1()) {
                    this.schreibenBaum(SchreibenMenue, this.Punkt[i][0][0], '+', 0, 1, this.Art[i][0][0]);
                    ++i;
                }
                this.schreibenFuss(SchreibenMenue, this.getArtMenue());
                fProt.prot(Menue + " erstellt", 1);
                SchreibenMenue.close();
                Daten = new File(this.getVerzeichnis(), this.getDatenName());
                if (!Daten.exists()) {
                    SchreibenDaten = new BufferedWriter(new FileWriter(Daten));
                    this.schreibenKopf(SchreibenDaten, "Daten", 0, ' ');
                    this.schreibenFuss(SchreibenDaten, ' ');
                    fProt.prot(Daten + " erstellt", 1);
                    SchreibenDaten.close();
                }
                if (!(Daten = new File(this.getVerzeichnis(), this.getIndexName())).exists()) {
                    SchreibenDaten = new BufferedWriter(new FileWriter(Daten));
                    this.erstellenIndexSeite(SchreibenDaten);
                    fProt.prot(Daten + " erstellt", 1);
                    SchreibenDaten.close();
                }
                int e1 = 1;
                while (e1 < this.getMax_1()) {
                    int e2 = 0;
                    while (e2 < this.getMax_2()) {
                        int e3 = 0;
                        while (e3 < this.getMax_3()) {
                            if (this.Art[e1][e2][e3] > '\u0000') {
                                char aArt = this.Art[e1][e2][e3];
                                int aEbene = this.Ebene[e1][e2][e3];
                                String aPunkt = this.Punkt[e1][e2][e3];
                                String aTitel = this.Titel[e1][e2][e3];
                                Name[0] = this.Punkt[e1][0][0];
                                Name[1] = String.valueOf(Name[0]) + "/" + this.Punkt[e1][e2][0];
                                Name[2] = String.valueOf(Name[1]) + "/" + aPunkt;
                                i = 0;
                                while (i < aEbene) {
                                    Dir = new File(this.getVerzeichnis(), Name[i]);
                                    if (!Dir.exists()) {
                                        fProt.prot("Verzeichnis >" + Name[i] + "< nicht vorhanden!");
                                        Dir.mkdirs();
                                    } else {
                                        fProt.prot("Verzeichnis >" + Name[i] + "< vorhanden!", 3);
                                    }
                                    fProt.prot("Name [" + i + "]:" + Name[i], 2);
                                    ++i;
                                }
                                Menue = new File(String.valueOf(this.getVerzeichnis()) + "/" + Name[aEbene - 1] + "/" + this.getMenueName());
                                Daten = new File(String.valueOf(this.getVerzeichnis()) + "/" + Name[aEbene - 1] + "/" + this.getDatenName());
                                fProt.prot(String.valueOf(e1) + "." + e2 + "." + e3 + ". " + aEbene + " - " + aArt + " - " + Dir, 1);
                                fProt.prot("Menue: " + Menue, 4);
                                fProt.prot("Daten: " + Daten, 4);
                                SchreibenMenue = new BufferedWriter(new FileWriter(Menue));
                                this.schreibenKopf(SchreibenMenue, aTitel, aEbene, this.getArtMenue());
                                i = 1;
                                while (i < e1) {
                                    this.schreibenBaum(SchreibenMenue, this.Punkt[i][0][0], '+', aEbene, 1, this.Art[i][0][0]);
                                    ++i;
                                }
                                this.schreibenBaum(SchreibenMenue, this.Punkt[e1][0][0], '-', aEbene, 1, this.Art[e1][0][0]);
                                this.schreibenEbene1Expand(SchreibenMenue, Dir, Daten, e1, e2, e3);
                                i = e1 + 1;
                                while (i < this.getMax_1()) {
                                    this.schreibenBaum(SchreibenMenue, this.Punkt[i][0][0], '+', aEbene, 1, this.Art[i][0][0]);
                                    ++i;
                                }
                                this.schreibenFuss(SchreibenMenue, this.getArtMenue());
                                fProt.prot(Menue + " erstellt", 1);
                                SchreibenMenue.close();
                            }
                            ++e3;
                        }
                        ++e2;
                    }
                    ++e1;
                }
            }
            catch (IOException e) {
                fProt.prot("IO-Exception in main bei " + e.getMessage());
            }
        }
    }

    public void schreibenBaum(BufferedWriter MenueDatei, String EbeneName, char Symbol, int aEbene, int SpalteNr, char aArt) {
        FProt fProt = FProt.instance();
        int Colspan = aEbene + 1 - SpalteNr;
        String Fett = "";
        String EndeFett = "";
        String Aufsetzen = "";
        if (aEbene == 0) {
            Colspan = 1;
        }
        if (aEbene == SpalteNr) {
            Fett = "<strong>";
            EndeFett = "</strong>";
            Aufsetzen = " name=\"" + this.getAufsetzpunkt() + "\"";
        }
        String SymbolName = Symbol == '+' ? this.getPlusName() : this.getMinusName();
        try {
            MenueDatei.write("    <tr>" + this.getSpalte()[SpalteNr - 1]);
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("        <td width=\"" + this.getBreiteSteuerung() + "\">");
            MenueDatei.write(System.getProperty("line.separator"));
            if (Symbol == '+') {
                MenueDatei.write("            <a href=\"" + this.getRueckwaerts()[aEbene - SpalteNr + 1] + EbeneName + "/" + this.getMenueName() + "#" + this.getAufsetzpunkt() + "\" target=\"Menue\">");
            } else {
                MenueDatei.write("            <a href=\"" + this.getRueckwaerts()[aEbene - SpalteNr + 1] + this.getMenueName() + "\">");
            }
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("            <img src=\"" + this.getRueckwaerts()[aEbene] + SymbolName + "\" border=\"0\"</font></a>");
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("        </td>");
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("        <td colspan=\"" + Colspan + "\" width=\"" + (this.getBreiteSteuerung() * (3 - SpalteNr) + this.getBreiteText()) + "\">");
            MenueDatei.write(System.getProperty("line.separator"));
            if (Symbol == '+') {
                MenueDatei.write("            <a href=\"" + this.getRueckwaerts()[aEbene - SpalteNr + 1] + EbeneName + "/" + this.getMenueName() + "#" + this.getAufsetzpunkt() + "\" target=\"Menue\">");
                MenueDatei.write(System.getProperty("line.separator"));
                MenueDatei.write("            <font size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">" + EbeneName + "</font></a>");
            } else if (aEbene == SpalteNr && (aArt == this.getArtBilder() || aArt == this.getArtVerweis())) {
                MenueDatei.write("            <a href=\"" + this.getDatenName() + "\" target=\"Daten\">");
                MenueDatei.write(System.getProperty("line.separator"));
                MenueDatei.write("            <font size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">" + Fett + EbeneName + EndeFett + "</font></a>");
            } else {
                MenueDatei.write("            <a" + Aufsetzen + "><font size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">");
                MenueDatei.write(System.getProperty("line.separator"));
                MenueDatei.write("            <u>" + Fett + EbeneName + EndeFett + "<u></font></a>");
            }
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("        </td>");
            MenueDatei.write(System.getProperty("line.separator"));
            MenueDatei.write("    </tr>");
            MenueDatei.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            fProt.prot("IO-Exception in schreibenBaum bei " + e.getMessage());
        }
    }

    public void schreibenBlaetter(BufferedWriter MenueDatei, File Daten, String xTitel, String[] Liste2, char aArt, int SpalteNr, int aEbene) {
        FProt fProt = FProt.instance();
        String Name = null;
        String NameDia = null;
        String Verweis = null;
        String Ziel = null;
        BufferedWriter DatenDatei = null;
        Ziel = aArt == this.getArtSeiten() || aArt == this.getArtLink() || aArt == this.getArtBilder() || aArt == this.getArtVerweis() ? "Daten" : "Menue";
        try {
            if (aArt == this.getArtBilder() || aArt == this.getArtVerweis()) {
                DatenDatei = new BufferedWriter(new FileWriter(Daten));
                this.schreibenKopf(DatenDatei, xTitel, SpalteNr, this.getArtVerzeichnis());
            }
            if ((aArt == this.getArtBilder() || aArt == this.getArtVerweis()) && aEbene == SpalteNr) {
                MenueDatei.write("    <tr>" + this.getSpalte()[SpalteNr]);
                MenueDatei.write(System.getProperty("line.separator"));
                MenueDatei.write("        <td width=\"" + (this.getBreiteSteuerung() + this.getBreiteText()) + "\">");
                MenueDatei.write(System.getProperty("line.separator"));
            }
            int i = 0;
            while (i < Liste2.length) {
                fProt.prot("I:" + i + " Wert:" + Liste2[i], 3);
                if (aArt == this.getArtSeiten()) {
                    Verweis = Liste2[i];
                    Name = Liste2[i].substring(0, Liste2[i].lastIndexOf("."));
                } else if (aArt == this.getArtLink()) {
                    Verweis = Liste2[i];
                    String[] Teile = Liste2[i].trim().split("/");
                    fProt.prot("Aufteilung bei Link", 2);
                    fProt.prot(Teile, 2);
                    Name = Teile[Teile.length - 1];
                    Name = Name.substring(0, Name.length() - 4);
                    fProt.prot(Name, 2);
                } else {
                    if (aArt == this.getArtBilder() || aArt == this.getArtVerweis()) {
                        Verweis = Liste2[i];
                        Name = String.valueOf(Liste2[i].substring(0, Liste2[i].length() - 4)) + this.getSmallSuffix() + "." + this.getBilderExtent();
                        NameDia = String.valueOf(Liste2[i].substring(0, Liste2[i].length() - 4)) + this.getDiaSuffix() + "." + this.getBilderExtent();
                        break;
                    }
                    Verweis = String.valueOf(Liste2[i]) + "/" + this.getMenueName();
                    Name = Liste2[i];
                }
                if ((aArt == this.getArtBilder() || aArt == this.getArtVerweis()) && aEbene == SpalteNr) {
                    MenueDatei.write("            <a href=\"" + Verweis + "\" target=\"" + Ziel + "\">");
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("            <img src=\"" + Name + "\" border=\"0\"</a></a>");
                    if (DatenDatei != null) {
                        DatenDatei.write("<a href=\"" + Verweis + "\"><img src=\"" + NameDia + "\" border=\"0\"</a></a>");
                        DatenDatei.write(System.getProperty("line.separator"));
                    }
                } else {
                    MenueDatei.write("    <tr>" + this.getSpalte()[SpalteNr]);
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("        <td width=\"" + (this.getBreiteSteuerung() + this.getBreiteText()) + "\">");
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("            <a href=\"" + Verweis + "\" target=\"" + Ziel + "\">");
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("        <font size = \"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">" + Name + "</font></a>");
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("        </td>");
                    MenueDatei.write(System.getProperty("line.separator"));
                    MenueDatei.write("    </tr>");
                }
                MenueDatei.write(System.getProperty("line.separator"));
                ++i;
            }
            if ((aArt == this.getArtBilder() || aArt == this.getArtVerweis()) && DatenDatei != null) {
                this.schreibenFuss(DatenDatei, this.getArtVerzeichnis());
                DatenDatei.close();
                fProt.prot(Daten + " erstellt", 1);
            }
            if ((aArt == this.getArtBilder() || aArt == this.getArtVerweis()) && aEbene == SpalteNr) {
                MenueDatei.write("        </td>");
                MenueDatei.write(System.getProperty("line.separator"));
                MenueDatei.write("    </tr>");
                MenueDatei.write(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            fProt.prot("IO-Exception in schreibenBlaetter bei " + e.getMessage());
        }
    }

    public void schreibenEbene1Expand(BufferedWriter MenueDatei, File Dir, File Daten, int e1, int e2, int e3) {
        FProt fProt = FProt.instance();
        int Anzahl = 0;
        String[] Liste2 = null;
        if (this.Ebene[e1][e2][e3] > 1) {
            int i = 1;
            while (i < e2) {
                this.schreibenBaum(MenueDatei, this.Punkt[e1][i][0], '+', this.Ebene[e1][e2][e3], 2, this.Art[e1][e2][e3]);
                ++i;
            }
            this.schreibenBaum(MenueDatei, this.Punkt[e1][e2][0], '-', this.Ebene[e1][e2][e3], 2, this.Art[e1][e2][e3]);
            this.schreibenEbene2Expand(MenueDatei, Dir, Daten, e1, e2, e3);
            i = e2 + 1;
            while (i < this.getMax_2() && this.Art[e1][i][0] > '\u0000') {
                this.schreibenBaum(MenueDatei, this.Punkt[e1][i][0], '+', this.Ebene[e1][e2][e3], 2, this.Art[e1][e2][e3]);
                ++i;
            }
        } else {
            if (this.Art[e1][e2][e3] == this.getArtSeiten() || this.Art[e1][e2][e3] == this.getArtLink() || this.Art[e1][e2][e3] == this.getArtBilder() || this.Art[e1][e2][e3] == this.getArtVerweis()) {
                Liste2 = this.erstellenListe(Dir, this.Art[e1][e2][e3]);
            } else if (this.Art[e1][e2][e3] == this.getArtVerzeichnis()) {
                Anzahl = 0;
                int i = 1;
                while (i < this.getMax_2() && this.Art[e1][i][0] > '\u0000') {
                    ++Anzahl;
                    ++i;
                }
                Liste2 = new String[Anzahl];
                i = 1;
                while (i < this.getMax_2() && this.Art[e1][i][0] > '\u0000') {
                    Liste2[i - 1] = this.Punkt[e1][i][0];
                    ++i;
                }
            } else {
                fProt.prot("Fehler in schreibenEbene1Expand - Art >" + this.Art[e1][e2][e3] + "< hier nicht vorgesehen");
            }
            this.schreibenBlaetter(MenueDatei, Daten, this.Titel[e1][e2][e3], Liste2, this.Art[e1][e2][e3], 1, this.Ebene[e1][e2][e3]);
        }
    }

    public void schreibenEbene2Expand(BufferedWriter MenueDatei, File Dir, File Daten, int e1, int e2, int e3) {
        FProt fProt = FProt.instance();
        int Anzahl = 0;
        String[] Liste2 = null;
        if (this.Ebene[e1][e2][e3] > 2) {
            int i = 1;
            while (i < e3) {
                this.schreibenBaum(MenueDatei, this.Punkt[e1][e2][i], '+', this.Ebene[e1][e2][e3], 3, this.Art[e1][e2][e3]);
                ++i;
            }
            this.schreibenBaum(MenueDatei, this.Punkt[e1][e2][e3], '-', this.Ebene[e1][e2][e3], 3, this.Art[e1][e2][e3]);
            this.schreibenEbene3Expand(MenueDatei, Dir, Daten, e1, e2, e3);
            i = e3 + 1;
            while (i < this.getMax_3() && this.Art[e1][e2][i] > '\u0000') {
                this.schreibenBaum(MenueDatei, this.Punkt[e1][e2][i], '+', this.Ebene[e1][e2][e3], 3, this.Art[e1][e2][e3]);
                ++i;
            }
        } else {
            if (this.Art[e1][e2][e3] == this.getArtSeiten() || this.Art[e1][e2][e3] == this.getArtLink() || this.Art[e1][e2][e3] == this.getArtBilder() || this.Art[e1][e2][e3] == this.getArtVerweis()) {
                Liste2 = this.erstellenListe(Dir, this.Art[e1][e2][e3]);
            } else if (this.Art[e1][e2][e3] == this.getArtVerzeichnis()) {
                Anzahl = 0;
                int i = 1;
                while (i < this.getMax_3() && this.Art[e1][e2][i] > '\u0000') {
                    ++Anzahl;
                    ++i;
                }
                Liste2 = new String[Anzahl];
                i = 1;
                while (i < this.getMax_3() && this.Art[e1][e2][i] > '\u0000') {
                    Liste2[i - 1] = this.Punkt[e1][e2][i];
                    ++i;
                }
            } else {
                fProt.prot("Fehler in schreibenEbene2Expand - Art >" + this.Art[e1][e2][e3] + "< hier nicht vorgesehen");
            }
            this.schreibenBlaetter(MenueDatei, Daten, this.Titel[e1][e2][e3], Liste2, this.Art[e1][e2][e3], 2, this.Ebene[e1][e2][e3]);
        }
    }

    public void schreibenEbene3Expand(BufferedWriter MenueDatei, File Dir, File Daten, int e1, int e2, int e3) {
        FProt fProt = FProt.instance();
        String[] Liste2 = null;
        if (this.Art[e1][e2][e3] == this.getArtSeiten() || this.Art[e1][e2][e3] == this.getArtLink() || this.Art[e1][e2][e3] == this.getArtBilder() || this.Art[e1][e2][e3] == this.getArtVerweis()) {
            Liste2 = this.erstellenListe(Dir, this.Art[e1][e2][e3]);
        } else {
            fProt.prot("Fehler in schreibenEbene2Expand - Art >" + this.Art[e1][e2][e3] + "< hier nicht vorgesehen");
        }
        this.schreibenBlaetter(MenueDatei, Daten, this.Titel[e1][e2][e3], Liste2, this.Art[e1][e2][e3], 3, this.Ebene[e1][e2][e3]);
    }

    public void schreibenFuss(BufferedWriter HtmlDatei, char aArt) {
        FProt fProt = FProt.instance();
        try {
            if (aArt == this.getArtMenue()) {
                HtmlDatei.write("</table>");
            } else {
                HtmlDatei.write("</p>");
            }
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</body>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</html>");
            HtmlDatei.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            fProt.prot("IO-Exception in schreibenFuss bei " + e.getMessage());
        }
    }

    public void schreibenKopf(BufferedWriter HtmlDatei, String xTitel, int xEbene, char aArt) {
        FProt fProt = FProt.instance();
        try {
            HtmlDatei.write("<html>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<head>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<meta http-equiv=\"Content-Type\"");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("content=\"text/html; charset=iso-8859-1\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<meta name=\"GENERATOR\" content=\"Java-Applikation java by J.Fischer\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("<title>Homepage von Gerlinde und Johann Fischer - " + xTitel + "</title>");
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("</head>");
            HtmlDatei.write(System.getProperty("line.separator"));
            if (this.isAlsHomepage() && xEbene == 0) {
                HtmlDatei.write("<body background=\"" + this.getRueckwaerts()[xEbene] + this.getHintergrundName() + "\"");
            } else {
                HtmlDatei.write("<body background=\"" + this.getRueckwaerts()[xEbene] + this.getHintergrundName() + "\"");
            }
            HtmlDatei.write(System.getProperty("line.separator"));
            HtmlDatei.write("      bgcolor=\"#FFFFFF\" link=\"#000000\" vlink=\"#000000\" alink=\"#000000\">");
            HtmlDatei.write(System.getProperty("line.separator"));
            if (aArt == this.getArtMenue()) {
                HtmlDatei.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
                HtmlDatei.write(System.getProperty("line.separator"));
                HtmlDatei.write("    <tr>");
                HtmlDatei.write(System.getProperty("line.separator"));
                if (xEbene == 0) {
                    HtmlDatei.write("        <td colspan=\"2\" width=\"" + (this.getBreiteSteuerung() * 3 + this.getBreiteText()) + " \">");
                    HtmlDatei.write(System.getProperty("line.separator"));
                    HtmlDatei.write("            <a><font color=\"#000000\" size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">");
                    HtmlDatei.write(System.getProperty("line.separator"));
                    HtmlDatei.write("            <strong><u>Home</u></strong></font></a>");
                } else {
                    HtmlDatei.write("        <td colspan=\"" + (xEbene + 1) + "\" width=\"" + (this.getBreiteSteuerung() * xEbene + this.getBreiteText()) + " \">");
                    HtmlDatei.write(System.getProperty("line.separator"));
                    HtmlDatei.write("            <a href=\"" + this.getRueckwaerts()[xEbene] + this.getIndexName() + "\" target=\"_top\">");
                    HtmlDatei.write(System.getProperty("line.separator"));
                    HtmlDatei.write("            <font size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\">Home</font></a>");
                }
                HtmlDatei.write(System.getProperty("line.separator"));
                HtmlDatei.write("       </td>");
            } else {
                HtmlDatei.write("            <p align=\"center\"><font size=\"" + this.getSchriftgroesse() + "\" face=\"" + this.getSchriftart() + "\"><strong>" + xTitel + "</strong></font></p>");
                HtmlDatei.write(System.getProperty("line.separator"));
                HtmlDatei.write("<p>");
            }
            HtmlDatei.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            fProt.prot("IO-Exception in schreibenKopf bei " + e.getMessage());
        }
    }

    public void setAlsHomepage() {
        this.AlsHomepage = FParam.getBooleanParameter("AlsHomepage", this.ArgTab);
    }

    public void setAlsHomepage(boolean alsHomepage) {
        this.AlsHomepage = alsHomepage;
    }

    public void setBreite() {
        this.Breite = FParam.getIntParameter("Breite", this.ArgTab);
    }

    public void setBreite(int breite) {
        FParam.instance();
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setBreite(String breite) {
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setBreiteBilder() {
        this.BreiteBilder = FParam.getIntParameter("BreiteBilder", this.ArgTab);
    }

    public void setBreiteBilder(int breiteBilder) {
        this.BreiteBilder = FParam.checkIntParameter("BreiteBilder", breiteBilder, this.ArgTab);
    }

    public void setBreiteBilder(String breiteBilder) {
        this.BreiteBilder = FParam.checkIntParameter("BreiteBilder", breiteBilder, this.ArgTab);
    }

    public void setBreiteText() {
        this.BreiteText = FParam.getIntParameter("BreiteText", this.ArgTab);
    }

    public void setBreiteText(int breiteText) {
        this.BreiteText = FParam.checkIntParameter("BreiteText", breiteText, this.ArgTab);
    }

    public void setBreiteText(String breiteText) {
        this.BreiteText = FParam.checkIntParameter("BreiteText", breiteText, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setDiaBreite() {
        this.DiaBreite = FParam.getIntParameter("DiaBreite", this.ArgTab);
    }

    public void setDiaBreite(int diaBreite) {
        FParam.instance();
        this.DiaBreite = FParam.checkIntParameter("DiaBreite", diaBreite, this.ArgTab);
    }

    public void setDiaBreite(String diaBreite) {
        this.DiaBreite = FParam.checkIntParameter("DiaBreite", diaBreite, this.ArgTab);
    }

    public void setDiaHoehe() {
        this.DiaHoehe = FParam.getIntParameter("DiaHoehe", this.ArgTab);
    }

    public void setDiaHoehe(int diaHoehe) {
        FParam.instance();
        this.DiaHoehe = FParam.checkIntParameter("DiaHoehe", diaHoehe, this.ArgTab);
    }

    public void setDiaHoehe(String diaHoehe) {
        this.DiaHoehe = FParam.checkIntParameter("DiaHoehe", diaHoehe, this.ArgTab);
    }

    public void setHoehe() {
        this.Hoehe = FParam.getIntParameter("Hoehe", this.ArgTab);
    }

    public void setHoehe(int hoehe) {
        FParam.instance();
        this.Hoehe = FParam.checkIntParameter("Hoehe", hoehe, this.ArgTab);
    }

    public void setHoehe(String hoehe) {
        this.Hoehe = FParam.checkIntParameter("Hoehe", hoehe, this.ArgTab);
    }

    public void setIndexBreite() {
        this.IndexBreite = FParam.getIntParameter("IndexBreite", this.ArgTab);
    }

    public void setIndexBreite(int indexBreite) {
        FParam.instance();
        this.IndexBreite = FParam.checkIntParameter("IndexBreite", indexBreite, this.ArgTab);
    }

    public void setIndexBreite(String indexBreite) {
        this.IndexBreite = FParam.checkIntParameter("IndexBreite", indexBreite, this.ArgTab);
    }

    public void setIndexHoehe() {
        this.IndexHoehe = FParam.getIntParameter("IndexHoehe", this.ArgTab);
    }

    public void setIndexHoehe(int indexHoehe) {
        FParam.instance();
        this.IndexHoehe = FParam.checkIntParameter("IndexHoehe", indexHoehe, this.ArgTab);
    }

    public void setIndexHoehe(String indexHoehe) {
        this.IndexHoehe = FParam.checkIntParameter("IndexHoehe", indexHoehe, this.ArgTab);
    }

    public void setKeinBackupOriginalbild() {
        this.KeinBackupOriginalbild = FParam.getBooleanParameter("KeinBackupOriginalbild", this.ArgTab);
    }

    public void setKeinBackupOriginalbild(boolean keinBackupOriginalbild) {
        this.KeinBackupOriginalbild = keinBackupOriginalbild;
    }

    public void setMax_1(int max_1) {
        this.Max_1 = max_1;
    }

    public void setMax_2(int max_2) {
        this.Max_2 = max_2;
    }

    public void setMax_3(int max_3) {
        this.Max_3 = max_3;
    }

    public void setNameVerweisDateien() {
        this.NameVerweisDateien = FParam.getStringParameter("NameVerweisDateien", this.ArgTab);
    }

    public void setNameVerweisDateien(String nameVerweisDateien) {
        FParam.instance();
        this.NameVerweisDateien = FParam.checkStringParameter("NameVerweisDateien", nameVerweisDateien, this.ArgTab);
    }

    public void setNeueDias() {
        this.NeueDias = FParam.getBooleanParameter("NeueDias", this.ArgTab);
    }

    public void setNeueDias(boolean neueDias) {
        this.NeueDias = neueDias;
    }

    public void setNeueIndexbilder() {
        this.NeueIndexbilder = FParam.getBooleanParameter("NeueIndexbilder", this.ArgTab);
    }

    public void setNeueIndexbilder(boolean neueIndexbilder) {
        this.NeueIndexbilder = neueIndexbilder;
    }

    public void setProzentRahmen() {
        this.ProzentRahmen = FParam.getIntParameter("ProzentRahmen", this.ArgTab);
    }

    public void setProzentRahmen(int prozentRahmen) {
        FParam.instance();
        this.ProzentRahmen = FParam.checkIntParameter("ProzentRahmen", prozentRahmen, this.ArgTab);
    }

    public void setProzentRahmen(String prozentRahmen) {
        this.ProzentRahmen = FParam.checkIntParameter("ProzentRahmen", prozentRahmen, this.ArgTab);
    }

    public void setPruefenBildgroesse() {
        this.PruefenBildgroesse = FParam.getBooleanParameter("PruefenBildgroesse", this.ArgTab);
    }

    public void setPruefenBildgroesse(boolean pruefenBildgroesse) {
        this.PruefenBildgroesse = pruefenBildgroesse;
    }

    public void setSchriftart() {
        this.Schriftart = FParam.getStringParameter("Schriftart", this.ArgTab);
    }

    public void setSchriftart(String schriftart) {
        FParam.instance();
        this.Schriftart = FParam.checkStringParameter("Schriftart", schriftart, this.ArgTab);
    }

    public void setSchriftgroesse() {
        this.Schriftgroesse = FParam.getIntParameter("Schriftgroesse", this.ArgTab);
    }

    public void setSchriftgroesse(int schriftgroesse) {
        FParam.instance();
        this.Schriftgroesse = FParam.checkIntParameter("Schriftgroesse", schriftgroesse, this.ArgTab);
    }

    public void setSchriftgroesse(String schriftgroesse) {
        this.Schriftgroesse = FParam.checkIntParameter("Schriftgroesse", schriftgroesse, this.ArgTab);
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setDatei();
        this.setNameVerweisDateien();
        this.setPruefenBildgroesse();
        this.setAlsHomepage();
        this.setKeinBackupOriginalbild();
        this.setNeueDias();
        this.setNeueIndexbilder();
        this.setSchriftart();
        this.setSchriftgroesse();
        this.setBreiteBilder();
        this.setBreiteText();
        this.setHoehe();
        this.setDiaBreite();
        this.setDiaHoehe();
        this.setProzentRahmen();
        this.setIndexBreite();
        this.setIndexHoehe();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Verzeichnis                    :" + this.getVerzeichnis());
        fProt.prot("Datei mit Strukturinformationen:" + this.getDatei());
        fProt.prot("Name der Verweisdateien        :" + this.getNameVerweisDateien());
        fProt.prot("Bilder neu skalieren           :" + this.isPruefenBildgroesse());
        fProt.prot("als Homepage generieren        :" + this.isAlsHomepage());
        fProt.prot("kein Backup fuer Bilder        :" + this.isKeinBackupOriginalbild());
        fProt.prot("Dias neu generieren            :" + this.isNeueDias());
        fProt.prot("Indexbilder neu generieren     :" + this.isNeueIndexbilder());
        fProt.prot("Schriftart                     :" + this.getSchriftart());
        fProt.prot("Schriftgroesse                 :" + this.getSchriftgroesse());
        fProt.prot("Breite der Bilder              :" + this.getBreiteBilder());
        fProt.prot("Breite des Textes              :" + this.getBreiteText());
        fProt.prot("Hoehe der Bilder               :" + this.getHoehe());
        fProt.prot("Breite der Dias                :" + this.getDiaBreite());
        fProt.prot("Hoehe der Dias                 :" + this.getDiaHoehe());
        fProt.prot("Prozent Diarahmen              :" + this.getProzentRahmen());
        fProt.prot("Breite der Indexbilder         :" + this.getIndexBreite());
        fProt.prot("Hoehe der Indexbilder          :" + this.getIndexHoehe());
    }
}

