/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FSystemProperties;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class GetProperties {
    private int Breite;
    private String Environmentvariable;
    private boolean Codepages;
    private boolean ShowEnvironment;
    private boolean Properties;
    private boolean LookAndFeels;
    private boolean Benutzerwerte;
    private boolean ShowFonts;
    private String Property;
    private final boolean SetzenWerteInGUInachRun = false;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "2.6.2009 8:18:04";

    public static void main(String[] args) {
        GetProperties getProperties = new GetProperties(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(getProperties.ArgTab, getProperties.ArgTabDefault, getProperties.getHilfeText())) {
            try {
                getProperties.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + getProperties.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                getProperties.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + getProperties.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + getProperties.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public GetProperties() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public GetProperties(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getBreite() {
        return this.Breite;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEnvironmentvariable() {
        return this.Environmentvariable;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getProperty() {
        return this.Property;
    }

    public String getStand() {
        return "2.6.2009 8:18:04";
    }

    public boolean isBenutzerwerte() {
        return this.Benutzerwerte;
    }

    public boolean isCodepages() {
        return this.Codepages;
    }

    public boolean isLookAndFeels() {
        return this.LookAndFeels;
    }

    public boolean isProperties() {
        return this.Properties;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isShowEnvironment() {
        return this.ShowEnvironment;
    }

    public boolean isShowFonts() {
        return this.ShowFonts;
    }

    public void run() {
        FProt fProt = FProt.instance();
        String wert = "";
        if (this.getProperty().length() > 0) {
            fProt.prot(String.valueOf(this.getProperty()) + " - " + FSystemProperties.holenSystemProperty(this.getProperty()));
        }
        if (this.getEnvironmentvariable().length() > 0) {
            fProt.prot(String.valueOf(this.getEnvironmentvariable()) + " - " + FSystemProperties.holenSystemEnvironmentvariable(this.getEnvironmentvariable()));
        }
        if (this.isProperties()) {
            fProt.prot("## Java System Properties");
            fProt.prot(FSystemProperties.holenSystemProperties(this.getBreite()), 0, false);
            FGregorianCalendar zeit = new FGregorianCalendar(2020, 0, 1, 12, 0, 0);
            fProt.prot("Zeitzone: " + zeit.getTimeZone().getDisplayName() + " : " + zeit.getTimeZone().getID());
            fProt.prot(String.valueOf(zeit.toGermanFormat()) + ", Zeit in Sekunden: " + zeit.getTimeInMillis() / 1000L + ", ZONE_OFFSET: " + zeit.get(15) / 3600000 + " DST_OFFSET: " + zeit.get(16) / 3600000);
            zeit.set(2020, 5, 1, 12, 0, 0);
            fProt.prot(String.valueOf(zeit.toGermanFormat()) + ", Zeit in Sekunden: " + zeit.getTimeInMillis() / 1000L + ", ZONE_OFFSET: " + zeit.get(15) / 3600000 + " DST_OFFSET: " + zeit.get(16) / 3600000);
        }
        if (this.isShowEnvironment()) {
            fProt.prot("## System ShowEnvironment");
            fProt.prot(FSystemProperties.holenSystemEnvironment(this.getBreite()), 0, false);
        }
        if (this.isLookAndFeels()) {
            fProt.prot("## LookAndFeels");
            fProt.prot(FSystemProperties.holenLookAndFeels(), 0, false);
        }
        if (this.isBenutzerwerte()) {
            fProt.prot("## Benutzerwerte");
            fProt.prot(Futi.getBenutzerWerteFormatiert(), 0, false);
            String[] regDB = FDB.getRegistrierteDBs(true);
            if (regDB.length > 0) {
                fProt.prot("## Registrierte Datendanken");
                fProt.prot(regDB, 0, false);
            }
        }
        if (this.isCodepages()) {
            fProt.prot("## Codepages");
            fProt.prot(Futi.getAllCodepages(), 0, false);
        }
        if (this.isShowFonts()) {
            fProt.prot("## Fonts");
            UIDefaults uidef = UIManager.getLookAndFeelDefaults();
            for (Map.Entry e : uidef.entrySet()) {
                Object val = e.getValue();
                if (val == null || !(val instanceof FontUIResource)) continue;
                wert = val.toString();
                int pos = wert.indexOf("[");
                if (pos > 0 && (pos = (wert = wert.substring(pos + 1)).indexOf("]")) > 0) {
                    wert = wert.substring(0, pos);
                }
                fProt.prot(wert);
            }
        }
    }

    public void setBenutzerwerte() {
        this.Benutzerwerte = FParam.getBooleanParameter("Benutzerwerte", this.ArgTab);
    }

    public void setBenutzerwerte(boolean benutzerwerte) {
        this.Benutzerwerte = benutzerwerte;
    }

    public void setBreite() {
        this.Breite = FParam.getIntParameter("Breite", this.ArgTab);
    }

    public void setBreite(int breite) {
        FParam.instance();
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setBreite(String breite) {
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setCodepages() {
        this.Codepages = FParam.getBooleanParameter("Codepages", this.ArgTab);
    }

    public void setCodepages(boolean codepages) {
        this.Codepages = codepages;
    }

    public void setEnvironmentvariable() {
        this.Environmentvariable = FParam.getStringParameter("Environmentvariable", this.ArgTab);
    }

    public void setEnvironmentvariable(String environmentvariable) {
        FParam.instance();
        this.Environmentvariable = FParam.checkStringParameter("Environmentvariable", environmentvariable, this.ArgTab);
    }

    public void setLookAndFeels() {
        this.LookAndFeels = FParam.getBooleanParameter("LookAndFeels", this.ArgTab);
    }

    public void setLookAndFeels(boolean lookAndFeels) {
        this.LookAndFeels = lookAndFeels;
    }

    public void setProperties() {
        this.Properties = FParam.getBooleanParameter("Properties", this.ArgTab);
    }

    public void setProperties(boolean properties) {
        this.Properties = properties;
    }

    public void setProperty() {
        this.Property = FParam.getStringParameter("Property", this.ArgTab);
    }

    public void setProperty(String property) {
        FParam.instance();
        this.Property = FParam.checkStringParameter("Property", property, this.ArgTab);
    }

    public void setShowEnvironment() {
        this.ShowEnvironment = FParam.getBooleanParameter("ShowEnvironment", this.ArgTab);
    }

    public void setShowEnvironment(boolean environment) {
        this.ShowEnvironment = environment;
    }

    public void setShowFonts() {
        this.ShowFonts = FParam.getBooleanParameter("ShowFonts", this.ArgTab);
    }

    public void setShowFonts(boolean showFonts) {
        this.ShowFonts = showFonts;
    }

    public void setWerteAusArgTab() {
        this.setBreite();
        this.setProperties();
        this.setShowEnvironment();
        this.setLookAndFeels();
        this.setBenutzerwerte();
        this.setShowFonts();
        this.setCodepages();
        this.setProperty();
        this.setEnvironmentvariable();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Breite der Anzeige           :" + this.getBreite());
        fProt.prot("Properties anzeigen          :" + this.isProperties());
        fProt.prot("Environmentvariablen anzeigen:" + this.isShowEnvironment());
        fProt.prot("LookAndFeels anzeigen        :" + this.isLookAndFeels());
        fProt.prot("Benutzerwerte anzeigen       :" + this.isBenutzerwerte());
        fProt.prot("Fonts anzeigen               :" + this.isShowFonts());
        fProt.prot("Codepages                    :" + this.isCodepages());
        fProt.prot("Property                     :" + this.getProperty());
        fProt.prot("Environmentvariable          :" + this.getEnvironmentvariable());
    }
}

