/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FTouch {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Datei;
    private int AddSekunden;
    private int AddMillisekunden;
    private String Liste;
    private int AddMinuten;
    private int RandomMinuten;
    private boolean MitUnterverzeichnissen;
    private String Tag;
    private String Zeit;
    private final boolean SetzenWerteInGUInachRun = false;
    private final String Stand = "28.5.2009 8:12:30";

    public static void main(String[] args) {
        FTouch fTouch = new FTouch(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fTouch.ArgTab, fTouch.ArgTabDefault, fTouch.getHilfeText())) {
            try {
                fTouch.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fTouch.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fTouch.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fTouch.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fTouch.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public FTouch() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FTouch(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getAddMillisekunden() {
        return this.AddMillisekunden;
    }

    public int getAddMinuten() {
        return this.AddMinuten;
    }

    public int getAddSekunden() {
        return this.AddSekunden;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getListe() {
        return this.Liste;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public int getRandomMinuten() {
        return this.RandomMinuten;
    }

    public String getStand() {
        return "28.5.2009 8:12:30";
    }

    public String getTag() {
        return this.Tag;
    }

    public String getZeit() {
        return this.Zeit;
    }

    public boolean isMitUnterverzeichnissen() {
        return this.MitUnterverzeichnissen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        FFile dat;
        FProt fProt = FProt.instance();
        Integer RandomSekundenInteger = new Integer(this.getRandomMinuten() * 60);
        String[] Dateien = new String[]{this.getDatei()};
        String Pfad = "";
        FGregorianCalendar LModneu = new FGregorianCalendar();
        FGregorianCalendar LModalt = new FGregorianCalendar();
        FGregorianCalendar LModfest = new FGregorianCalendar();
        Date Datum = null;
        int Funktion = 78;
        if (this.getAddMinuten() != 0) {
            Funktion = 65;
        }
        if (this.getRandomMinuten() > 0) {
            Funktion = 82;
        }
        if (Funktion == 78) {
            SimpleDateFormat formatTag = new SimpleDateFormat("d.M.y H:m:s");
            try {
                Datum = ((DateFormat)formatTag).parse(String.valueOf(this.getTag()) + " " + this.getZeit(), new ParsePosition(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Datum == null) {
                try {
                    Datum = ((DateFormat)formatTag).parse(String.valueOf(this.getTag()) + " 00:00:01", new ParsePosition(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Datum == null) {
                fProt.prot("Datum <" + this.getTag() + " " + this.getZeit() + "> fehlerhaft");
                Funktion = 75;
            } else {
                LModfest.setTime(Datum, true);
                if (LModfest.get(1) < 1970) {
                    LModfest.set(1, 1970);
                }
                if (LModfest.get(1) > 2100) {
                    LModfest.set(1, 2100);
                }
            }
        }
        if (this.getListe().length() > 0) {
            dat = new FFile(this.getListe());
            Dateien = dat.inhaltToStringArray();
        } else {
            dat = new FFile(this.getDatei());
            if (dat.isDirectory()) {
                Dateien = dat.listFileNames('D', this.isMitUnterverzeichnissen());
                Pfad = FDatei.checkFileSeperator(this.getDatei(), true);
            }
        }
        int i = 0;
        while (i < Dateien.length) {
            fProt.prot(Dateien[i], 5);
            dat = new FFile(String.valueOf(Pfad) + Dateien[i]);
            LModalt.setTime(dat.lastModified());
            switch (Funktion) {
                case 65: {
                    LModneu.setTime(dat.lastModified());
                    LModneu.add(12, this.getAddMinuten());
                    break;
                }
                case 82: {
                    LModneu.setTimeInMillis(LModfest.getTimeInMillis());
                    LModneu.add(13, (int)((2.0 * Math.random() - 1.0) * RandomSekundenInteger.doubleValue()));
                    break;
                }
                case 78: {
                    LModneu.setTimeInMillis(LModfest.getTimeInMillis());
                    break;
                }
            }
            if (Funktion != 75 && dat.setLastModified(LModneu.getTimeInMillis())) {
                fProt.prot(String.valueOf(Pfad) + Dateien[i] + "\t: " + LModalt.toGermanFormat() + " -> " + LModneu.toGermanFormat());
            }
            ++i;
        }
    }

    public void setAddMillisekunden() {
        this.AddMillisekunden = FParam.getIntParameter("AddMillisekunden", this.ArgTab);
    }

    public void setAddMillisekunden(int addMillisekunden) {
        this.AddMillisekunden = FParam.checkIntParameter("AddMillisekunden", addMillisekunden, this.ArgTab);
    }

    public void setAddMillisekunden(String addMillisekunden) {
        this.AddMillisekunden = FParam.checkIntParameter("AddMillisekunden", addMillisekunden, this.ArgTab);
    }

    public void setAddMinuten() {
        this.AddMinuten = FParam.getIntParameter("AddMinuten", this.ArgTab);
    }

    public void setAddMinuten(int addMinuten) {
        FParam.instance();
        this.AddMinuten = FParam.checkIntParameter("AddMinuten", addMinuten, this.ArgTab);
    }

    public void setAddMinuten(String addMinuten) {
        this.AddMinuten = FParam.checkIntParameter("AddMinuten", addMinuten, this.ArgTab);
    }

    public void setAddSekunden() {
        this.AddSekunden = FParam.getIntParameter("AddSekunden", this.ArgTab);
    }

    public void setAddSekunden(int addSekunden) {
        this.AddSekunden = FParam.checkIntParameter("AddSekunden", addSekunden, this.ArgTab);
    }

    public void setAddSekunden(String addSekunden) {
        this.AddSekunden = FParam.checkIntParameter("AddSekunden", addSekunden, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setListe() {
        this.Liste = FParam.getStringParameter("Liste", this.ArgTab);
    }

    public void setListe(String liste) {
        FParam.instance();
        this.Liste = FParam.checkStringParameter("Liste", liste, this.ArgTab);
    }

    public void setMitUnterverzeichnissen() {
        this.MitUnterverzeichnissen = FParam.getBooleanParameter("MitUnterverzeichnissen", this.ArgTab);
    }

    public void setMitUnterverzeichnissen(boolean mitUnterverzeichnissen) {
        this.MitUnterverzeichnissen = mitUnterverzeichnissen;
    }

    public void setRandomMinuten() {
        this.RandomMinuten = FParam.getIntParameter("RandomMinuten", this.ArgTab);
    }

    public void setRandomMinuten(int randomMinuten) {
        FParam.instance();
        this.RandomMinuten = FParam.checkIntParameter("RandomMinuten", randomMinuten, this.ArgTab);
    }

    public void setRandomMinuten(String randomMinuten) {
        this.RandomMinuten = FParam.checkIntParameter("RandomMinuten", randomMinuten, this.ArgTab);
    }

    public void setTag() {
        this.Tag = FParam.getDateParameter("Tag", this.ArgTab);
    }

    public void setTag(String tag) {
        FParam.instance();
        this.Tag = FParam.checkDateParameter("Tag", tag, this.ArgTab);
    }

    public void setTag(String tag, boolean umsetzen) {
        FParam.instance();
        this.Tag = FParam.checkDateParameter("Tag", tag, umsetzen, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setDatei();
        this.setListe();
        this.setAddMinuten();
        this.setAddSekunden();
        this.setAddMillisekunden();
        this.setRandomMinuten();
        this.setTag();
        this.setZeit();
        this.setMitUnterverzeichnissen();
    }

    public void setZeit() {
        this.Zeit = FParam.getTimeParameter("Zeit", this.ArgTab);
    }

    public void setZeit(String zeit) {
        FParam.instance();
        this.Zeit = FParam.checkTimeParameter("Zeit", zeit, this.ArgTab);
    }

    public void setZeit(String zeit, boolean umsetzen) {
        FParam.instance();
        this.Zeit = FParam.checkTimeParameter("Zeit", zeit, umsetzen, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Basis: Datei oder Verzeichnis, bei Verz. alle Dateien des Verz.:" + this.getDatei());
        fProt.prot("Liste von Dateien, hat hoehere Prioritaet als /B               :" + this.getListe());
        fProt.prot("Minuten, um die das Last Modified erhoeht wird                 :" + this.getAddMinuten());
        fProt.prot("Sekunden, um die das Last Modified erhoeht wird                :" + this.getAddSekunden());
        fProt.prot("Millisekunden, um die das Last Modified erhoeht wird           :" + this.getAddMillisekunden());
        fProt.prot("+/-Minuten, innerhalb dessen das Last Modified streut          :" + this.getRandomMinuten());
        fProt.prot("Tag, wird ignoriert bei /R                                     :" + this.getTag());
        fProt.prot("Zeit, wird ignoriert bei /R                                    :" + this.getZeit());
        fProt.prot("mit Unterverzeichnissen, nur relevant, falls Basis Verzeichnis :" + this.isMitUnterverzeichnissen());
    }
}

