/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class FDate {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Datei;
    private int VonJahr;
    private boolean KeineFeiertage;
    private boolean AnzahlBrueckentage;
    private int BisJahr;
    private String SonnenaufUnduntergang;
    private final boolean SetzenWerteInGUInachRun = true;
    private String Ort;
    private double KoordBreite;
    private double KoordLaenge;
    private final String Stand = "27.1.2010";
    private int VonMonat;
    private boolean AnzahlFeiertage;
    private int BisMonat;

    public static void main(String[] args) {
        FDate fDate = new FDate(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fDate.ArgTab, fDate.ArgTabDefault, fDate.getHilfeText())) {
            try {
                fDate.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fDate.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fDate.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fDate.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fDate.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public FDate() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FDate(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public void checkWerte() {
        FProt fProt = FProt.instance();
        if (this.getBisJahr() < this.getVonJahr()) {
            fProt.prot("Endejahr von >" + this.getBisJahr() + "< auf >" + this.getVonJahr() + "< gesetzt");
            this.setBisJahr(this.getVonJahr());
        }
        if (this.getBisMonat() < this.getVonMonat()) {
            fProt.prot("Endejahr von >" + this.getBisMonat() + "< auf >" + this.getVonMonat() + "< gesetzt");
            this.setBisMonat(this.getVonMonat());
        }
    }

    public int getBisJahr() {
        return this.BisJahr;
    }

    public int getBisMonat() {
        return this.BisMonat;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public double getKoordBreite() {
        return this.KoordBreite;
    }

    public double[] getKoordinaten(String ort) {
        Futi.instance();
        FProt fProt = FProt.instance();
        double[] coord = null;
        String[][] Orte = FString.convertStringArrayToTabelle(Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".Orte"), 3, true);
        int pos = FString.findFirstString(FString.convertTabelleToStringArray(Orte), ort, true);
        if (pos < 0 || Orte[pos][0].compareToIgnoreCase("KeinOrt") == 0) {
            fProt.prot("Ort >" + ort + "< nicht gefunden");
        } else {
            try {
                coord = new double[]{Double.parseDouble(Orte[pos][1]), Double.parseDouble(Orte[pos][2])};
            }
            catch (NumberFormatException e) {
                System.err.println("Fehler bei Koordinaten von Ort Ort >" + ort + "< in " + this.getClass().toString());
                e.printStackTrace();
            }
        }
        return coord;
    }

    public double getKoordLaenge() {
        return this.KoordLaenge;
    }

    public String getOrt() {
        return this.Ort;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getSonnenaufUnduntergang() {
        return this.SonnenaufUnduntergang;
    }

    public String getStand() {
        return "27.1.2010";
    }

    public int getVonJahr() {
        return this.VonJahr;
    }

    public int getVonMonat() {
        return this.VonMonat;
    }

    public boolean isAnzahlBrueckentage() {
        return this.AnzahlBrueckentage;
    }

    public boolean isAnzahlFeiertage() {
        return this.AnzahlFeiertage;
    }

    public boolean isKeineFeiertage() {
        return this.KeineFeiertage;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FGregorianCalendar Kal = new FGregorianCalendar();
        char Art = this.getSonnenaufUnduntergang().charAt(0);
        int anzahlFeiertageAnWerktagen = 0;
        this.checkWerte();
        double[] coord = this.getKoordinaten(this.getOrt());
        if (coord == null) {
            coord = new double[]{this.getKoordBreite(), this.getKoordLaenge()};
        }
        this.setKoordBreite(coord[0]);
        this.setKoordLaenge(coord[1]);
        if (Art != 'K') {
            fProt.prot("Koordinaten zur Berechnung der Sonnenauf- und/oder untergaenge: Breite: " + coord[0] + ", Laenge: " + coord[1], 0);
        }
        Kal.set(this.getVonJahr(), 0, 1);
        if (this.getDatei().length() > 0) {
            if (Art == 'K') {
                Kal.setZusatz(this.getDatei(), this.getVonJahr(), this.getBisJahr(), true);
            } else {
                Kal.setZusatz(this.getDatei(), this.getVonJahr(), this.getBisJahr(), true, true, coord[0], coord[1], Art);
            }
        }
        int lastYear = Kal.get(1);
        while (Kal.get(1) <= this.getBisJahr()) {
            if (Kal.get(2) + 1 >= this.getVonMonat() && Kal.get(2) + 1 <= this.getBisMonat() && Kal.hasZusatz()) {
                fProt.prot(String.valueOf(Kal.toGermanFormat('K')) + ";" + Kal.getZusatz());
                if (this.isAnzahlFeiertage() && Kal.istArbeitsfrei() && Kal.get(7) > 1 && Kal.get(7) < 7) {
                    fProt.prot(String.valueOf(Kal.toGermanFormat('K')) + ";" + Kal.getZusatz() + " -> Feiertag an Werktag -> " + Kal.getWochentag(), 1);
                    ++anzahlFeiertageAnWerktagen;
                }
            }
            Kal.add(6, 1);
            if (!this.isAnzahlFeiertage() || Kal.get(1) == lastYear) continue;
            fProt.prot("Anzahl Feiertagen an Werktagen: " + lastYear + ", \t" + anzahlFeiertageAnWerktagen);
            anzahlFeiertageAnWerktagen = 0;
            lastYear = Kal.get(1);
        }
        if (this.isAnzahlFeiertage() && anzahlFeiertageAnWerktagen > 0) {
            fProt.prot("Anzahl Feiertagen an Werktagen: " + lastYear + ", \t" + anzahlFeiertageAnWerktagen);
        }
    }

    public void setAnzahlBrueckentage() {
        this.AnzahlBrueckentage = FParam.getBooleanParameter("AnzahlBrueckentage", this.ArgTab);
    }

    public void setAnzahlBrueckentage(boolean anzahlBrueckentage) {
        this.AnzahlBrueckentage = anzahlBrueckentage;
    }

    public void setAnzahlFeiertage() {
        this.AnzahlFeiertage = FParam.getBooleanParameter("AnzahlFeiertage", this.ArgTab);
    }

    public void setAnzahlFeiertage(boolean anzahlFeiertage) {
        this.AnzahlFeiertage = anzahlFeiertage;
    }

    public void setBisJahr() {
        this.BisJahr = FParam.getIntParameter("BisJahr", this.ArgTab);
    }

    public void setBisJahr(int bisJahr) {
        FParam.instance();
        this.BisJahr = FParam.checkIntParameter("BisJahr", bisJahr, this.ArgTab);
    }

    public void setBisJahr(String bisJahr) {
        this.BisJahr = FParam.checkIntParameter("BisJahr", bisJahr, this.ArgTab);
    }

    public void setBisMonat() {
        this.BisMonat = FParam.getIntParameter("BisMonat", this.ArgTab);
    }

    public void setBisMonat(int bisMonat) {
        FParam.instance();
        this.BisMonat = FParam.checkIntParameter("BisMonat", bisMonat, this.ArgTab);
    }

    public void setBisMonat(String bisMonat) {
        this.BisMonat = FParam.checkIntParameter("BisMonat", bisMonat, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setKeineFeiertage() {
        this.KeineFeiertage = FParam.getBooleanParameter("KeineFeiertage", this.ArgTab);
    }

    public void setKeineFeiertage(boolean keineFeiertage) {
        this.KeineFeiertage = keineFeiertage;
    }

    public void setKoordBreite() {
        this.KoordBreite = FParam.getDoubleParameter("KoordBreite", this.ArgTab);
    }

    public void setKoordBreite(double koordBreite) {
        FParam.instance();
        this.KoordBreite = FParam.checkDoubleParameter("KoordBreite", koordBreite, this.ArgTab);
    }

    public void setKoordBreite(String koordBreite) {
        this.KoordBreite = FParam.checkDoubleParameter("KoordBreite", koordBreite, this.ArgTab);
    }

    public void setKoordLaenge() {
        this.KoordLaenge = FParam.getDoubleParameter("KoordLaenge", this.ArgTab);
    }

    public void setKoordLaenge(double koordLaenge) {
        FParam.instance();
        this.KoordLaenge = FParam.checkDoubleParameter("KoordLaenge", koordLaenge, this.ArgTab);
    }

    public void setKoordLaenge(String koordLaenge) {
        this.KoordLaenge = FParam.checkDoubleParameter("KoordLaenge", koordLaenge, this.ArgTab);
    }

    public void setOrt() {
        this.Ort = FParam.getStringParameter("Ort", this.ArgTab);
    }

    public void setOrt(String ort) {
        FParam.instance();
        this.Ort = FParam.checkStringParameter("Ort", ort, this.ArgTab);
    }

    public void setSonnenaufUnduntergang() {
        this.SonnenaufUnduntergang = FParam.getStringParameter("SonnenaufUnduntergang", this.ArgTab);
    }

    public void setSonnenaufUnduntergang(String sonnenaufUnduntergang) {
        FParam.instance();
        this.SonnenaufUnduntergang = FParam.checkStringParameter("SonnenaufUnduntergang", sonnenaufUnduntergang, this.ArgTab);
    }

    public void setVonJahr() {
        this.VonJahr = FParam.getIntParameter("VonJahr", this.ArgTab);
    }

    public void setVonJahr(int vonJahr) {
        FParam.instance();
        this.VonJahr = FParam.checkIntParameter("VonJahr", vonJahr, this.ArgTab);
    }

    public void setVonJahr(String vonJahr) {
        this.VonJahr = FParam.checkIntParameter("VonJahr", vonJahr, this.ArgTab);
    }

    public void setVonMonat() {
        this.VonMonat = FParam.getIntParameter("VonMonat", this.ArgTab);
    }

    public void setVonMonat(int vonMonat) {
        FParam.instance();
        this.VonMonat = FParam.checkIntParameter("VonMonat", vonMonat, this.ArgTab);
    }

    public void setVonMonat(String vonMonat) {
        this.VonMonat = FParam.checkIntParameter("VonMonat", vonMonat, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setDatei();
        this.setVonJahr();
        this.setBisJahr();
        this.setVonMonat();
        this.setBisMonat();
        this.setSonnenaufUnduntergang();
        this.setOrt();
        this.setKoordBreite();
        this.setKoordLaenge();
        this.setAnzahlFeiertage();
        this.setKeineFeiertage();
        this.setAnzahlBrueckentage();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei                                     :" + this.getDatei());
        fProt.prot("von Jahr                                         :" + this.getVonJahr());
        fProt.prot("(Ende) bis Jahr                                  :" + this.getBisJahr());
        fProt.prot("von Monat                                        :" + this.getVonMonat());
        fProt.prot("bis Monat                                        :" + this.getBisMonat());
        fProt.prot("Sonnenauf- und untergaenge anzeigen              :" + this.getSonnenaufUnduntergang());
        fProt.prot("Ort zur Berechnung der Sonnenauf- und untergaenge:" + this.getOrt());
        fProt.prot("Breitengrad, falls kein Ort angegeben            :" + this.getKoordBreite());
        fProt.prot("Laengengrad, falls kein Ort angegeben            :" + this.getKoordLaenge());
        fProt.prot("Anzahl Feiertage an Arbeitstagen ausgeben        :" + this.isAnzahlFeiertage());
        fProt.prot("Anzahl Feiertage nicht ausgeben                  :" + this.isKeineFeiertage());
        fProt.prot("Anzahl Brueckentage ausgeben                     :" + this.isAnzahlBrueckentage());
    }
}

