/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FCommand {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Befehl;
    private boolean BroadcastMessage;
    private String Parameter;
    private int MinStunden;
    private String Vorgang;
    private int MinTage;
    private int MinWochen;
    private int MinMonate;
    private final boolean SetzenWerteInGUInachRun = true;
    private final String Stand = "30.11.2009";

    public static void main(String[] args) {
        FCommand fCommand = new FCommand(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fCommand.ArgTab, fCommand.ArgTabDefault, fCommand.getHilfeText())) {
            try {
                fCommand.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fCommand.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fCommand.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fCommand.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fCommand.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public FCommand() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FCommand(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public boolean checkExec() {
        String[] Vorgaenge;
        int pos;
        Futi futi = Futi.instance();
        FProt fProt = FProt.instance();
        boolean rc = true;
        if (this.getVorgang().length() > 0 && (pos = FString.findFirstString(Vorgaenge = futi.restoreField(Futi.getClassName(this), "Vorgang"), String.valueOf(this.getVorgang()) + "\t")) >= 0) {
            String[] Teile = Vorgaenge[pos].split("\t");
            SimpleDateFormat formatZeitPunkt = new SimpleDateFormat("d.M.y,H.m.s");
            Date DatumUhrzeit = new Date();
            boolean DatumGueltig = true;
            try {
                DatumUhrzeit = formatZeitPunkt.parse(Teile[1]);
            }
            catch (ParseException e) {
                DatumGueltig = false;
            }
            if (DatumGueltig) {
                FGregorianCalendar zeitPunkt = new FGregorianCalendar();
                zeitPunkt.setTimeInMillis(DatumUhrzeit.getTime());
                String textL = "Letzte Ausfuehrung von >" + this.getVorgang() + "< war am " + zeitPunkt.toGermanFormat();
                fProt.prot(textL, 1);
                zeitPunkt.add(11, this.getMinStunden());
                zeitPunkt.add(6, this.getMinTage());
                zeitPunkt.add(3, this.getMinWochen());
                zeitPunkt.add(2, this.MinMonate);
                if (zeitPunkt.getTimeInMillis() > new Date().getTime()) {
                    rc = false;
                    String textN = "Naechste Ausfuehrung von >" + this.getVorgang() + "< ab " + zeitPunkt.toGermanFormat();
                    fProt.prot(textN);
                    if (this.isBroadcastMessage() && Futi.isMac()) {
                        FBefehl.aufrufBefehl("terminal-notifier", new String[]{"-message", "Jetzt keine Ausfuehrung von >" + this.getVorgang() + "<", "-title", this.getVorgang()});
                        FBefehl.aufrufBefehl("terminal-notifier", new String[]{"-message", textL.replace(' ', '_'), "-title", this.getVorgang()});
                        FBefehl.aufrufBefehl("terminal-notifier", new String[]{"-message", textN.replace(' ', '_'), "-title", this.getVorgang()});
                    }
                }
            }
        }
        return rc;
    }

    public void checkSave() {
        Futi futi = Futi.instance();
        String zeile = String.valueOf(this.getVorgang()) + "\t" + new FGregorianCalendar().toGermanFormat();
        if (this.getVorgang().length() > 0) {
            ArrayList<String> Vorgaenge = FString.stringArrayToArrayList(futi.restoreField(Futi.getClassName(this), "Vorgang"));
            int pos = FString.findFirstString(Vorgaenge, this.getVorgang());
            if (pos >= 0) {
                Vorgaenge.set(pos, zeile);
            } else {
                Vorgaenge.add(zeile);
            }
            futi.saveField(Futi.getClassName(this), "Vorgang", FString.arrayListToStringArray(Vorgaenge));
        }
    }

    public String getBefehl() {
        return this.Befehl;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public int getMinMonate() {
        return this.MinMonate;
    }

    public int getMinStunden() {
        return this.MinStunden;
    }

    public int getMinTage() {
        return this.MinTage;
    }

    public int getMinWochen() {
        return this.MinWochen;
    }

    public String getParameter() {
        return this.Parameter;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "30.11.2009";
    }

    public String getVorgang() {
        return this.Vorgang;
    }

    public boolean isBroadcastMessage() {
        return this.BroadcastMessage;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public void run() {
        FProt fProt = FProt.instance();
        if (this.checkExec()) {
            fProt.prot("Befehl:" + this.getBefehl() + ", Parameter:" + this.getParameter());
            fProt.prot(FBefehl.aufrufBefehl(this.getBefehl(), this.getParameter().split(" "), 2));
            this.checkSave();
        }
    }

    public void setBefehl() {
        this.Befehl = FParam.getStringParameter("Befehl", this.ArgTab);
    }

    public void setBefehl(String befehl) {
        FParam.instance();
        this.Befehl = FParam.checkStringParameter("Befehl", befehl, this.ArgTab);
    }

    public void setBroadcastMessage() {
        this.BroadcastMessage = FParam.getBooleanParameter("BroadcastMessage", this.ArgTab);
    }

    public void setBroadcastMessage(boolean broadcastMessage) {
        this.BroadcastMessage = broadcastMessage;
    }

    public void setMinMonate() {
        this.MinMonate = FParam.getIntParameter("MinMonate", this.ArgTab);
    }

    public void setMinMonate(int minMonate) {
        FParam.instance();
        this.MinMonate = FParam.checkIntParameter("MinMonate", minMonate, this.ArgTab);
    }

    public void setMinMonate(String minMonate) {
        this.MinMonate = FParam.checkIntParameter("MinMonate", minMonate, this.ArgTab);
    }

    public void setMinStunden() {
        this.MinStunden = FParam.getIntParameter("MinStunden", this.ArgTab);
    }

    public void setMinStunden(int minStunden) {
        FParam.instance();
        this.MinStunden = FParam.checkIntParameter("MinStunden", minStunden, this.ArgTab);
    }

    public void setMinStunden(String minStunden) {
        this.MinStunden = FParam.checkIntParameter("MinStunden", minStunden, this.ArgTab);
    }

    public void setMinTage() {
        this.MinTage = FParam.getIntParameter("MinTage", this.ArgTab);
    }

    public void setMinTage(int minTage) {
        FParam.instance();
        this.MinTage = FParam.checkIntParameter("MinTage", minTage, this.ArgTab);
    }

    public void setMinTage(String minTage) {
        this.MinTage = FParam.checkIntParameter("MinTage", minTage, this.ArgTab);
    }

    public void setMinWochen() {
        this.MinWochen = FParam.getIntParameter("MinWochen", this.ArgTab);
    }

    public void setMinWochen(int minWochen) {
        FParam.instance();
        this.MinWochen = FParam.checkIntParameter("MinWochen", minWochen, this.ArgTab);
    }

    public void setMinWochen(String minWochen) {
        this.MinWochen = FParam.checkIntParameter("MinWochen", minWochen, this.ArgTab);
    }

    public void setParameter() {
        this.Parameter = FParam.getStringParameter("Parameter", this.ArgTab);
    }

    public void setParameter(String parameter) {
        FParam.instance();
        this.Parameter = FParam.checkStringParameter("Parameter", parameter, this.ArgTab);
    }

    public void setVorgang() {
        this.Vorgang = FParam.getStringParameter("Vorgang", this.ArgTab);
    }

    public void setVorgang(String vorgang) {
        FParam.instance();
        this.Vorgang = FParam.checkStringParameter("Vorgang", vorgang, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setBefehl();
        this.setParameter();
        this.setVorgang();
        this.setBroadcastMessage();
        this.setMinStunden();
        this.setMinTage();
        this.setMinWochen();
        this.setMinMonate();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("auszufuehrender Befehl                         :" + this.getBefehl());
        fProt.prot("Parameter                                      :" + this.getParameter());
        fProt.prot("Vorgang                                        :" + this.getVorgang());
        fProt.prot("Anzahl Broadcast Meldungen (bisher nur auf Mac):" + this.isBroadcastMessage());
        fProt.prot("Vorgang wiederholen fruehestens nach s Stunden :" + this.getMinStunden());
        fProt.prot("Vorgang wiederholen fruehestens nach t Tagen   :" + this.getMinTage());
        fProt.prot("Vorgang wiederholen fruehestens nach w Wochen  :" + this.getMinWochen());
        fProt.prot("Vorgang wiederholen fruehestens nach m Monaten :" + this.getMinMonate());
    }
}

