/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class DateiBefehl {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Datei;
    private String CharsetEingabe;
    private String Trennzeichen;
    private String Befehl;
    private boolean Test;
    private final boolean SetzenWerteInGUInachRun = false;
    private final String Stand = "9.3.2009 8:44:23";

    public static void main(String[] args) {
        DateiBefehl dateiBefehl = new DateiBefehl(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(dateiBefehl.ArgTab, dateiBefehl.ArgTabDefault, dateiBefehl.getHilfeText())) {
            try {
                dateiBefehl.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + dateiBefehl.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                dateiBefehl.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + dateiBefehl.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + dateiBefehl.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public DateiBefehl() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public DateiBefehl(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getBefehl() {
        return this.Befehl;
    }

    public String getCharsetEingabe() {
        return this.CharsetEingabe;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "9.3.2009 8:44:23";
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTest() {
        return this.Test;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FBefehl.instance();
        Futi.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen(), true, "/"));
        if (this.getDatei().length() > 0) {
            FFile Ein = new FFile(this.getDatei());
            String[] Zeile = Ein.inhaltToStringArray(this.getCharsetEingabe());
            fProt.prot(Zeile, 9);
            FBefehl.executeDateiBefehl(Zeile, this.getTrennzeichen(), this.getBefehl(), this.isTest());
        }
    }

    public void setBefehl() {
        this.Befehl = FParam.getStringParameter("Befehl", this.ArgTab);
    }

    public void setBefehl(String befehl) {
        FParam.instance();
        this.Befehl = FParam.checkStringParameter("Befehl", befehl, this.ArgTab);
    }

    public void setCharsetEingabe() {
        this.CharsetEingabe = FParam.getStringParameter("CharsetEingabe", this.ArgTab);
    }

    public void setCharsetEingabe(String charsetEingabe) {
        this.CharsetEingabe = FParam.checkStringParameter("CharsetEingabe", charsetEingabe, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setTest() {
        this.Test = FParam.getBooleanParameter("Test", this.ArgTab);
    }

    public void setTest(boolean test) {
        this.Test = test;
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        FParam.instance();
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setDatei();
        this.setCharsetEingabe();
        this.setTrennzeichen();
        this.setBefehl();
        this.setTest();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei                                                                              :" + this.getDatei());
        fProt.prot("Charset (Codepage) fuer Eingabedatei                                                      :" + this.getCharsetEingabe());
        fProt.prot("Trennzeichen zwischen Befehl und Dat.(en)                                                 :" + this.getTrennzeichen());
        fProt.prot("Befehl fuer alle Eintraege: falls keine Befehle, sondern nur Namen von Dat. angegeben sind:" + this.getBefehl());
        fProt.prot("Test, nur pruefen, nicht ausfuehren                                                       :" + this.isTest());
    }
}

