/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Date;

public class Datei2Tabelle {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String DBName;
    private String Eingabedatei;
    private String Charset;
    private String Trennzeichen;
    private String ZusaetzlichesTrennzeichen;
    private boolean LeereSpaltenUebernehmen;
    private boolean NichtLoeschen;
    private boolean OhneFeldnamen;
    private boolean ZeilenAnfuegen;
    private String Tabelle;
    private String[][] ExterneListe;
    private String[][] Columns;
    private boolean OhneStand;
    private String VersionStandFeldname;
    private final boolean SetzenWerteInGUInachRun = true;
    private final String Stand = "30.6.2012";

    public static void main(String[] args) {
        Datei2Tabelle datei2Tabelle = new Datei2Tabelle(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(datei2Tabelle.ArgTab, datei2Tabelle.ArgTabDefault, datei2Tabelle.getHilfeText())) {
            try {
                datei2Tabelle.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + datei2Tabelle.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                datei2Tabelle.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + datei2Tabelle.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + datei2Tabelle.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Datei2Tabelle() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Datei2Tabelle(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String createInsert(String[] Liste2, int AnzahlSpalten, String Feldnamen, int[] SpaltenLaenge, boolean[] SpaltenHochkomma) {
        FProt fProt = FProt.instance();
        FDB.instance();
        String sqlStatement = "";
        String[] FeldName = Feldnamen.split(",");
        FeldName[0] = FeldName[0].replace("(", " ").trim();
        FeldName[FeldName.length - 1] = FeldName[FeldName.length - 1].replace(")", " ").trim();
        if (Liste2.length < AnzahlSpalten) {
            fProt.prot("Zu wenig Spalten vorhanden -> SQL-Statement leer");
        } else {
            int j = -1;
            int i = 0;
            while (i < AnzahlSpalten) {
                if (SpaltenLaenge[i] > 0 || this.isLeereSpaltenUebernehmen()) {
                    String Hochkomma;
                    ++j;
                    if (SpaltenHochkomma[i]) {
                        Hochkomma = "'";
                        if (Liste2[i].indexOf("'") >= 0) {
                            Liste2[i] = Liste2[i].replace("'", "''");
                        }
                    } else {
                        Hochkomma = "";
                    }
                    if (i > 0) {
                        sqlStatement = String.valueOf(sqlStatement) + ", ";
                    }
                    sqlStatement = String.valueOf(sqlStatement) + Hochkomma;
                    if (Liste2[i].trim().length() > FDB.getColumnLength(this.getColumns(), FeldName[j].trim())) {
                        String Zeile = FString.stringArrayToString(Liste2);
                        if (Zeile.length() > 80) {
                            Zeile = Zeile.substring(0, 80);
                        }
                        fProt.prot("Korrektur bei:" + Zeile);
                        fProt.prot("Column:" + FeldName[j].trim() + ", ColumnLaenge:" + FDB.getColumnLength(this.getColumns(), FeldName[j].trim()) + ", Datenlaenge :" + Liste2[i].trim().length() + " gekuerzt auf " + FDB.getColumnLength(this.getColumns(), FeldName[j].trim()));
                        sqlStatement = String.valueOf(sqlStatement) + Liste2[i].trim().substring(0, FDB.getColumnLength(this.getColumns(), FeldName[j].trim()));
                    } else {
                        sqlStatement = String.valueOf(sqlStatement) + Liste2[i].trim();
                    }
                    sqlStatement = String.valueOf(sqlStatement) + Hochkomma;
                }
                ++i;
            }
        }
        return sqlStatement;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String[][] getColumns() {
        return this.Columns;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String[][] getExterneListe() {
        return this.ExterneListe;
    }

    public String getFelder(String[] Liste2, int AnzahlSpalten, int[] SpaltenLaenge) {
        FDB fDB = FDB.instance();
        String Felder = " (";
        int i = 0;
        while (i < AnzahlSpalten) {
            if (SpaltenLaenge[i] > 0 || this.isLeereSpaltenUebernehmen()) {
                if (i > 0) {
                    Felder = String.valueOf(Felder) + ", ";
                }
                Felder = Liste2[i].startsWith("#") ? (SpaltenLaenge[i] <= 4 ? String.valueOf(Felder) + fDB.getName4Query(Liste2[i].substring(1)) + " Int" : String.valueOf(Felder) + fDB.getName4Query(Liste2[i].substring(1)) + " Long") : (Liste2[i].startsWith(".") ? String.valueOf(Felder) + fDB.getName4Query(Liste2[i].substring(1)) + " DOUBLE" : (Liste2[i].startsWith("$") ? String.valueOf(Felder) + fDB.getName4Query(Liste2[i].substring(1)) + " DATE" : (SpaltenLaenge[i] > 255 ? String.valueOf(Felder) + fDB.getName4Query(Liste2[i]) + " MEMO" : String.valueOf(Felder) + fDB.getName4Query(Liste2[i]) + " CHAR(" + Math.max(1, SpaltenLaenge[i]) + ")")));
            }
            ++i;
        }
        if (!this.isOhneStand()) {
            Felder = String.valueOf(Felder) + ", " + this.getVersionStandFeldname() + " DATE";
        }
        Felder = String.valueOf(Felder) + ")";
        return Felder;
    }

    public String getFeldNamen(String[] Liste2, int AnzahlSpalten, int[] SpaltenLaenge) {
        FDB fDB = FDB.instance();
        String Feldnamen = "";
        if (!this.isOhneFeldnamen()) {
            Feldnamen = " (";
            int i = 0;
            while (i < AnzahlSpalten) {
                if (SpaltenLaenge[i] > 0 || this.isLeereSpaltenUebernehmen()) {
                    if (i > 0) {
                        Feldnamen = String.valueOf(Feldnamen) + ", ";
                    }
                    Feldnamen = Liste2[i].startsWith("#") || Liste2[i].startsWith(".") || Liste2[i].startsWith("$") ? String.valueOf(Feldnamen) + fDB.getName4Query(Liste2[i].substring(1)) : String.valueOf(Feldnamen) + fDB.getName4Query(Liste2[i]);
                }
                ++i;
            }
            if (!this.isOhneStand()) {
                Feldnamen = String.valueOf(Feldnamen) + ", " + this.getVersionStandFeldname();
            }
            Feldnamen = String.valueOf(Feldnamen) + ") ";
        }
        return Feldnamen;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "30.6.2012";
    }

    public String getTabelle() {
        return this.Tabelle;
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public String getVersionStandFeldname() {
        return this.VersionStandFeldname;
    }

    public String getZusaetzlichesTrennzeichen() {
        return this.ZusaetzlichesTrennzeichen;
    }

    public boolean isLeereSpaltenUebernehmen() {
        return this.LeereSpaltenUebernehmen;
    }

    public boolean isNichtLoeschen() {
        return this.NichtLoeschen;
    }

    public boolean isOhneFeldnamen() {
        return this.OhneFeldnamen;
    }

    public boolean isOhneStand() {
        return this.OhneStand;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isZeilenAnfuegen() {
        return this.ZeilenAnfuegen;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()));
        String[][] Liste2 = this.getExterneListe() != null && this.getExterneListe().length > 0 ? this.getExterneListe() : FString.convertStringArrayToTabelle(new FFile(this.getEingabedatei()).inhaltToStringArray(this.getCharset()), this.getTrennzeichen(), this.getZusaetzlichesTrennzeichen());
        String Feldnamen = "";
        String stand = "";
        if (!this.isOhneStand()) {
            stand = ", '" + new FGregorianCalendar().toGermanFormat('A') + "'";
        }
        int DatenAbPos = 1;
        if (this.isOhneFeldnamen()) {
            DatenAbPos = 0;
            this.setNichtLoeschen(true);
        }
        if (Liste2.length > 0) {
            int AnzahlFelder = Liste2[0].length;
            boolean[] SpaltenHochkomma = new boolean[AnzahlFelder];
            int[] FeldLaenge = new int[AnzahlFelder];
            int j = 0;
            while (j < AnzahlFelder) {
                if (this.isOhneFeldnamen()) {
                    SpaltenHochkomma[j] = true;
                } else if (!Liste2[0][j].startsWith("#") && !Liste2[0][j].startsWith(".")) {
                    SpaltenHochkomma[j] = true;
                }
                ++j;
            }
            int i = DatenAbPos;
            while (i < Liste2.length) {
                j = 0;
                while (j < AnzahlFelder) {
                    if (Liste2[i][j] != null) {
                        FeldLaenge[j] = Math.max(FeldLaenge[j], Liste2[i][j].trim().length());
                        if (Liste2[i][j].length() == 0 && !SpaltenHochkomma[j]) {
                            Liste2[i][j] = "0";
                        }
                    }
                    ++j;
                }
                ++i;
            }
            Statement DBStatement = FDB.createDBStatement(this.getDBName());
            if (DBStatement != null) {
                if (!this.isNichtLoeschen()) {
                    FDB.executeUpdate(DBStatement, "DROP TABLE " + fDB.getName4Query(this.getTabelle()), false, 0);
                    FDB.executeUpdate(DBStatement, "CREATE TABLE " + fDB.getName4Query(this.getTabelle()) + this.getFelder(Liste2[0], AnzahlFelder, FeldLaenge), 0);
                } else if (!this.isZeilenAnfuegen()) {
                    FDB.executeUpdate(DBStatement, "DELETE " + (this.DBName.endsWith(".sqlite") ? "" : "*") + " FROM " + fDB.getName4Query(this.getTabelle()), false, 0);
                }
                if (this.isOhneFeldnamen()) {
                    fProt.prot(fDB.getColumnsAsString(this.getDBName(), this.getTabelle()), 1);
                    Feldnamen = " ( " + fDB.getColumnNamesAsString(this.getDBName(), this.getTabelle()) + " ) ";
                } else {
                    Feldnamen = this.getFeldNamen(Liste2[0], AnzahlFelder, FeldLaenge);
                }
                int inserted = 0;
                this.setColumns(fDB.getColumns(this.getDBName(), fDB.getName4Query(this.getTabelle())));
                i = DatenAbPos;
                while (i < Liste2.length) {
                    inserted += FDB.executeUpdate(DBStatement, "INSERT INTO " + fDB.getName4Query(this.getTabelle()) + Feldnamen + " VALUES (" + this.createInsert(Liste2[i], AnzahlFelder, Feldnamen, FeldLaenge, SpaltenHochkomma) + stand + ")");
                    ++i;
                }
                fProt.prot(String.valueOf(inserted) + " Saetze eingefuegt");
                FDB.closeDBStatement(DBStatement);
            }
        }
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setColumns(String[][] columns) {
        this.Columns = columns;
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setExterneListe(String[][] externeListe) {
        this.ExterneListe = externeListe;
    }

    public void setLeereSpaltenUebernehmen() {
        this.LeereSpaltenUebernehmen = FParam.getBooleanParameter("LeereSpaltenUebernehmen", this.ArgTab);
    }

    public void setLeereSpaltenUebernehmen(boolean leereSpaltenUebernehmen) {
        this.LeereSpaltenUebernehmen = leereSpaltenUebernehmen;
    }

    public void setNichtLoeschen() {
        this.NichtLoeschen = FParam.getBooleanParameter("NichtLoeschen", this.ArgTab);
    }

    public void setNichtLoeschen(boolean tabelleNichtLoeschen) {
        this.NichtLoeschen = tabelleNichtLoeschen;
    }

    public void setOhneFeldnamen() {
        this.OhneFeldnamen = FParam.getBooleanParameter("OhneFeldnamen", this.ArgTab);
    }

    public void setOhneFeldnamen(boolean ohneFeldnamen) {
        this.OhneFeldnamen = ohneFeldnamen;
    }

    public void setOhneStand() {
        this.OhneStand = FParam.getBooleanParameter("OhneStand", this.ArgTab);
    }

    public void setOhneStand(boolean ohneStand) {
        this.OhneStand = ohneStand;
    }

    public void setTabelle() {
        this.Tabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.Tabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        FParam.instance();
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setVersionStandFeldname() {
        this.VersionStandFeldname = FParam.getStringParameter("VersionStandFeldname", this.ArgTab);
    }

    public void setVersionStandFeldname(String versionStandFeldname) {
        FParam.instance();
        this.VersionStandFeldname = FParam.checkStringParameter("VersionStandFeldname", versionStandFeldname, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setEingabedatei();
        this.setCharset();
        this.setTrennzeichen();
        this.setZusaetzlichesTrennzeichen();
        this.setDBName();
        this.setTabelle();
        this.setLeereSpaltenUebernehmen();
        this.setNichtLoeschen();
        this.setZeilenAnfuegen();
        this.setOhneFeldnamen();
        this.setOhneStand();
        this.setVersionStandFeldname();
    }

    public void setZeilenAnfuegen() {
        this.ZeilenAnfuegen = FParam.getBooleanParameter("ZeilenAnfuegen", this.ArgTab);
    }

    public void setZeilenAnfuegen(boolean zeilenAnfuegen) {
        this.ZeilenAnfuegen = zeilenAnfuegen;
    }

    public void setZusaetzlichesTrennzeichen() {
        this.ZusaetzlichesTrennzeichen = FParam.getStringParameter("ZusaetzlichesTrennzeichen", this.ArgTab);
    }

    public void setZusaetzlichesTrennzeichen(String zusaetzlichesTrennzeichen) {
        this.ZusaetzlichesTrennzeichen = FParam.checkStringParameter("ZusaetzlichesTrennzeichen", zusaetzlichesTrennzeichen, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei                                          :" + this.getEingabedatei());
        fProt.prot("Charset (Codepage) fuer Eingabe                       :" + this.getCharset());
        fProt.prot("Trennzeichen (Separator)                              :" + this.getTrennzeichen());
        fProt.prot("zusaetzliches Trennzeichen (Separator)                :" + this.getZusaetzlichesTrennzeichen());
        fProt.prot("DBName                                                :" + this.getDBName());
        fProt.prot("Tabelle                                               :" + this.getTabelle());
        fProt.prot("auch leere Spalten uebernehmen                        :" + this.isLeereSpaltenUebernehmen());
        fProt.prot("Tabelle nicht loeschen                                :" + this.isNichtLoeschen());
        fProt.prot("Zeilen anfuegen, falls Tabelle nicht geloescht wird   :" + this.isZeilenAnfuegen());
        fProt.prot("Ohne Feldnamen, dies impliziert Tabelle nicht loeschen:" + this.isOhneFeldnamen());
        fProt.prot("Ohne Stand, Timestamp                                 :" + this.isOhneStand());
        fProt.prot("Feldname von VersionStand                             :" + this.getVersionStandFeldname());
    }
}

