/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.FSystemProperties;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JTextArea;

public class ChangeChars {
    private static ChangeChars instance;
    private String Eingabedatei;
    private String Parameterdatei;
    private boolean LeereZeilenLoeschen;
    private String Konvertierung;
    private boolean EingabeGleichAusgabedatei;
    private int Spalte;
    private String Trennzeichen;
    private String Ausgabedatei;
    private String Charset;
    private final boolean SetzenWerteInGUInachRun = false;
    private String[] ExterneListe;
    private boolean TextAreaEingabe;
    private boolean KopierenAusgabeInClipboard;
    private boolean TrimSpalte;
    private boolean KopierenClipboardInEingabe;
    private int Wiederholen;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private boolean TextAreaAusgabe;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "11.10.11";

    public static synchronized ChangeChars instance() {
        if (instance == null) {
            instance = new ChangeChars();
        }
        return instance;
    }

    public static void main(String[] args) {
        ChangeChars changeChars = new ChangeChars(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(changeChars.ArgTab, changeChars.ArgTabDefault, changeChars.getHilfeText())) {
            try {
                changeChars.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + changeChars.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                changeChars.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + changeChars.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + changeChars.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public ChangeChars() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public ChangeChars(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String[] getExterneListe() {
        return this.ExterneListe;
    }

    public String getExterneZeile() {
        String Zeile = "";
        if (this.getExterneListe().length > 0) {
            Zeile = this.getExterneListe()[0];
        }
        return Zeile;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public String getKonvertierung() {
        return this.Konvertierung;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getParameterdatei() {
        return this.Parameterdatei;
    }

    public int getSpalte() {
        return this.Spalte;
    }

    public String getStand() {
        return "11.10.11";
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public int getWiederholen() {
        return this.Wiederholen;
    }

    public boolean isEingabeGleichAusgabedatei() {
        return this.EingabeGleichAusgabedatei;
    }

    public boolean isKopierenAusgabeInClipboard() {
        return this.KopierenAusgabeInClipboard;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    public boolean isLeereZeilenLoeschen() {
        return this.LeereZeilenLoeschen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    public boolean isTrimSpalte() {
        return this.TrimSpalte;
    }

    public void run() {
        FProt fProt = FProt.instance();
        String[] Zeile = new String[]{""};
        Zeile = this.getExterneListe() != null && this.getExterneListe().length > 0 ? this.getExterneListe() : Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), this.isLeereZeilenLoeschen(), this.getCharset());
        String[] Teile = new String[]{""};
        fProt.prot(Zeile, 2);
        String[][] Param = this.setKonvertierungsTabelle();
        if (Param == null) {
            fProt.prot("Keine (geeignte Konvertierung vorhanden -> keine Verarbeitung");
        } else {
            int i = 0;
            while (i < Param.length) {
                fProt.prot(String.valueOf(Param[i][0]) + "->" + Param[i][1], 1);
                if (Param[i][0].compareTo("\\t") == 0) {
                    Param[i][0] = "\t";
                }
                if (Param[i][1].compareTo("\\t") == 0) {
                    Param[i][1] = "\t";
                }
                ++i;
            }
            this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen(), true, " "));
            i = 0;
            while (i < Zeile.length) {
                String ToChange;
                if (this.getSpalte() > 0) {
                    Teile = Zeile[i].split(this.getTrennzeichen());
                    ToChange = this.getSpalte() > Teile.length ? "" : Teile[this.getSpalte() - 1];
                } else {
                    ToChange = Zeile[i];
                }
                int j = 0;
                while (j < Param.length) {
                    if (Param[j][0].length() > 0) {
                        int k = -1;
                        while (k < this.getWiederholen()) {
                            ToChange = ToChange.replace(Param[j][0], Param[j][1]);
                            ++k;
                        }
                    }
                    ++j;
                }
                if (this.isTrimSpalte()) {
                    ToChange = ToChange.trim();
                }
                if (this.getSpalte() > 0) {
                    if (this.getSpalte() <= Teile.length) {
                        Teile[this.getSpalte() - 1] = ToChange;
                    }
                    Zeile[i] = FString.zusammenfuegenStringArray(Teile, this.getTrennzeichen());
                } else {
                    Zeile[i] = ToChange;
                }
                ++i;
            }
            fProt.prot(Zeile, 2);
            if (this.isEingabeGleichAusgabedatei()) {
                this.setAusgabedatei(this.getEingabedatei());
            }
            if (this.getExterneListe() != null && this.getExterneListe().length > 0) {
                this.setExterneListe(Zeile);
            } else {
                Futi.setAusgabe(Zeile, this.getAusgabedatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), this.isKopierenAusgabeInClipboard());
            }
        }
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setEingabeGleichAusgabedatei() {
        this.EingabeGleichAusgabedatei = FParam.getBooleanParameter("EingabeGleichAusgabedatei", this.ArgTab);
    }

    public void setEingabeGleichAusgabedatei(boolean eingabeGleichAusgabedatei) {
        this.EingabeGleichAusgabedatei = eingabeGleichAusgabedatei;
    }

    public void setExterneListe(String[] externeListe) {
        this.ExterneListe = externeListe;
    }

    public void setExterneZeile(String zeile) {
        this.ExterneListe = new String[]{zeile};
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKonvertierung() {
        this.Konvertierung = FParam.getStringParameter("Konvertierung", this.ArgTab);
    }

    public void setKonvertierung(String konvertierung) {
        FParam.instance();
        this.Konvertierung = FParam.checkStringParameter("Konvertierung", konvertierung, this.ArgTab);
    }

    public String[][] setKonvertierungsTabelle() {
        FString fString = FString.instance();
        Futi.instance();
        String[][] KonvertierungsTabelle = null;
        switch (this.getKonvertierung().charAt(0)) {
            case 'A': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".ASCII");
                break;
            }
            case 'Z': {
                if (this.getKonvertierung().compareToIgnoreCase("ZDEAN") == 0) {
                    KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Zahlen.deutsch.angelsaechsisch");
                    break;
                }
                if (this.getKonvertierung().compareToIgnoreCase("ZANDE") != 0) break;
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Zahlen.angelsaechsisch.deutsch");
                break;
            }
            case 'B': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Blank");
                break;
            }
            case 'G': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".GPS");
                break;
            }
            case 'M': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Html");
                break;
            }
            case 'U': {
                if (FSystemProperties.holenSystemProperty("os.name").compareTo("Mac OS X") == 0) {
                    KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Umlaute.Mac");
                    break;
                }
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Umlaute.Win");
                break;
            }
            case 'I': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".UmlautePortabel");
                break;
            }
            case '$': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".$");
                break;
            }
            case 'N': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".null");
                break;
            }
            case 'H': {
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".Hyong");
                break;
            }
            case 'F': {
                if (this.getKonvertierung().compareToIgnoreCase("FWU") == 0) {
                    KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".FWU");
                    break;
                }
                if (this.getKonvertierung().compareToIgnoreCase("FUW") == 0) {
                    KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".FUW");
                    break;
                }
                if (this.getKonvertierung().compareToIgnoreCase("FC") != 0) break;
                KonvertierungsTabelle = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".FC");
                break;
            }
            default: {
                FFile ParmDatei = new FFile(this.getParameterdatei());
                if (!ParmDatei.exists()) break;
                KonvertierungsTabelle = fString.convertStringArrayToTabelle(ParmDatei.inhaltToStringArray(), 2);
            }
        }
        return KonvertierungsTabelle;
    }

    public void setKopierenAusgabeInClipboard() {
        this.KopierenAusgabeInClipboard = FParam.getBooleanParameter("KopierenAusgabeInClipboard", this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard(boolean kopierenAusgabeInClipboard) {
        this.KopierenAusgabeInClipboard = kopierenAusgabeInClipboard;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setLeereZeilenLoeschen() {
        this.LeereZeilenLoeschen = FParam.getBooleanParameter("LeereZeilenLoeschen", this.ArgTab);
    }

    public void setLeereZeilenLoeschen(boolean leereZeilenLoeschen) {
        this.LeereZeilenLoeschen = leereZeilenLoeschen;
    }

    public void setParameterdatei() {
        this.Parameterdatei = FParam.getStringParameter("Parameterdatei", this.ArgTab);
    }

    public void setParameterdatei(String parameterdatei) {
        FParam.instance();
        this.Parameterdatei = FParam.checkStringParameter("Parameterdatei", parameterdatei, this.ArgTab);
    }

    public void setSpalte() {
        this.Spalte = FParam.getIntParameter("Spalte", this.ArgTab);
    }

    public void setSpalte(int spalte) {
        FParam.instance();
        this.Spalte = FParam.checkIntParameter("Spalte", spalte, this.ArgTab);
    }

    public void setSpalte(String spalte) {
        this.Spalte = FParam.checkIntParameter("Spalte", spalte, this.ArgTab);
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        FParam.instance();
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setTrimSpalte() {
        this.TrimSpalte = FParam.getBooleanParameter("TrimSpalte", this.ArgTab);
    }

    public void setTrimSpalte(boolean trimSpalte) {
        this.TrimSpalte = trimSpalte;
    }

    public void setWerteAusArgTab() {
        this.setEingabedatei();
        this.setAusgabedatei();
        this.setEingabeGleichAusgabedatei();
        this.setSpalte();
        this.setTrennzeichen();
        this.setCharset();
        this.setKonvertierung();
        this.setParameterdatei();
        this.setWiederholen();
        this.setTrimSpalte();
        this.setLeereZeilenLoeschen();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
        this.setKopierenAusgabeInClipboard();
    }

    public void setWiederholen() {
        this.Wiederholen = FParam.getIntParameter("Wiederholen", this.ArgTab);
    }

    public void setWiederholen(int wiederholen) {
        FParam.instance();
        this.Wiederholen = FParam.checkIntParameter("Wiederholen", wiederholen, this.ArgTab);
    }

    public void setWiederholen(String wiederholen) {
        this.Wiederholen = FParam.checkIntParameter("Wiederholen", wiederholen, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei                                                :" + this.getEingabedatei());
        fProt.prot("Ausgabedatei                                                :" + this.getAusgabedatei());
        fProt.prot("Eingabedatei ueberschreiben                                 :" + this.isEingabeGleichAusgabedatei());
        fProt.prot("Konvertierung in einer oder allen Spalten, 0=alle Spalten   :" + this.getSpalte());
        fProt.prot("Trennzeichen (Separator)                                    :" + this.getTrennzeichen());
        fProt.prot("Charset (Codepage) fuer Eingabe                             :" + this.getCharset());
        fProt.prot("Eingebaute Konvertierungen                                  :" + this.getKonvertierung());
        fProt.prot("Parameterdatei                                              :" + this.getParameterdatei());
        fProt.prot("Konvertierung n-mal durchfuehren, z.B. um Blanks zu loeschen:" + this.getWiederholen());
        fProt.prot("Spalte trimmen (leading und trailing blank abschneiden)     :" + this.isTrimSpalte());
        fProt.prot("Leere Zeilen loeschen                                       :" + this.isLeereZeilenLoeschen());
        fProt.prot("TextArea statt Eingabedatei verwenden                       :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden                       :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Eingabe in TextArea kopieren            :" + this.isKopierenClipboardInEingabe());
        fProt.prot("TextArea fuer Ausgabe in Zwischenablage kopieren            :" + this.isKopierenAusgabeInClipboard());
    }
}

