/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class Buecher {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = false;
    private String[][] ArgTab;
    private final String Stand = "30.10.2016";
    private String Eingabeverzeichnis;
    private String EingabeCharset;
    private boolean AlleBuecherAusgeben;
    private String AusgabeCharset;
    private String Ausgabeverzeichnis;
    private String Stamm;
    private String Trennzeichen;
    private String ExtendIn;
    private String ExtendOut;
    private int Von;
    private int Bis;

    private static String[] getBuchHeader() {
        String[] aus = new String[]{"Autor", "Titel", "Jahr", "Verlag", "Ort", "Untertitel/Bemerkung", "Mitautoren/Uebersetzer", "Umfang (Seiten)", "Preis/Art", "ISBN", "IDN", "Quelle"};
        return aus;
    }

    private static String[] getBuchLeer() {
        String[] aus = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        return aus;
    }

    public static void main(String[] args) {
        Buecher buecher = new Buecher(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(buecher.ArgTab, buecher.ArgTabDefault, buecher.getHilfeText())) {
            try {
                buecher.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + buecher.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                buecher.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + buecher.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + buecher.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Buecher() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Buecher(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getAusgabeCharset() {
        return this.AusgabeCharset;
    }

    public String getAusgabeverzeichnis() {
        return this.Ausgabeverzeichnis;
    }

    private String[] getBibFrameDataDeutscheNationalBibliothek(String idn, String isbn) {
        String[] aus = new String[]{"", "", "", "", "", "", "", "", "", isbn, idn, ""};
        String autor = "";
        String mitAutorUebersetzer = "";
        if (idn.length() > 5) {
            String[] zeilen = FString.convertStringArrayFromCharset(Futi.getHTMLData("http://d-nb.info/" + idn + "/about/bibframe"), this.getEingabeCharset());
            FProt.instance().prot(zeilen, 2);
            String[] seps = new String[]{"<bf:responsibilityStatement>", "<bf:title>", "<bf:providerDate>", "<bf:providerName>", "<bf:providerPlace>"};
            if (zeilen.length > 5) {
                aus[aus.length - 1] = "N";
                String[] stringArray = zeilen;
                int n = zeilen.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String zeile = element.trim();
                    int i = 0;
                    while (i < seps.length) {
                        String sep = seps[i];
                        if (zeile.startsWith(sep)) {
                            aus[i] = zeile.substring(sep.length(), zeile.indexOf("</bf:")).replace('\"', ' ').trim();
                        }
                        ++i;
                    }
                    ++n2;
                }
            }
            if ((autor = aus[0]).indexOf(91) > 0) {
                mitAutorUebersetzer = autor.substring(autor.indexOf(91));
                autor = autor.substring(0, autor.indexOf(91));
            } else if (autor.indexOf(46, 10) > 0) {
                mitAutorUebersetzer = autor.substring(autor.indexOf(46, 10));
                autor = autor.substring(0, autor.indexOf(46, 10));
            }
            mitAutorUebersetzer = mitAutorUebersetzer.trim();
            if (mitAutorUebersetzer.startsWith(".")) {
                mitAutorUebersetzer = mitAutorUebersetzer.substring(1);
            }
            if ((autor = autor.trim()).endsWith(".")) {
                autor = autor.substring(0, autor.length() - 1);
            }
            aus[0] = autor;
            aus[6] = mitAutorUebersetzer;
        }
        return aus;
    }

    public int getBis() {
        return this.Bis;
    }

    private String[] getDataDeutscheNationalBibliothek(String idn, String isbn) {
        String[] buchRDF = this.getRDFDataDeutscheNationalBibliothek(idn, isbn);
        String[] buchBibFrame = this.getBibFrameDataDeutscheNationalBibliothek(idn, isbn);
        return FString.mergeStringArrays(buchRDF, buchBibFrame);
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabeCharset() {
        return this.EingabeCharset;
    }

    public String getEingabeverzeichnis() {
        return this.Eingabeverzeichnis;
    }

    public String getExtendIn() {
        return this.ExtendIn;
    }

    public String getExtendOut() {
        return this.ExtendOut;
    }

    private String[] getGoogleBooksData(String isbn) {
        String[] aus = new String[]{"", "", "", "", "", "", "", "", "", isbn, "", ""};
        if (isbn.length() > 5) {
            String[] zeilen = FString.convertStringArrayFromCharset(Futi.getHTMLData("https://www.googleapis.com/books/v1/volumes?q=isbn:" + FString.clearString(isbn, ' ', true, false, false, null, null)), this.getEingabeCharset());
            FProt.instance().prot(zeilen, 2);
            String[] seps = new String[]{"authors", "title", "publishedDate", "publisher", "location:XXX", "subtitle", "coauthors:XXX", "pageCount"};
            boolean autorIndex = false;
            boolean autorPending = false;
            boolean ersterAutor = true;
            if (zeilen.length > 5) {
                aus[aus.length - 1] = "G";
                String[] stringArray = zeilen;
                int n = zeilen.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String zeile = element.trim();
                    if (autorPending) {
                        if (zeile.startsWith("],")) {
                            autorPending = false;
                        } else {
                            aus[0] = String.valueOf(aus[0]) + (ersterAutor ? "" : ", ") + FString.clearString(zeile, ' ', "\u221a\u00f1\u221a\u00d1\u221a\u00fa\u221a\u2202\u221a\u00a7\u221a\u00ba\u221a\u00fc", null).trim();
                            ersterAutor = false;
                        }
                    } else {
                        int i = 0;
                        while (i < seps.length) {
                            String sep = seps[i];
                            if (zeile.startsWith("\"" + sep + "\": ")) {
                                if (sep.compareToIgnoreCase("authors") == 0) {
                                    autorPending = true;
                                    break;
                                }
                                aus[i] = zeile.substring(sep.length() + 4, zeile.length() - 1).replace('\"', ' ').trim();
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
        }
        return aus;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    private String[] getRDFDataDeutscheNationalBibliothek(String idn, String isbn) {
        String[] aus = new String[]{"", "", "", "", "", "", "", "", "", isbn, idn, ""};
        if (idn.length() > 5) {
            String[] zeilen = FString.convertStringArrayFromCharset(Futi.getHTMLData("http://d-nb.info/" + idn + "/about/lds"), this.getEingabeCharset());
            FProt.instance().prot(zeilen, 2);
            String[] seps = new String[]{"dc:autor:XXX", "dc:title", "dcterms:issued", "dc:publisher", "rdau:P60163", "rdau:P60493", "dc:bemerkung2:XXX", "isbd:P1053", "rdau:P60521"};
            if (zeilen.length > 5) {
                aus[aus.length - 1] = "N";
                String[] stringArray = zeilen;
                int n = zeilen.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String zeile = element.trim();
                    int i = 0;
                    while (i < seps.length) {
                        String sep = seps[i];
                        if (zeile.startsWith(sep)) {
                            aus[i] = zeile.substring(sep.length() + 2, zeile.length() - 3).replace('\"', ' ').trim();
                        }
                        ++i;
                    }
                    ++n2;
                }
            }
        }
        return aus;
    }

    public String getStamm() {
        return this.Stamm;
    }

    public String getStand() {
        return "30.10.2016";
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public int getVon() {
        return this.Von;
    }

    public boolean isAlleBuecherAusgeben() {
        return this.AlleBuecherAusgeben;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        String dateiName;
        this.setEingabeverzeichnis(FDatei.checkFileSeperator(this.getEingabeverzeichnis(), true));
        this.setAusgabeverzeichnis(FDatei.checkFileSeperator(this.getAusgabeverzeichnis(), true));
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()).substring(0, 1));
        char trennzeichen = this.getTrennzeichen().charAt(0);
        String fachNr = "";
        String[] buch = new String[]{""};
        String[] buchDNB = new String[]{""};
        String[] buchGoogle = new String[]{""};
        char[] erg = new char[]{' '};
        ArrayList<String> buecher = new ArrayList<String>();
        ArrayList<String> alleBuecher = new ArrayList<String>();
        alleBuecher.add(FString.stringArrayToString(Buecher.getBuchHeader(), this.getTrennzeichen()));
        int j = this.getVon();
        while (j <= this.getBis()) {
            fachNr = String.valueOf(j < 10 ? "0" : "") + j;
            dateiName = String.valueOf(this.getEingabeverzeichnis()) + this.getStamm() + "_" + fachNr + "." + this.getExtendIn();
            FFile fachDatei = new FFile(dateiName);
            if (fachDatei.canRead()) {
                FProt.instance().prot("< " + dateiName);
                String[] isbns = fachDatei.inhaltToStringArray();
                if (isbns.length > 0) {
                    buecher.clear();
                    buecher.add(FString.stringArrayToString(Buecher.getBuchHeader(), this.getTrennzeichen()));
                    String[] stringArray = isbns;
                    int n = isbns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        String[] teile = element.split("\t");
                        FProt.instance().prot(element, 2);
                        buchDNB = teile.length > 1 ? this.getDataDeutscheNationalBibliothek(teile[1], teile[0]) : Buecher.getBuchLeer();
                        buchGoogle = this.getGoogleBooksData(teile[0]);
                        buch = FString.mergeStringArrays(buchDNB, buchGoogle, erg);
                        if (erg[0] == 'B') {
                            buch[buch.length - 1] = "N+G";
                        }
                        int i = 0;
                        while (i < buch.length) {
                            buch[i] = buch[i].replace(trennzeichen, ' ').replace('[', ' ').replace(']', ' ').trim();
                            buch[i] = FString.ersetzeTeilString(buch[i], "&quot;", "");
                            buch[i] = FString.ersetzeTeilString(buch[i], "&quot", "");
                            buch[i] = FString.ersetzeTeilString(buch[i], "&amp;", "");
                            buch[i] = FString.ersetzeTeilString(buch[i], "&amp", "");
                            buch[i] = FString.ersetzeTeilString(buch[i], " &", " und ");
                            buch[i] = FString.ersetzeTeilString(buch[i], "  ", " ");
                            buch[i] = FString.ersetzeTeilString(buch[i], " ,", ",");
                            buch[i] = FString.ersetzeTeilString(buch[i], " ;", ":");
                            buch[i] = FString.ersetzeTeilString(buch[i], " :", ":");
                            ++i;
                        }
                        FProt.instance().prot(buch, 2);
                        buecher.add(FString.stringArrayToString(buch, this.getTrennzeichen()));
                        ++n2;
                    }
                    dateiName = String.valueOf(this.getAusgabeverzeichnis()) + this.getStamm() + "_" + fachNr + "." + this.getExtendOut();
                    FProt.instance().prot("> " + dateiName);
                    new FFile(dateiName).StringArrayListToInhalt(buecher, this.getAusgabeCharset());
                    if (this.isAlleBuecherAusgeben()) {
                        buch = Buecher.getBuchLeer();
                        buch[0] = String.valueOf(this.getStamm()) + " " + fachNr;
                        alleBuecher.add(FString.stringArrayToString(buch, this.getTrennzeichen()));
                        int i = 1;
                        while (i < buecher.size()) {
                            alleBuecher.add(buecher.get(i));
                            ++i;
                        }
                    }
                }
            }
            ++j;
        }
        if (this.isAlleBuecherAusgeben()) {
            dateiName = String.valueOf(this.getAusgabeverzeichnis()) + this.getStamm() + "_alle." + this.getExtendOut();
            FProt.instance().prot("> " + dateiName);
            new FFile(dateiName).StringArrayListToInhalt(alleBuecher, this.getAusgabeCharset());
        }
    }

    public void setAlleBuecherAusgeben() {
        this.AlleBuecherAusgeben = FParam.getBooleanParameter("AlleBuecherAusgeben", this.ArgTab);
    }

    public void setAlleBuecherAusgeben(boolean alleBuecherAusgeben) {
        this.AlleBuecherAusgeben = alleBuecherAusgeben;
    }

    public void setAusgabeCharset() {
        this.AusgabeCharset = FParam.getStringParameter("AusgabeCharset", this.ArgTab);
    }

    public void setAusgabeCharset(String ausgabeCharset) {
        this.AusgabeCharset = FParam.checkStringParameter("AusgabeCharset", ausgabeCharset, this.ArgTab);
    }

    public void setAusgabeverzeichnis() {
        this.Ausgabeverzeichnis = FParam.getStringParameter("Ausgabeverzeichnis", this.ArgTab);
    }

    public void setAusgabeverzeichnis(String ausgabeverzeichnis) {
        this.Ausgabeverzeichnis = FParam.checkStringParameter("Ausgabeverzeichnis", ausgabeverzeichnis, this.ArgTab);
    }

    public void setBis() {
        this.Bis = FParam.getIntParameter("Bis", this.ArgTab);
    }

    public void setBis(int bis) {
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setBis(String bis) {
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setEingabeCharset() {
        this.EingabeCharset = FParam.getStringParameter("EingabeCharset", this.ArgTab);
    }

    public void setEingabeCharset(String eingabeCharset) {
        this.EingabeCharset = FParam.checkStringParameter("EingabeCharset", eingabeCharset, this.ArgTab);
    }

    public void setEingabeverzeichnis() {
        this.Eingabeverzeichnis = FParam.getStringParameter("Eingabeverzeichnis", this.ArgTab);
    }

    public void setEingabeverzeichnis(String eingabeverzeichnis) {
        this.Eingabeverzeichnis = FParam.checkStringParameter("Eingabeverzeichnis", eingabeverzeichnis, this.ArgTab);
    }

    public void setExtendIn() {
        this.ExtendIn = FParam.getStringParameter("ExtendIn", this.ArgTab);
    }

    public void setExtendIn(String extendIn) {
        this.ExtendIn = FParam.checkStringParameter("ExtendIn", extendIn, this.ArgTab);
    }

    public void setExtendOut() {
        this.ExtendOut = FParam.getStringParameter("ExtendOut", this.ArgTab);
    }

    public void setExtendOut(String extendOut) {
        this.ExtendOut = FParam.checkStringParameter("ExtendOut", extendOut, this.ArgTab);
    }

    public void setStamm() {
        this.Stamm = FParam.getStringParameter("Stamm", this.ArgTab);
    }

    public void setStamm(String stamm) {
        this.Stamm = FParam.checkStringParameter("Stamm", stamm, this.ArgTab);
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setVon() {
        this.Von = FParam.getIntParameter("Von", this.ArgTab);
    }

    public void setVon(int von) {
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setVon(String von) {
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setEingabeverzeichnis();
        this.setAusgabeverzeichnis();
        this.setStamm();
        this.setExtendIn();
        this.setExtendOut();
        this.setEingabeCharset();
        this.setAusgabeCharset();
        this.setVon();
        this.setBis();
        this.setTrennzeichen();
        this.setAlleBuecherAusgeben();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                              :" + this.getEingabeverzeichnis());
        fProt.prot("Ausgabeverzeichnis                              :" + this.getAusgabeverzeichnis());
        fProt.prot("Stamm fuer Dateinamen                           :" + this.getStamm());
        fProt.prot("Extend Eingabedateien                           :" + this.getExtendIn());
        fProt.prot("Extend Ausgabedateien                           :" + this.getExtendOut());
        fProt.prot("Charset (Codepage) fuer Eingabe                 :" + this.getEingabeCharset());
        fProt.prot("Charset (Codepage) fuer Ausgabe                 :" + this.getAusgabeCharset());
        fProt.prot("von Dateinummer                                 :" + this.getVon());
        fProt.prot("bis Dateinummer                                 :" + this.getBis());
        fProt.prot("Trennzeichen in der Ausgabedatei                :" + this.getTrennzeichen());
        fProt.prot("alle Buecher zusaetzlich in einer Datei ausgeben:" + this.isAlleBuecherAusgeben());
    }
}

