/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBild;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class BilderHtml {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Verzeichnis;
    private int AnzahlBilder;
    private int Fensterbreite;
    private int Hoehe;
    private int Breite;
    private String Font;
    private int Zeichengroesse;
    private int Sprung;
    private int Refresh;
    private boolean TextOben;
    private final boolean SetzenWerteInGUInachRun = false;
    private final String Stand = "20.12.2006";

    public static void main(String[] args) {
        BilderHtml bilderHtml = new BilderHtml(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(bilderHtml.ArgTab, bilderHtml.ArgTabDefault, bilderHtml.getHilfeText())) {
            try {
                bilderHtml.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + bilderHtml.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                bilderHtml.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + bilderHtml.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + bilderHtml.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public BilderHtml() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public BilderHtml(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getAnzahlBilder() {
        return this.AnzahlBilder;
    }

    public int getBreite() {
        return this.Breite;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public int getFensterbreite() {
        return this.Fensterbreite;
    }

    public String getFont() {
        return this.Font;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public int getHoehe() {
        return this.Hoehe;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public int getRefresh() {
        return this.Refresh;
    }

    public int getSprung() {
        return this.Sprung;
    }

    public String getStand() {
        return "20.12.2006";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public int getZeichengroesse() {
        return this.Zeichengroesse;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTextOben() {
        return this.TextOben;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FBild.instance();
        ArrayList<String> NameArray = new ArrayList<String>();
        ArrayList<String> EndungArray = new ArrayList<String>();
        ArrayList<String> HtmlDateien = new ArrayList<String>();
        BufferedWriter Ausgabe = null;
        if (this.getVerzeichnis().length() > 0) {
            String aktuelleDatei;
            FFile VerzeichnisFile = new FFile(this.getVerzeichnis());
            String[] Datei = VerzeichnisFile.listFileNames();
            fProt.prot("Dateien", 5);
            fProt.prot(Datei, 5);
            fProt.prot("JPEG-Dateien", 5);
            int i = 0;
            while (i < Datei.length) {
                int pos_Punkt = Datei[i].lastIndexOf(".");
                String NameH = Datei[i].substring(0, pos_Punkt);
                String EndungH = Datei[i].substring(pos_Punkt + 1);
                if (EndungH.compareToIgnoreCase("jpg") == 0 || EndungH.compareToIgnoreCase("jpeg") == 0) {
                    fProt.prot(String.valueOf(NameH) + " - " + EndungH, 5);
                    NameArray.add(NameH);
                    EndungArray.add(EndungH);
                }
                ++i;
            }
            String[] Name = FString.arrayListToStringArray(NameArray);
            String[] Endung = FString.arrayListToStringArray(EndungArray);
            i = 0;
            while (i < Name.length) {
                int AnzahlAktuelleBilder = 0;
                int aktuelleBreite = 0;
                while (AnzahlAktuelleBilder < this.getAnzahlBilder() && i + AnzahlAktuelleBilder < Name.length && aktuelleBreite <= this.getFensterbreite()) {
                    aktuelleDatei = String.valueOf(Name[i + AnzahlAktuelleBilder]) + "." + Endung[i + AnzahlAktuelleBilder];
                    FBild.setzenGroesse(aktuelleDatei, aktuelleDatei, this.getBreite(), this.getHoehe(), -1, null, false);
                    int[] aktuellesBildMasse = FBild.getGroesse(aktuelleDatei);
                    fProt.prot("           " + aktuelleDatei + " " + aktuellesBildMasse[0] + "x" + aktuellesBildMasse[1] + " B=" + (aktuelleBreite += aktuellesBildMasse[0]), 1);
                    ++AnzahlAktuelleBilder;
                }
                if (AnzahlAktuelleBilder > 1 && aktuelleBreite > this.getFensterbreite()) {
                    --AnzahlAktuelleBilder;
                }
                HtmlDateien.add("" + i);
                i += AnzahlAktuelleBilder;
            }
            String[] HtmlDateiString = FString.arrayListToStringArray(HtmlDateien);
            int[] HtmlDatei = new int[HtmlDateiString.length];
            i = 0;
            while (i < HtmlDatei.length) {
                HtmlDatei[i] = Integer.parseInt(HtmlDateiString[i]);
                fProt.prot(String.valueOf(Name[HtmlDatei[i]]) + " " + HtmlDatei[i], 1);
                ++i;
            }
            int letzteDatei = HtmlDatei[HtmlDatei.length - 1];
            fProt.prot(" <<< " + Name[0], 2);
            fProt.prot(" >>> " + Name[letzteDatei], 2);
            i = 0;
            while (i < HtmlDatei.length) {
                aktuelleDatei = String.valueOf(Name[HtmlDatei[i]]) + ".htm";
                fProt.prot("H: " + aktuelleDatei, 1);
                int vorigeDatei = i > 0 ? HtmlDatei[i - 1] : 0;
                int SprungZurueckDatei = i > this.getSprung() ? HtmlDatei[i - this.getSprung()] : 0;
                int naechsteDatei = i + 1 < HtmlDatei.length ? HtmlDatei[i + 1] : letzteDatei;
                int SprungVorDatei = i + this.getSprung() < HtmlDatei.length ? HtmlDatei[i + this.getSprung()] : letzteDatei;
                fProt.prot(" <  " + Name[vorigeDatei], 3);
                fProt.prot(" << " + Name[SprungZurueckDatei], 3);
                fProt.prot(" >  " + Name[naechsteDatei], 3);
                fProt.prot(" >> " + Name[SprungVorDatei], 3);
                try {
                    int j;
                    Ausgabe = new BufferedWriter(new FileWriter(new File(String.valueOf(this.getVerzeichnis()) + aktuelleDatei)));
                    Ausgabe.write("<html>");
                    Ausgabe.newLine();
                    Ausgabe.write("<head>");
                    Ausgabe.newLine();
                    Ausgabe.write("<title>Anzeige ab " + Name[i] + "</title>");
                    Ausgabe.newLine();
                    Ausgabe.write("</head>");
                    Ausgabe.newLine();
                    Ausgabe.write("<body>");
                    Ausgabe.newLine();
                    Ausgabe.write("<p><meta http-equiv=\"refresh\" content=\"" + this.getRefresh() + "; URL=" + Name[naechsteDatei] + ".htm\"> </font></p>");
                    Ausgabe.newLine();
                    if (this.isTextOben()) {
                        Ausgabe.write("<p align=\"center\">");
                        if (i + 1 < HtmlDatei.length) {
                            j = HtmlDatei[i];
                            while (j < HtmlDatei[i + 1]) {
                                aktuelleDatei = String.valueOf(Name[j]) + "." + Endung[j];
                                fProt.prot(" B:" + aktuelleDatei + " " + j, 1);
                                Ausgabe.write("<img src=\"" + aktuelleDatei + "\" align=\"top\">");
                                ++j;
                            }
                        } else {
                            j = HtmlDatei[i];
                            while (j < Name.length) {
                                aktuelleDatei = String.valueOf(Name[j]) + "." + Endung[j];
                                fProt.prot(" B:" + aktuelleDatei + " " + j, 1);
                                Ausgabe.write("<img src=\"" + aktuelleDatei + "\" align=\"top\">");
                                ++j;
                            }
                        }
                        Ausgabe.write("</p>");
                        Ausgabe.newLine();
                    }
                    Ausgabe.write("<table border=\"0\" width=\"100%\">");
                    Ausgabe.newLine();
                    Ausgabe.write("  <tr>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[0] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">Anfang&lt;&lt;&lt;</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[SprungZurueckDatei] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">" + this.getSprung() + " Seiten zur&uuml;ck&lt;&lt;</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[vorigeDatei] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">voriges&lt;</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[naechsteDatei] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">&gt;n\u00e4chstes</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[SprungVorDatei] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">&gt;&gt;" + this.getSprung() + "  Seiten vor</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("    <td><p align=\"center\"><a href=\"" + Name[letzteDatei] + ".htm\"><font size=\"" + this.getZeichengroesse() + "\" face=\"" + this.getFont() + "\">&gt;&gt;&gt;Ende</font></a></p></td>");
                    Ausgabe.newLine();
                    Ausgabe.write("  </tr>");
                    Ausgabe.newLine();
                    Ausgabe.write("</table>");
                    if (!this.isTextOben()) {
                        Ausgabe.write("<p align=\"center\">");
                        if (i + 1 < HtmlDatei.length) {
                            j = HtmlDatei[i];
                            while (j < HtmlDatei[i + 1]) {
                                aktuelleDatei = String.valueOf(Name[j]) + "." + Endung[j];
                                fProt.prot(" B:" + aktuelleDatei + " " + j, 1);
                                Ausgabe.write("<img src=\"" + aktuelleDatei + "\" align=\"top\">");
                                ++j;
                            }
                        } else {
                            j = HtmlDatei[i];
                            while (j < Name.length) {
                                aktuelleDatei = String.valueOf(Name[j]) + "." + Endung[j];
                                fProt.prot(" B:" + aktuelleDatei + " " + j, 1);
                                Ausgabe.write("<img src=\"" + aktuelleDatei + "\" align=\"top\">");
                                ++j;
                            }
                        }
                        Ausgabe.write("</p>");
                        Ausgabe.newLine();
                    }
                    Ausgabe.write("</body>");
                    Ausgabe.newLine();
                    Ausgabe.write("</html>");
                    Ausgabe.newLine();
                    Ausgabe.close();
                }
                catch (Exception e) {
                    fProt.prot(e.toString());
                }
                ++i;
            }
        }
    }

    public void setAnzahlBilder() {
        this.AnzahlBilder = FParam.getIntParameter("AnzahlBilder", this.ArgTab);
    }

    public void setAnzahlBilder(int anzahlBilder) {
        FParam.instance();
        this.AnzahlBilder = FParam.checkIntParameter("AnzahlBilder", anzahlBilder, this.ArgTab);
    }

    public void setAnzahlBilder(String anzahlBilder) {
        this.AnzahlBilder = FParam.checkIntParameter("AnzahlBilder", anzahlBilder, this.ArgTab);
    }

    public void setBreite() {
        this.Breite = FParam.getIntParameter("Breite", this.ArgTab);
    }

    public void setBreite(int breite) {
        FParam.instance();
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setBreite(String breite) {
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setFensterbreite() {
        this.Fensterbreite = FParam.getIntParameter("Fensterbreite", this.ArgTab);
    }

    public void setFensterbreite(int fensterbreite) {
        FParam.instance();
        this.Fensterbreite = FParam.checkIntParameter("Fensterbreite", fensterbreite, this.ArgTab);
    }

    public void setFensterbreite(String fensterbreite) {
        this.Fensterbreite = FParam.checkIntParameter("Fensterbreite", fensterbreite, this.ArgTab);
    }

    public void setFont() {
        this.Font = FParam.getStringParameter("Font", this.ArgTab);
    }

    public void setFont(String font) {
        FParam.instance();
        this.Font = FParam.checkStringParameter("Font", font, this.ArgTab);
    }

    public void setHoehe() {
        this.Hoehe = FParam.getIntParameter("Hoehe", this.ArgTab);
    }

    public void setHoehe(int hoehe) {
        FParam.instance();
        this.Hoehe = FParam.checkIntParameter("Hoehe", hoehe, this.ArgTab);
    }

    public void setHoehe(String hoehe) {
        this.Hoehe = FParam.checkIntParameter("Hoehe", hoehe, this.ArgTab);
    }

    public void setRefresh() {
        this.Refresh = FParam.getIntParameter("Refresh", this.ArgTab);
    }

    public void setRefresh(int refresh) {
        FParam.instance();
        this.Refresh = FParam.checkIntParameter("Refresh", refresh, this.ArgTab);
    }

    public void setRefresh(String refresh) {
        this.Refresh = FParam.checkIntParameter("Refresh", refresh, this.ArgTab);
    }

    public void setSprung() {
        this.Sprung = FParam.getIntParameter("Sprung", this.ArgTab);
    }

    public void setSprung(int sprung) {
        FParam.instance();
        this.Sprung = FParam.checkIntParameter("Sprung", sprung, this.ArgTab);
    }

    public void setSprung(String sprung) {
        this.Sprung = FParam.checkIntParameter("Sprung", sprung, this.ArgTab);
    }

    public void setTextOben() {
        this.TextOben = FParam.getBooleanParameter("TextOben", this.ArgTab);
    }

    public void setTextOben(boolean textOben) {
        this.TextOben = textOben;
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setAnzahlBilder();
        this.setFensterbreite();
        this.setHoehe();
        this.setBreite();
        this.setZeichengroesse();
        this.setSprung();
        this.setRefresh();
        this.setTextOben();
        this.setFont();
    }

    public void setZeichengroesse() {
        this.Zeichengroesse = FParam.getIntParameter("Zeichengroesse", this.ArgTab);
    }

    public void setZeichengroesse(int zeichengroesse) {
        FParam.instance();
        this.Zeichengroesse = FParam.checkIntParameter("Zeichengroesse", zeichengroesse, this.ArgTab);
    }

    public void setZeichengroesse(String zeichengroesse) {
        this.Zeichengroesse = FParam.checkIntParameter("Zeichengroesse", zeichengroesse, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                         :" + this.getVerzeichnis());
        fProt.prot("Anzahl Bilder auf einer Seite nebeneinander:" + this.getAnzahlBilder());
        fProt.prot("maximale Breite der Bilder nebeneinander   :" + this.getFensterbreite());
        fProt.prot("maximale Hoehe der Bilder                  :" + this.getHoehe());
        fProt.prot("maximale Breite der Bilder                 :" + this.getBreite());
        fProt.prot("Zeichengroesse                             :" + this.getZeichengroesse());
        fProt.prot("Anzahl Seiten fuer Sprung vor oder zurueck :" + this.getSprung());
        fProt.prot("Refresh der Bildanzeige in Sekunden        :" + this.getRefresh());
        fProt.prot("Text oben anzeigen, sonst unten            :" + this.isTextOben());
        fProt.prot("Zeichensatz                                :" + this.getFont());
    }
}

