/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGUI;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class Benutzerwerte {
    private static Benutzerwerte instance;
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = true;
    private String[][] ArgTab;
    private String Stand;
    private String Papierkorb;
    private String RootVonPapierkorb;
    private boolean ResetWerte;
    private boolean Speichern;
    private String TrennzeichenCommandlineParameter;
    private String Pfadtrennzeichen;
    private String RobocopyRsyncOrtName;
    private String RobocopyRsyncParameter;
    private String RobocopyRsyncCopy;
    private String RobocopyRsyncSync;
    private String ExiftoolParameter;
    private String VerzeichnisJavaSourcecode;
    private String VerzeichnisJavaTest;
    private String VerzeichnisGUIJavaSourcecode;

    public static synchronized Benutzerwerte instance() {
        if (instance == null) {
            instance = new Benutzerwerte();
        }
        return instance;
    }

    public static void main(String[] args) {
        Benutzerwerte benutzerwerte = new Benutzerwerte(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(benutzerwerte.ArgTab, benutzerwerte.ArgTabDefault, benutzerwerte.getHilfeText())) {
            try {
                benutzerwerte.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + benutzerwerte.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                benutzerwerte.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + benutzerwerte.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + benutzerwerte.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Benutzerwerte() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Benutzerwerte(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getExiftoolParameter() {
        return this.ExiftoolParameter;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getPapierkorb() {
        return this.Papierkorb;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getPfadtrennzeichen() {
        return this.Pfadtrennzeichen;
    }

    public String getRobocopyRsyncCopy() {
        return this.RobocopyRsyncCopy;
    }

    public String getRobocopyRsyncOrtName() {
        return this.RobocopyRsyncOrtName;
    }

    public String getRobocopyRsyncParameter() {
        return this.RobocopyRsyncParameter;
    }

    public String getRobocopyRsyncSync() {
        return this.RobocopyRsyncSync;
    }

    public String getRootVonPapierkorb() {
        return this.RootVonPapierkorb;
    }

    public String getStand() {
        return this.Stand;
    }

    public String getTrennzeichenCommandlineParameter() {
        return this.TrennzeichenCommandlineParameter;
    }

    public String getVerzeichnisGUIJavaSourcecode() {
        return this.VerzeichnisGUIJavaSourcecode;
    }

    public String getVerzeichnisJavaSourcecode() {
        return this.VerzeichnisJavaSourcecode;
    }

    public String getVerzeichnisJavaTest() {
        return this.VerzeichnisJavaTest;
    }

    public String[][] getWerte() {
        String[][] rc = new String[13][2];
        rc[0][0] = "Papierkorb";
        rc[0][1] = this.getPapierkorb();
        rc[1][0] = "RootVonPapierkorb";
        rc[1][1] = this.getRootVonPapierkorb();
        rc[2][0] = "TrennzeichenCommandlineParameter";
        rc[2][1] = this.getTrennzeichenCommandlineParameter();
        rc[3][0] = "Pfadtrennzeichen";
        rc[3][1] = this.getPfadtrennzeichen();
        rc[4][0] = "RobocopyRsyncOrtName";
        rc[4][1] = this.getRobocopyRsyncOrtName();
        rc[5][0] = "RobocopyRsyncParameter";
        rc[5][1] = this.getRobocopyRsyncParameter();
        rc[6][0] = "RobocopyRsyncCopy";
        rc[6][1] = this.getRobocopyRsyncCopy();
        rc[7][0] = "RobocopyRsyncSync";
        rc[7][1] = this.getRobocopyRsyncSync();
        rc[8][0] = "ExiftoolParameter";
        rc[8][1] = this.getExiftoolParameter();
        rc[9][0] = "Verzeichnis JavaSourcecode";
        rc[9][1] = this.getVerzeichnisJavaSourcecode();
        rc[10][0] = "Verzeichnis JavaTest";
        rc[10][1] = this.getVerzeichnisJavaTest();
        rc[11][0] = "Verzeichnis JavaSourcecodeGUI";
        rc[11][1] = this.getVerzeichnisGUIJavaSourcecode();
        return rc;
    }

    public boolean isResetWerte() {
        return this.ResetWerte;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isSpeichern() {
        return this.Speichern;
    }

    private void resetWerte() {
        this.setPapierkorb(Futi.getBenutzerWert("Papierkorb", true));
        this.setRootVonPapierkorb(Futi.getBenutzerWert("RootVonPapierkorb", true));
        this.setTrennzeichenCommandlineParameter(Futi.getBenutzerWert("Trennzeichen CommandlineParameter", true));
        this.setPfadtrennzeichen(Futi.getBenutzerWert("Pfadtrennzeichen als String", true));
        this.setRobocopyRsyncOrtName(Futi.getBenutzerWert("RobocopyRsyncOrtName", true));
        this.setRobocopyRsyncParameter(Futi.getBenutzerWert("RobocopyRsyncParameter", true));
        this.setRobocopyRsyncCopy(Futi.getBenutzerWert("RobocopyRsyncCopy", true));
        this.setRobocopyRsyncSync(Futi.getBenutzerWert("RobocopyRsyncSync", true));
        this.setExiftoolParameter(Futi.getBenutzerWert("ExiftoolParameter", true));
        this.setVerzeichnisJavaSourcecode(Futi.getBenutzerWert("Verzeichnis JavaSourcecode", true));
        this.setVerzeichnisJavaTest(Futi.getBenutzerWert("Verzeichnis JavaTest", true));
        this.setVerzeichnisGUIJavaSourcecode(Futi.getBenutzerWert("Verzeichnis JavaSourcecodeGUI", true));
        FProt.instance().prot("Benutzerwerte sind zurueckgesetzt auf:");
        FProt.instance().prot(FString.convertTabelleToStringArray(this.getWerte()));
    }

    public String[][] restoreWerte() {
        return FString.convertStringArrayToTabelle(new FFile(String.valueOf(FGUI.instance().getHistoriePfad()) + this.getClass().getSimpleName() + ".Werte.txt").inhaltToStringArray(), 2, false);
    }

    public void run() {
        if (this.isResetWerte()) {
            this.resetWerte();
        } else {
            this.setWerte();
        }
        if (this.isSpeichern()) {
            this.saveWerte();
        }
    }

    private void saveWerte() {
        new FFile(String.valueOf(FGUI.instance().getHistoriePfad()) + this.getClass().getSimpleName() + ".Werte.txt").StringArrayToInhalt(FString.convertTabelleToStringArray(this.getWerte()));
        FProt.instance().prot("Benutzerwerte in >" + FGUI.instance().getHistoriePfad() + this.getClass().getSimpleName() + ".Werte.txt< gespeichert!");
    }

    public void setExiftoolParameter() {
        this.ExiftoolParameter = FParam.getStringParameter("ExiftoolParameter", this.ArgTab);
    }

    public void setExiftoolParameter(String exiftoolParameter) {
        this.ExiftoolParameter = FParam.checkStringParameter("ExiftoolParameter", exiftoolParameter, this.ArgTab);
    }

    public void setPapierkorb() {
        this.Papierkorb = FParam.getStringParameter("Papierkorb", this.ArgTab);
    }

    public void setPapierkorb(String papierkorb) {
        this.Papierkorb = FParam.checkStringParameter("Papierkorb", papierkorb, this.ArgTab);
    }

    public void setPfadtrennzeichen() {
        this.Pfadtrennzeichen = FParam.getStringParameter("Pfadtrennzeichen", this.ArgTab);
    }

    public void setPfadtrennzeichen(String pfadtrennzeichen) {
        this.Pfadtrennzeichen = FParam.checkStringParameter("Pfadtrennzeichen", pfadtrennzeichen, this.ArgTab);
    }

    public void setResetWerte() {
        this.ResetWerte = FParam.getBooleanParameter("ResetWerte", this.ArgTab);
    }

    public void setResetWerte(boolean resetWerte) {
        this.ResetWerte = resetWerte;
    }

    public void setRobocopyRsyncCopy() {
        this.RobocopyRsyncCopy = FParam.getStringParameter("RobocopyRsyncCopy", this.ArgTab);
    }

    public void setRobocopyRsyncCopy(String robocopyRsyncCopy) {
        this.RobocopyRsyncCopy = FParam.checkStringParameter("RobocopyRsyncCopy", robocopyRsyncCopy, this.ArgTab);
    }

    public void setRobocopyRsyncOrtName() {
        this.RobocopyRsyncOrtName = FParam.getStringParameter("RobocopyRsyncOrtName", this.ArgTab);
    }

    public void setRobocopyRsyncOrtName(String robocopyRsyncOrtName) {
        this.RobocopyRsyncOrtName = FParam.checkStringParameter("RobocopyRsyncOrtName", robocopyRsyncOrtName, this.ArgTab);
    }

    public void setRobocopyRsyncParameter() {
        this.RobocopyRsyncParameter = FParam.getStringParameter("RobocopyRsyncParameter", this.ArgTab);
    }

    public void setRobocopyRsyncParameter(String robocopyRsyncParameter) {
        this.RobocopyRsyncParameter = FParam.checkStringParameter("RobocopyRsyncParameter", robocopyRsyncParameter, this.ArgTab);
    }

    public void setRobocopyRsyncSync() {
        this.RobocopyRsyncSync = FParam.getStringParameter("RobocopyRsyncSync", this.ArgTab);
    }

    public void setRobocopyRsyncSync(String robocopyRsyncSync) {
        this.RobocopyRsyncSync = FParam.checkStringParameter("RobocopyRsyncSync", robocopyRsyncSync, this.ArgTab);
    }

    public void setRootVonPapierkorb() {
        this.RootVonPapierkorb = FParam.getStringParameter("RootVonPapierkorb", this.ArgTab);
    }

    public void setRootVonPapierkorb(String rootVonPapierkorb) {
        this.RootVonPapierkorb = FParam.checkStringParameter("RootVonPapierkorb", rootVonPapierkorb, this.ArgTab);
    }

    public void setSpeichern() {
        this.Speichern = FParam.getBooleanParameter("Speichern", this.ArgTab);
    }

    public void setSpeichern(boolean speichern) {
        this.Speichern = speichern;
    }

    public void setTrennzeichenCommandlineParameter() {
        this.TrennzeichenCommandlineParameter = FParam.getStringParameter("TrennzeichenCommandlineParameter", this.ArgTab);
    }

    public void setTrennzeichenCommandlineParameter(String trennzeichenCommandlineParameter) {
        this.TrennzeichenCommandlineParameter = FParam.checkStringParameter("TrennzeichenCommandlineParameter", trennzeichenCommandlineParameter, this.ArgTab);
    }

    public void setVerzeichnisGUIJavaSourcecode() {
        this.VerzeichnisGUIJavaSourcecode = FParam.getStringParameter("VerzeichnisGUIJavaSourcecode", this.ArgTab);
    }

    public void setVerzeichnisGUIJavaSourcecode(String verzeichnisJavaSourcecodeGUI) {
        this.VerzeichnisGUIJavaSourcecode = FParam.checkStringParameter("VerzeichnisGUIJavaSourcecode", verzeichnisJavaSourcecodeGUI, this.ArgTab);
    }

    public void setVerzeichnisJavaSourcecode() {
        this.VerzeichnisJavaSourcecode = FParam.getStringParameter("VerzeichnisJavaSourcecode", this.ArgTab);
    }

    public void setVerzeichnisJavaSourcecode(String verzeichnisJavaSourcecode) {
        this.VerzeichnisJavaSourcecode = FParam.checkStringParameter("VerzeichnisJavaSourcecode", verzeichnisJavaSourcecode, this.ArgTab);
    }

    public void setVerzeichnisJavaTest() {
        this.VerzeichnisJavaTest = FParam.getStringParameter("VerzeichnisJavaTest", this.ArgTab);
    }

    public void setVerzeichnisJavaTest(String verzeichnisJavaTest) {
        this.VerzeichnisJavaTest = FParam.checkStringParameter("VerzeichnisJavaTest", verzeichnisJavaTest, this.ArgTab);
    }

    private void setWerte() {
        if (this.getPapierkorb().length() == 0) {
            this.setPapierkorb(Futi.getBenutzerWert("Papierkorb"));
        }
        if (this.getRootVonPapierkorb().length() == 0) {
            this.setRootVonPapierkorb(Futi.getBenutzerWert("RootVonPapierkorb"));
        }
        if (this.getTrennzeichenCommandlineParameter().length() == 0) {
            this.setTrennzeichenCommandlineParameter(Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
        }
        if (this.getPfadtrennzeichen().length() == 0) {
            this.setPfadtrennzeichen(Futi.getBenutzerWert("Pfadtrennzeichen als String"));
        }
        if (this.getRobocopyRsyncOrtName().length() == 0) {
            this.setRobocopyRsyncOrtName(Futi.getBenutzerWert("RobocopyRsyncOrtName"));
        }
        if (this.getRobocopyRsyncParameter().length() == 0) {
            this.setRobocopyRsyncParameter(Futi.getBenutzerWert("RobocopyRsyncParameter"));
        }
        if (this.getRobocopyRsyncCopy().length() == 0) {
            this.setRobocopyRsyncCopy(Futi.getBenutzerWert("RobocopyRsyncCopy"));
        }
        if (this.getRobocopyRsyncSync().length() == 0) {
            this.setRobocopyRsyncSync(Futi.getBenutzerWert("RobocopyRsynSync"));
        }
        if (this.getExiftoolParameter().length() == 0) {
            this.setExiftoolParameter(Futi.getBenutzerWert("ExiftoolParameter"));
        }
        if (this.getVerzeichnisJavaSourcecode().length() == 0) {
            this.setVerzeichnisJavaSourcecode(Futi.getBenutzerWert("Verzeichnis JavaSourcecode"));
        }
        if (this.getVerzeichnisJavaTest().length() == 0) {
            this.setVerzeichnisJavaTest(Futi.getBenutzerWert("Verzeichnis JavaTest"));
        }
        if (this.getVerzeichnisGUIJavaSourcecode().length() == 0) {
            this.setVerzeichnisGUIJavaSourcecode(Futi.getBenutzerWert("Verzeichnis JavaSourcecodeGUI"));
        }
        FProt.instance().prot("Folgende Benutzerwerte sind gesetzt:");
        FProt.instance().prot(FString.convertTabelleToStringArray(this.getWerte()));
    }

    public void setWerteAusArgTab() {
        this.setResetWerte();
        this.setSpeichern();
        this.setPapierkorb();
        this.setRootVonPapierkorb();
        this.setTrennzeichenCommandlineParameter();
        this.setPfadtrennzeichen();
        this.setRobocopyRsyncOrtName();
        this.setRobocopyRsyncParameter();
        this.setRobocopyRsyncCopy();
        this.setRobocopyRsyncSync();
        this.setExiftoolParameter();
        this.setVerzeichnisJavaSourcecode();
        this.setVerzeichnisJavaTest();
        this.setVerzeichnisGUIJavaSourcecode();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Benutzerwerte auf default zuruecksetzen                          :" + this.isResetWerte());
        fProt.prot("Benutzerwerte speichern                                          :" + this.isSpeichern());
        fProt.prot("Papierkorb Name                                                  :" + this.getPapierkorb());
        fProt.prot("Root von Papierkorb                                              :" + this.getRootVonPapierkorb());
        fProt.prot("Trennzeichen Commandline-Parameter                               :" + this.getTrennzeichenCommandlineParameter());
        fProt.prot("Pfadtrennzeichen                                                 :" + this.getPfadtrennzeichen());
        fProt.prot("Robocopy oder Rsync Ort und Name                                 :" + this.getRobocopyRsyncOrtName());
        fProt.prot("Standardparameter fuer Aufruf Robocopy oder Rsync                :" + this.getRobocopyRsyncParameter());
        fProt.prot("Parameter fuer Copy Verzeichnisse fuer Aufruf Robocopy oder Rsync:" + this.getRobocopyRsyncCopy());
        fProt.prot("Parameter fuer Sync Verzeichnisse fuer Aufruf Robocopy oder Rsync:" + this.getRobocopyRsyncSync());
        fProt.prot("Standardparameter fuer Aufruf Exiftool                           :" + this.getExiftoolParameter());
        fProt.prot("Verzeichnis JavaSourcecode                                       :" + this.getVerzeichnisJavaSourcecode());
        fProt.prot("Verzeichnis JavaTest                                             :" + this.getVerzeichnisJavaTest());
        fProt.prot("Verzeichnis JavaSourcecodeGUI                                    :" + this.getVerzeichnisGUIJavaSourcecode());
    }
}

