/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Date;

public class Assets {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String DBName;
    private String Tabelle;
    private String Where;
    private String Funktion;
    private boolean NeuBerechnen;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean Test;
    private final String Stand = "23.4.2009";

    public static void main(String[] args) {
        Assets assets = new Assets(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(assets.ArgTab, assets.ArgTabDefault, assets.getHilfeText())) {
            try {
                assets.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + assets.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                assets.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + assets.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + assets.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Assets() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Assets(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public long checkWert(String Key2, String lastKey, long Wert, long Umsatz, long calcWert_in, String Name, String Buchungstag, String Feld, ResultSet rs) throws SQLException {
        boolean Gruppenwechsel;
        FProt fProt = FProt.instance();
        long calcWert = calcWert_in;
        long returnWert = calcWert_in;
        if (Key2.compareToIgnoreCase(lastKey) != 0) {
            calcWert = Umsatz;
            Gruppenwechsel = true;
        } else {
            calcWert += Umsatz;
            Gruppenwechsel = false;
        }
        if (Feld.compareToIgnoreCase("WertGruppe") == 0 || Feld.compareToIgnoreCase("WertObergruppe") == 0) {
            fProt.prot("CHK:" + Name + " - " + Buchungstag + " - " + (double)Umsatz / 100.0 + " - " + (double)calcWert_in / 100.0 + " - GW: " + Gruppenwechsel + " - " + Feld + ": " + Key2 + " alt: " + (double)Wert / 100.0 + " => neu: " + (double)calcWert / 100.0, 5);
        } else {
            fProt.prot("CHK:" + Name + " - " + Buchungstag + " - " + (double)Umsatz / 100.0 + " - " + (double)calcWert_in / 100.0 + " - GW: " + Gruppenwechsel + " - " + Feld + " alt: " + (double)Wert / 100.0 + " => neu: " + (double)calcWert / 100.0, 5);
        }
        if (Wert != calcWert && (Wert == 0L || this.isNeuBerechnen())) {
            if (!this.isTest()) {
                rs.updateDouble(Feld, (double)calcWert / 100.0);
                rs.updateRow();
            }
            if (Feld.compareToIgnoreCase("WertGruppe") == 0 || Feld.compareToIgnoreCase("WertObergruppe") == 0) {
                fProt.prot("UPD:" + Name + " - " + Buchungstag + " - " + (double)Umsatz / 100.0 + " - GW: " + Gruppenwechsel + " - " + Feld + ": " + Key2 + " alt: " + (double)Wert / 100.0 + " => neu: " + (double)calcWert / 100.0, 0);
            } else {
                fProt.prot("UPD:" + Name + " - " + Buchungstag + " - " + (double)Umsatz / 100.0 + " - GW: " + Gruppenwechsel + " - " + Feld + " alt: " + (double)Wert / 100.0 + " => neu: " + (double)calcWert / 100.0, 0);
            }
            returnWert = calcWert;
        } else {
            returnWert = Wert;
        }
        return returnWert;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "23.4.2009";
    }

    public String getTabelle() {
        return this.Tabelle;
    }

    public String getWhere() {
        return this.Where;
    }

    public boolean isNeuBerechnen() {
        return this.NeuBerechnen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTest() {
        return this.Test;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        String Key2 = "";
        String lastKey = "";
        long calcUmsatz = 0L;
        long calcWert = 0L;
        long lastWert = 0L;
        double lastWertDruck = 0.0;
        String WhereString = "";
        String sqlStatement = "";
        Statement DBStatement = FDB.createDBStatement(this.getDBName(), 1004, 1008);
        sqlStatement = "SELECT Name, Buchungstag, Verwendungszweck, Umsatz, Wert, Gruppe, WertGruppe, Obergruppe FROM " + fDB.getName4Query(this.getTabelle());
        if (this.getWhere().length() > 0) {
            WhereString = "And " + this.getWhere();
        }
        switch (this.getFunktion().charAt(0)) {
            case 'G': {
                sqlStatement = String.valueOf(sqlStatement) + " Where Gruppe >'' " + WhereString + " Order by Gruppe, Buchungstag, Verwendungszweck, Umsatz";
                break;
            }
            default: {
                sqlStatement = this.getWhere().length() > 0 ? String.valueOf(sqlStatement) + " Where " + this.getWhere() + " Order by Name, Buchungstag, Wertstellungstag, Verwendungszweck, Umsatz" : String.valueOf(sqlStatement) + " Order by Name, Buchungstag, Wertstellungstag, Verwendungszweck, Umsatz";
            }
        }
        fProt.prot("SQL-Statement gegen ACCESS-DB " + this.getDBName() + " : " + sqlStatement);
        ResultSet rs = FDB.executeQuery(DBStatement, sqlStatement);
        try {
            while (rs.next()) {
                String Name = rs.getString("Name").trim();
                java.sql.Date Buchungstag = rs.getDate("Buchungstag");
                String Verwendungszweck = rs.getString("Verwendungszweck").trim();
                long Umsatz = Math.round(rs.getDouble("Umsatz") * 100.0);
                long Wert = Math.round(rs.getDouble("Wert") * 100.0);
                rs.getString("Gruppe");
                String Gruppe = rs.wasNull() ? "" : rs.getString("Gruppe").trim();
                long WertGruppe = Math.round(rs.getDouble("WertGruppe") * 100.0);
                rs.getString("Obergruppe");
                String Obergruppe = rs.wasNull() ? "" : rs.getString("Obergruppe").trim();
                fProt.prot(String.valueOf(Name) + " - " + ((Date)Buchungstag).toString() + " - " + Umsatz + " - " + Wert + " - " + Gruppe + " - " + WertGruppe + " - " + Obergruppe + " - " + Verwendungszweck, 8);
                switch (this.getFunktion().charAt(0)) {
                    case 'W': {
                        Key2 = Name;
                        calcWert = this.checkWert(Key2, lastKey, Wert, Umsatz, calcWert, Name, ((Date)Buchungstag).toString(), "Wert", rs);
                        break;
                    }
                    case 'G': {
                        Key2 = Gruppe;
                        calcWert = this.checkWert(Key2, lastKey, WertGruppe, Umsatz, calcWert, Name, ((Date)Buchungstag).toString(), "WertGruppe", rs);
                        break;
                    }
                    case 'U': {
                        boolean Gruppenwechsel;
                        Key2 = Name;
                        lastWertDruck = (double)lastWert / 100.0;
                        if (Key2.compareToIgnoreCase(lastKey) != 0) {
                            calcUmsatz = Wert;
                            Gruppenwechsel = true;
                        } else {
                            calcUmsatz = Wert - lastWert;
                            Gruppenwechsel = false;
                        }
                        lastWert = Wert;
                        fProt.prot("CHK:" + Name + " - " + ((Date)Buchungstag).toString() + " - " + lastWertDruck + " - " + (double)Wert / 100.0 + " - GW: " + Gruppenwechsel + " - " + " - Umsatz alt:" + (double)Umsatz / 100.0 + " => neu:" + (double)calcUmsatz / 100.0, 5);
                        if (Umsatz == calcUmsatz || Umsatz != 0L) break;
                        if (!this.isTest()) {
                            rs.updateDouble("Umsatz", (double)calcUmsatz / 100.0);
                            rs.updateRow();
                        }
                        fProt.prot("UPD:" + Name + " - " + ((Date)Buchungstag).toString() + " - " + lastWertDruck + " - " + (double)Wert / 100.0 + " - GW: " + Gruppenwechsel + " - " + " - Umsatz alt:" + (double)Umsatz / 100.0 + " => neu:" + (double)calcUmsatz / 100.0, 0);
                        break;
                    }
                }
                lastKey = Key2;
            }
            FDB.closeDBStatement(DBStatement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setNeuBerechnen() {
        this.NeuBerechnen = FParam.getBooleanParameter("NeuBerechnen", this.ArgTab);
    }

    public void setNeuBerechnen(boolean neuBerechnen) {
        this.NeuBerechnen = neuBerechnen;
    }

    public void setTabelle() {
        this.Tabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.Tabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setTest() {
        this.Test = FParam.getBooleanParameter("Test", this.ArgTab);
    }

    public void setTest(boolean test) {
        this.Test = test;
    }

    public void setWerteAusArgTab() {
        this.setDBName();
        this.setTabelle();
        this.setWhere();
        this.setFunktion();
        this.setNeuBerechnen();
        this.setTest();
    }

    public void setWhere() {
        this.Where = FParam.getStringParameter("Where", this.ArgTab);
    }

    public void setWhere(String where) {
        FParam.instance();
        this.Where = FParam.checkStringParameter("Where", where, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Name der Datenbank                            :" + this.getDBName());
        fProt.prot("Name der Tabelle                              :" + this.getTabelle());
        fProt.prot("(weitere) Bedingung(en) zur Auswahl von Zeilen:" + this.getWhere());
        fProt.prot("Funktion                                      :" + this.getFunktion());
        fProt.prot("Neuberechnen in jedem Fall (ausser bei Umsatz):" + this.isNeuBerechnen());
        fProt.prot("kein Update, nur Test                         :" + this.isTest());
    }
}

