/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class Ablage {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = false;
    private String[][] ArgTab;
    private final String Stand = "9.10.2009";
    private String DBName;
    private String AblageTabelle;
    private String SchlagwortTabelle;
    private String SchlagwortAusnahmenTabelle;
    private boolean Schlagworte_loeschen;

    public static void main(String[] args) {
        Ablage ablage = new Ablage(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(ablage.ArgTab, ablage.ArgTabDefault, ablage.getHilfeText())) {
            try {
                ablage.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + ablage.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                ablage.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + ablage.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + ablage.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Ablage() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Ablage(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public void fillSchlagworte(HashMap<String, Integer> Werte, HashMap<String, Integer> Ausnahmen) {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        String Einlage = "";
        String Schlagwort = "";
        Statement DBStatement = FDB.createDBStatement(this.getDBName());
        if (DBStatement != null) {
            ResultSet rs;
            if (!this.isSchlagworte_loeschen()) {
                rs = FDB.executeQuery(DBStatement, "SELECT OrdnerNr, Einlage, Schlagwort FROM " + fDB.getName4Query(this.getSchlagwortTabelle()));
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            int OrdnerNr = rs.getInt("OrdnerNr");
                            Einlage = rs.getString("Einlage").trim();
                            Schlagwort = rs.getString("Schlagwort").trim();
                            fProt.prot(String.valueOf(OrdnerNr) + "\t" + Einlage + "\t" + Schlagwort, 2);
                            Werte.put(String.valueOf(OrdnerNr) + "\t" + Einlage + "\t" + Schlagwort, new Integer(1));
                        }
                    }
                    catch (SQLException SQLe) {
                        FDB.handleException(SQLe);
                    }
                }
            } else {
                FDB.executeUpdate(DBStatement, "DELETE * FROM " + fDB.getName4Query(this.getSchlagwortTabelle()));
            }
            if ((rs = FDB.executeQuery(DBStatement, "SELECT Schlagwort FROM " + fDB.getName4Query(this.getSchlagwortAusnahmenTabelle()))) != null) {
                try {
                    while (rs.next()) {
                        Schlagwort = rs.getString("Schlagwort").trim();
                        fProt.prot(Schlagwort, 2);
                        Ausnahmen.put(Schlagwort, new Integer(1));
                    }
                }
                catch (SQLException SQLe) {
                    FDB.handleException(SQLe);
                }
            }
            FDB.closeDBStatement(DBStatement);
        }
    }

    public String getAblageTabelle() {
        return this.AblageTabelle;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getSchlagwortAusnahmenTabelle() {
        return this.SchlagwortAusnahmenTabelle;
    }

    public String getSchlagwortTabelle() {
        return this.SchlagwortTabelle;
    }

    public String getStand() {
        return "9.10.2009";
    }

    public boolean isSchlagworte_loeschen() {
        return this.Schlagworte_loeschen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        String Inhalt = "";
        String Einlage = "";
        String Beschreibung = "";
        String Schlagwort = "";
        HashMap<String, Integer> Werte = new HashMap<String, Integer>();
        HashMap<String, Integer> Ausnahmen = new HashMap<String, Integer>();
        ArrayList<String> Array2 = new ArrayList<String>();
        this.fillSchlagworte(Werte, Ausnahmen);
        Statement DBStatement = FDB.createDBStatement(this.getDBName());
        if (DBStatement != null) {
            ResultSet rs = FDB.executeQuery(DBStatement, "SELECT Nr, Inhalt, Einlage, Beschreibung FROM " + fDB.getName4Query(this.getAblageTabelle()));
            if (rs != null) {
                int i;
                try {
                    while (rs.next()) {
                        int OrdnerNr = rs.getInt("Nr");
                        Inhalt = rs.getString("Inhalt");
                        Inhalt = Inhalt == null ? "" : FDB.replaceSonderzeichen(Inhalt.trim());
                        Einlage = rs.getString("Einlage");
                        Einlage = Einlage == null ? "" : Einlage.trim();
                        Beschreibung = rs.getString("Beschreibung");
                        Beschreibung = Beschreibung == null ? "" : FDB.replaceSonderzeichen(Beschreibung.trim());
                        String[] Teile = FString.verbindenStringArray(FString.deleteDoppelte(Inhalt.split(" "), 2), FString.deleteDoppelte(Beschreibung.split(" "), 2));
                        fProt.prot(Teile, 3);
                        i = 0;
                        while (i < Teile.length) {
                            Schlagwort = Teile[i].trim();
                            if (Schlagwort.length() > 0) {
                                fProt.prot(String.valueOf(OrdnerNr) + " " + Einlage + " " + Schlagwort, 2);
                                if (Ausnahmen.get(Schlagwort) == null && Werte.get(String.valueOf(OrdnerNr) + "\t" + Einlage + "\t" + Schlagwort) == null) {
                                    Werte.put(String.valueOf(OrdnerNr) + "\t" + Einlage + "\t" + Schlagwort, new Integer(1));
                                    fProt.prot(String.valueOf(OrdnerNr) + "\t" + Einlage + "\t" + Schlagwort + " insert", 2);
                                    Array2.add("INSERT INTO " + fDB.getName4Query(this.getSchlagwortTabelle()) + " (OrdnerNr, Einlage, Schlagwort) VALUES (" + OrdnerNr + ", '" + Einlage + "', '" + Schlagwort.replace("'", "''") + "')");
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (SQLException SQLe) {
                    FDB.handleException(SQLe);
                }
                if (Array2.size() > 0) {
                    Array2.add("DELETE * FROM " + fDB.getName4Query(this.getSchlagwortTabelle()) + " WHERE Schlagwort In (SELECT * FROM " + fDB.getName4Query(this.getSchlagwortAusnahmenTabelle()) + ")");
                    i = 0;
                    while (i < Array2.size()) {
                        FDB.executeUpdate(DBStatement, (String)Array2.get(i), true, 2);
                        ++i;
                    }
                    fProt.prot(String.valueOf(Array2.size() - 1) + " Schlagworte neu eingefuegt");
                } else {
                    fProt.prot("keine Schlagworte neu eingefuegt");
                }
            }
            FDB.closeDBStatement(DBStatement);
        }
    }

    public void setAblageTabelle() {
        this.AblageTabelle = FParam.getStringParameter("AblageTabelle", this.ArgTab);
    }

    public void setAblageTabelle(String ablageTabelle) {
        FParam.instance();
        this.AblageTabelle = FParam.checkStringParameter("AblageTabelle", ablageTabelle, this.ArgTab);
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setSchlagwortAusnahmenTabelle() {
        this.SchlagwortAusnahmenTabelle = FParam.getStringParameter("SchlagwortAusnahmenTabelle", this.ArgTab);
    }

    public void setSchlagwortAusnahmenTabelle(String schlagwortAusnahmenTabelle) {
        this.SchlagwortAusnahmenTabelle = FParam.checkStringParameter("SchlagwortAusnahmenTabelle", schlagwortAusnahmenTabelle, this.ArgTab);
    }

    public void setSchlagworte_loeschen() {
        this.Schlagworte_loeschen = FParam.getBooleanParameter("Schlagworte_loeschen", this.ArgTab);
    }

    public void setSchlagworte_loeschen(boolean schlagworte_loeschen) {
        this.Schlagworte_loeschen = schlagworte_loeschen;
    }

    public void setSchlagwortTabelle() {
        this.SchlagwortTabelle = FParam.getStringParameter("SchlagwortTabelle", this.ArgTab);
    }

    public void setSchlagwortTabelle(String schlagwortTabelle) {
        FParam.instance();
        this.SchlagwortTabelle = FParam.checkStringParameter("SchlagwortTabelle", schlagwortTabelle, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setDBName();
        this.setAblageTabelle();
        this.setSchlagwortTabelle();
        this.setSchlagwortAusnahmenTabelle();
        this.setSchlagworte_loeschen();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("DBName                                     :" + this.getDBName());
        fProt.prot("Name der Tabelle mit Ablagen               :" + this.getAblageTabelle());
        fProt.prot("Name der Tabelle mit Schlagworten          :" + this.getSchlagwortTabelle());
        fProt.prot("Name der Tabelle unbedeutenden Schlagworten:" + this.getSchlagwortAusnahmenTabelle());
        fProt.prot("Schlagworte loeschen                       :" + this.isSchlagworte_loeschen());
    }
}

