/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.xmp.XmpDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpDescriptor
extends TagDescriptor<XmpDirectory> {
    public XmpDescriptor(@NotNull XmpDirectory xmpDirectory) {
        super(xmpDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return ((XmpDirectory)this._directory).getString(n);
            }
            case 3: {
                return this.getExposureTimeDescription();
            }
            case 12: {
                return this.getExposureProgramDescription();
            }
            case 4: {
                return this.getShutterSpeedDescription();
            }
            case 5: {
                return this.getFNumberDescription();
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ((XmpDirectory)this._directory).getString(n);
            }
            case 10: {
                return this.getFocalLengthDescription();
            }
            case 11: {
                return this.getApertureValueDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getExposureTimeDescription() {
        String string = ((XmpDirectory)this._directory).getString(3);
        if (string == null) {
            return null;
        }
        return string + " sec";
    }

    @Nullable
    public String getExposureProgramDescription() {
        return this.getIndexedDescription(12, 1, "Manual control", "Program normal", "Aperture priority", "Shutter priority", "Program creative (slow program)", "Program action (high-speed program)", "Portrait mode", "Landscape mode");
    }

    @Nullable
    public String getShutterSpeedDescription() {
        Float f = ((XmpDirectory)this._directory).getFloatObject(4);
        if (f == null) {
            return null;
        }
        if (f.floatValue() <= 1.0f) {
            float f2 = (float)(1.0 / Math.exp((double)f.floatValue() * Math.log(2.0)));
            long l = Math.round((double)f2 * 10.0);
            float f3 = (float)l / 10.0f;
            return f3 + " sec";
        }
        int n = (int)Math.exp((double)f.floatValue() * Math.log(2.0));
        return "1/" + n + " sec";
    }

    @Nullable
    public String getFNumberDescription() {
        Rational rational = ((XmpDirectory)this._directory).getRational(5);
        if (rational == null) {
            return null;
        }
        return XmpDescriptor.getFStopDescription(rational.doubleValue());
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational rational = ((XmpDirectory)this._directory).getRational(10);
        return rational == null ? null : XmpDescriptor.getFocalLengthDescription(rational.doubleValue());
    }

    @Nullable
    public String getApertureValueDescription() {
        Double d = ((XmpDirectory)this._directory).getDoubleObject(11);
        if (d == null) {
            return null;
        }
        double d2 = PhotographicConversions.apertureToFStop(d);
        return XmpDescriptor.getFStopDescription(d2);
    }
}

