/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.pcx;

import com.drew.imaging.ImageProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.pcx.PcxDirectory;

public class PcxReader {
    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        sequentialReader.setMotorolaByteOrder(false);
        PcxDirectory pcxDirectory = new PcxDirectory();
        metadata.addDirectory(pcxDirectory);
        try {
            int n;
            int n2;
            byte by = sequentialReader.getInt8();
            if (by != 10) {
                throw new ImageProcessingException("Invalid PCX identifier byte");
            }
            pcxDirectory.setInt(1, sequentialReader.getInt8());
            byte by2 = sequentialReader.getInt8();
            if (by2 != 1) {
                throw new ImageProcessingException("Invalid PCX encoding byte");
            }
            pcxDirectory.setInt(2, sequentialReader.getUInt8());
            pcxDirectory.setInt(3, sequentialReader.getUInt16());
            pcxDirectory.setInt(4, sequentialReader.getUInt16());
            pcxDirectory.setInt(5, sequentialReader.getUInt16());
            pcxDirectory.setInt(6, sequentialReader.getUInt16());
            pcxDirectory.setInt(7, sequentialReader.getUInt16());
            pcxDirectory.setInt(8, sequentialReader.getUInt16());
            pcxDirectory.setByteArray(9, sequentialReader.getBytes(48));
            sequentialReader.skip(1L);
            pcxDirectory.setInt(10, sequentialReader.getUInt8());
            pcxDirectory.setInt(11, sequentialReader.getUInt16());
            int n3 = sequentialReader.getUInt16();
            if (n3 != 0) {
                pcxDirectory.setInt(12, n3);
            }
            if ((n2 = sequentialReader.getUInt16()) != 0) {
                pcxDirectory.setInt(13, n2);
            }
            if ((n = sequentialReader.getUInt16()) != 0) {
                pcxDirectory.setInt(14, n);
            }
        }
        catch (Exception exception) {
            pcxDirectory.addError("Exception reading PCX file metadata: " + exception.getMessage());
        }
    }
}

