/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.SOF0, JpegSegmentType.SOF1, JpegSegmentType.SOF2, JpegSegmentType.SOF3, JpegSegmentType.SOF5, JpegSegmentType.SOF6, JpegSegmentType.SOF7, JpegSegmentType.SOF8, JpegSegmentType.SOF9, JpegSegmentType.SOF10, JpegSegmentType.SOF11, JpegSegmentType.SOF13, JpegSegmentType.SOF14, JpegSegmentType.SOF15);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        for (byte[] byArray : iterable) {
            this.extract(byArray, metadata, jpegSegmentType);
        }
    }

    public void extract(byte[] byArray, Metadata metadata, JpegSegmentType jpegSegmentType) {
        JpegDirectory jpegDirectory = new JpegDirectory();
        metadata.addDirectory(jpegDirectory);
        jpegDirectory.setInt(-3, jpegSegmentType.byteValue - JpegSegmentType.SOF0.byteValue);
        SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
        try {
            jpegDirectory.setInt(0, sequentialByteArrayReader.getUInt8());
            jpegDirectory.setInt(1, sequentialByteArrayReader.getUInt16());
            jpegDirectory.setInt(3, sequentialByteArrayReader.getUInt16());
            int n = sequentialByteArrayReader.getUInt8();
            jpegDirectory.setInt(5, n);
            for (int i = 0; i < n; ++i) {
                short s = sequentialByteArrayReader.getUInt8();
                short s2 = sequentialByteArrayReader.getUInt8();
                short s3 = sequentialByteArrayReader.getUInt8();
                JpegComponent jpegComponent = new JpegComponent(s, s2, s3);
                jpegDirectory.setObject(6 + i, jpegComponent);
            }
        }
        catch (IOException iOException) {
            jpegDirectory.addError(iOException.getMessage());
        }
    }
}

