/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.ico;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.ico.IcoDirectory;
import java.io.IOException;

public class IcoReader {
    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        int n;
        int n2;
        int n3;
        sequentialReader.setMotorolaByteOrder(false);
        try {
            n3 = sequentialReader.getUInt16();
            if (n3 != 0) {
                IcoDirectory icoDirectory = new IcoDirectory();
                icoDirectory.addError("Invalid header bytes");
                metadata.addDirectory(icoDirectory);
                return;
            }
            n2 = sequentialReader.getUInt16();
            if (n2 != 1 && n2 != 2) {
                IcoDirectory icoDirectory = new IcoDirectory();
                icoDirectory.addError("Invalid type " + n2 + " -- expecting 1 or 2");
                metadata.addDirectory(icoDirectory);
                return;
            }
            n = sequentialReader.getUInt16();
            if (n == 0) {
                IcoDirectory icoDirectory = new IcoDirectory();
                icoDirectory.addError("Image count cannot be zero");
                metadata.addDirectory(icoDirectory);
                return;
            }
        }
        catch (IOException iOException) {
            IcoDirectory icoDirectory = new IcoDirectory();
            icoDirectory.addError("Exception reading ICO file metadata: " + iOException.getMessage());
            metadata.addDirectory(icoDirectory);
            return;
        }
        for (n3 = 0; n3 < n; ++n3) {
            IcoDirectory icoDirectory = new IcoDirectory();
            try {
                icoDirectory.setInt(1, n2);
                icoDirectory.setInt(2, sequentialReader.getUInt8());
                icoDirectory.setInt(3, sequentialReader.getUInt8());
                icoDirectory.setInt(4, sequentialReader.getUInt8());
                sequentialReader.getUInt8();
                if (n2 == 1) {
                    icoDirectory.setInt(5, sequentialReader.getUInt16());
                    icoDirectory.setInt(7, sequentialReader.getUInt16());
                } else {
                    icoDirectory.setInt(6, sequentialReader.getUInt16());
                    icoDirectory.setInt(8, sequentialReader.getUInt16());
                }
                icoDirectory.setLong(9, sequentialReader.getUInt32());
                icoDirectory.setLong(10, sequentialReader.getUInt32());
            }
            catch (IOException iOException) {
                assert (icoDirectory != null);
                icoDirectory.addError("Exception reading ICO file metadata: " + iOException.getMessage());
            }
            metadata.addDirectory(icoDirectory);
        }
    }
}

