/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.gif;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.gif.GifHeaderDirectory;
import java.io.IOException;

public class GifReader {
    private static final String GIF_87A_VERSION_IDENTIFIER = "87a";
    private static final String GIF_89A_VERSION_IDENTIFIER = "89a";

    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        GifHeaderDirectory gifHeaderDirectory = new GifHeaderDirectory();
        metadata.addDirectory(gifHeaderDirectory);
        sequentialReader.setMotorolaByteOrder(false);
        try {
            int n;
            String string = sequentialReader.getString(3);
            if (!string.equals("GIF")) {
                gifHeaderDirectory.addError("Invalid GIF file signature");
                return;
            }
            String string2 = sequentialReader.getString(3);
            if (!string2.equals(GIF_87A_VERSION_IDENTIFIER) && !string2.equals(GIF_89A_VERSION_IDENTIFIER)) {
                gifHeaderDirectory.addError("Unexpected GIF version");
                return;
            }
            gifHeaderDirectory.setString(1, string2);
            gifHeaderDirectory.setInt(2, sequentialReader.getUInt16());
            gifHeaderDirectory.setInt(3, sequentialReader.getUInt16());
            short s = sequentialReader.getUInt8();
            int n2 = 1 << (s & 7) + 1;
            gifHeaderDirectory.setInt(4, n2);
            if (string2.equals(GIF_89A_VERSION_IDENTIFIER)) {
                n = (s & 8) != 0 ? 1 : 0;
                gifHeaderDirectory.setBoolean(5, n != 0);
            }
            n = ((s & 0x70) >> 4) + 1;
            gifHeaderDirectory.setInt(6, n);
            boolean bl = (s & 0xF) != 0;
            gifHeaderDirectory.setBoolean(7, bl);
            gifHeaderDirectory.setInt(8, sequentialReader.getUInt8());
            short s2 = sequentialReader.getUInt8();
            if (s2 != 0) {
                float f = (float)(((double)s2 + 15.0) / 64.0);
                gifHeaderDirectory.setFloat(9, f);
            }
        }
        catch (IOException iOException) {
            gifHeaderDirectory.addError("Unable to read BMP header");
        }
    }
}

