/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.TagDescriptor;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExifDescriptorBase<T extends Directory>
extends TagDescriptor<T> {
    private final boolean _allowDecimalRepresentationOfRationals = true;
    @NotNull
    private static final DecimalFormat SimpleDecimalFormatter = new DecimalFormat("0.#");

    public ExifDescriptorBase(@NotNull T t) {
        super(t);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getInteropIndexDescription();
            }
            case 2: {
                return this.getInteropVersionDescription();
            }
            case 274: {
                return this.getOrientationDescription();
            }
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 256: {
                return this.getImageWidthDescription();
            }
            case 257: {
                return this.getImageHeightDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 40093: {
                return this.getWindowsAuthorDescription();
            }
            case 40092: {
                return this.getWindowsCommentDescription();
            }
            case 40094: {
                return this.getWindowsKeywordsDescription();
            }
            case 40095: {
                return this.getWindowsSubjectDescription();
            }
            case 40091: {
                return this.getWindowsTitleDescription();
            }
            case 254: {
                return this.getNewSubfileTypeDescription();
            }
            case 255: {
                return this.getSubfileTypeDescription();
            }
            case 263: {
                return this.getThresholdingDescription();
            }
            case 266: {
                return this.getFillOrderDescription();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 37122: {
                return this.getCompressedAverageBitsPerPixelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 37510: {
                return this.getUserCommentDescription();
            }
            case 41985: {
                return this.getCustomRenderedDescription();
            }
            case 41986: {
                return this.getExposureModeDescription();
            }
            case 41987: {
                return this.getWhiteBalanceModeDescription();
            }
            case 41988: {
                return this.getDigitalZoomRatioDescription();
            }
            case 41989: {
                return this.get35mmFilmEquivFocalLengthDescription();
            }
            case 41990: {
                return this.getSceneCaptureTypeDescription();
            }
            case 41991: {
                return this.getGainControlDescription();
            }
            case 41992: {
                return this.getContrastDescription();
            }
            case 41993: {
                return this.getSaturationDescription();
            }
            case 41994: {
                return this.getSharpnessDescription();
            }
            case 41996: {
                return this.getSubjectDistanceRangeDescription();
            }
            case 34864: {
                return this.getSensitivityTypeRangeDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
            case 512: {
                return this.getJpegProcDescription();
            }
            case 42034: {
                return this.getLensSpecificationDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getInteropVersionDescription() {
        return this.getVersionBytesDescription(2, 2);
    }

    @Nullable
    public String getInteropIndexDescription() {
        String string = this._directory.getString(1);
        if (string == null) {
            return null;
        }
        return "R98".equalsIgnoreCase(string.trim()) ? "Recommended Exif Interoperability Rules (ExifR98)" : "Unknown (" + string + ")";
    }

    @Nullable
    public String getReferenceBlackWhiteDescription() {
        int[] nArray = this._directory.getIntArray(532);
        if (nArray == null || nArray.length < 6) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        return String.format("[%d,%d,%d] [%d,%d,%d]", n, n3, n5, n2, n4, n6);
    }

    @Nullable
    public String getYResolutionDescription() {
        Rational rational = this._directory.getRational(283);
        if (rational == null) {
            return null;
        }
        String string = this.getResolutionDescription();
        return String.format("%s dots per %s", rational.toSimpleString(true), string == null ? "unit" : string.toLowerCase());
    }

    @Nullable
    public String getXResolutionDescription() {
        Rational rational = this._directory.getRational(282);
        if (rational == null) {
            return null;
        }
        String string = this.getResolutionDescription();
        return String.format("%s dots per %s", rational.toSimpleString(true), string == null ? "unit" : string.toLowerCase());
    }

    @Nullable
    public String getYCbCrPositioningDescription() {
        return this.getIndexedDescription(531, 1, "Center of pixel array", "Datum point");
    }

    @Nullable
    public String getOrientationDescription() {
        return this.getIndexedDescription(274, 1, "Top, left side (Horizontal / normal)", "Top, right side (Mirror horizontal)", "Bottom, right side (Rotate 180)", "Bottom, left side (Mirror vertical)", "Left side, top (Mirror horizontal and rotate 270 CW)", "Right side, top (Rotate 90 CW)", "Right side, bottom (Mirror horizontal and rotate 90 CW)", "Left side, bottom (Rotate 270 CW)");
    }

    @Nullable
    public String getResolutionDescription() {
        return this.getIndexedDescription(296, 1, "(No unit)", "Inch", "cm");
    }

    @Nullable
    private String getUnicodeDescription(int n) {
        byte[] byArray = this._directory.getByteArray(n);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Nullable
    public String getWindowsAuthorDescription() {
        return this.getUnicodeDescription(40093);
    }

    @Nullable
    public String getWindowsCommentDescription() {
        return this.getUnicodeDescription(40092);
    }

    @Nullable
    public String getWindowsKeywordsDescription() {
        return this.getUnicodeDescription(40094);
    }

    @Nullable
    public String getWindowsTitleDescription() {
        return this.getUnicodeDescription(40091);
    }

    @Nullable
    public String getWindowsSubjectDescription() {
        return this.getUnicodeDescription(40095);
    }

    @Nullable
    public String getYCbCrSubsamplingDescription() {
        int[] nArray = this._directory.getIntArray(530);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        if (nArray[0] == 2 && nArray[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (nArray[0] == 2 && nArray[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    @Nullable
    public String getPlanarConfigurationDescription() {
        return this.getIndexedDescription(284, 1, "Chunky (contiguous for each subsampling pixel)", "Separate (Y-plane/Cb-plane/Cr-plane format)");
    }

    @Nullable
    public String getSamplesPerPixelDescription() {
        String string = this._directory.getString(277);
        return string == null ? null : string + " samples/pixel";
    }

    @Nullable
    public String getRowsPerStripDescription() {
        String string = this._directory.getString(278);
        return string == null ? null : string + " rows/strip";
    }

    @Nullable
    public String getStripByteCountsDescription() {
        String string = this._directory.getString(279);
        return string == null ? null : string + " bytes";
    }

    @Nullable
    public String getPhotometricInterpretationDescription() {
        Integer n = this._directory.getInteger(262);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "RGB Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "Color Filter Array";
            }
            case 32844: {
                return "Pixar LogL";
            }
            case 32845: {
                return "Pixar LogLuv";
            }
            case 32892: {
                return "Linear Raw";
            }
        }
        return "Unknown colour space";
    }

    @Nullable
    public String getBitsPerSampleDescription() {
        String string = this._directory.getString(258);
        return string == null ? null : string + " bits/component/pixel";
    }

    @Nullable
    public String getImageWidthDescription() {
        String string = this._directory.getString(256);
        return string == null ? null : string + " pixels";
    }

    @Nullable
    public String getImageHeightDescription() {
        String string = this._directory.getString(257);
        return string == null ? null : string + " pixels";
    }

    @Nullable
    public String getNewSubfileTypeDescription() {
        return this.getIndexedDescription(254, 1, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page reduced-resolution image", "Transparency mask", "Transparency mask of reduced-resolution image", "Transparency mask of multi-page image", "Transparency mask of reduced-resolution multi-page image");
    }

    @Nullable
    public String getSubfileTypeDescription() {
        return this.getIndexedDescription(255, 1, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page image");
    }

    @Nullable
    public String getThresholdingDescription() {
        return this.getIndexedDescription(263, 1, "No dithering or halftoning", "Ordered dither or halftone", "Randomized dither");
    }

    @Nullable
    public String getFillOrderDescription() {
        return this.getIndexedDescription(266, 1, "Normal", "Reversed");
    }

    @Nullable
    public String getSubjectDistanceRangeDescription() {
        return this.getIndexedDescription(41996, "Unknown", "Macro", "Close view", "Distant view");
    }

    @Nullable
    public String getSensitivityTypeRangeDescription() {
        return this.getIndexedDescription(34864, "Unknown", "Standard Output Sensitivity", "Recommended Exposure Index", "ISO Speed", "Standard Output Sensitivity and Recommended Exposure Index", "Standard Output Sensitivity and ISO Speed", "Recommended Exposure Index and ISO Speed", "Standard Output Sensitivity, Recommended Exposure Index and ISO Speed");
    }

    @Nullable
    public String getLensSpecificationDescription() {
        return this.getLensSpecificationDescription(42034);
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(41994, "None", "Low", "Hard");
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(41993, "None", "Low saturation", "High saturation");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(41992, "None", "Soft", "Hard");
    }

    @Nullable
    public String getGainControlDescription() {
        return this.getIndexedDescription(41991, "None", "Low gain up", "Low gain down", "High gain up", "High gain down");
    }

    @Nullable
    public String getSceneCaptureTypeDescription() {
        return this.getIndexedDescription(41990, "Standard", "Landscape", "Portrait", "Night scene");
    }

    @Nullable
    public String get35mmFilmEquivFocalLengthDescription() {
        Integer n = this._directory.getInteger(41989);
        return n == null ? null : (n == 0 ? "Unknown" : ExifDescriptorBase.getFocalLengthDescription(n.intValue()));
    }

    @Nullable
    public String getDigitalZoomRatioDescription() {
        Rational rational = this._directory.getRational(41988);
        return rational == null ? null : (rational.getNumerator() == 0L ? "Digital zoom not used" : SimpleDecimalFormatter.format(rational.doubleValue()));
    }

    @Nullable
    public String getWhiteBalanceModeDescription() {
        return this.getIndexedDescription(41987, "Auto white balance", "Manual white balance");
    }

    @Nullable
    public String getExposureModeDescription() {
        return this.getIndexedDescription(41986, "Auto exposure", "Manual exposure", "Auto bracket");
    }

    @Nullable
    public String getCustomRenderedDescription() {
        return this.getIndexedDescription(41985, "Normal process", "Custom process");
    }

    @Nullable
    public String getUserCommentDescription() {
        byte[] byArray = this._directory.getByteArray(37510);
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ASCII", System.getProperty("file.encoding"));
        hashMap.put("UNICODE", "UTF-16LE");
        hashMap.put("JIS", "Shift-JIS");
        try {
            if (byArray.length >= 10) {
                String string = new String(byArray, 0, 10);
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    if (!string.startsWith(string2)) continue;
                    for (int i = string2.length(); i < 10; ++i) {
                        byte by = byArray[i];
                        if (by == 0 || by == 32) continue;
                        return new String(byArray, i, byArray.length - i, string3).trim();
                    }
                    return new String(byArray, 10, byArray.length - 10, string3).trim();
                }
            }
            return new String(byArray, System.getProperty("file.encoding")).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Nullable
    public String getIsoEquivalentDescription() {
        Integer n = this._directory.getInteger(34855);
        return n != null ? Integer.toString(n) : null;
    }

    @Nullable
    public String getExifVersionDescription() {
        return this.getVersionBytesDescription(36864, 2);
    }

    @Nullable
    public String getFlashPixVersionDescription() {
        return this.getVersionBytesDescription(40960, 2);
    }

    @Nullable
    public String getSceneTypeDescription() {
        return this.getIndexedDescription(41729, 1, "Directly photographed image");
    }

    @Nullable
    public String getFileSourceDescription() {
        return this.getIndexedDescription(41728, 1, "Film Scanner", "Reflection Print Scanner", "Digital Still Camera (DSC)");
    }

    @Nullable
    public String getExposureBiasDescription() {
        Rational rational = this._directory.getRational(37380);
        if (rational == null) {
            return null;
        }
        return rational.toSimpleString(true) + " EV";
    }

    @Nullable
    public String getMaxApertureValueDescription() {
        Double d = this._directory.getDoubleObject(37381);
        if (d == null) {
            return null;
        }
        double d2 = PhotographicConversions.apertureToFStop(d);
        return ExifDescriptorBase.getFStopDescription(d2);
    }

    @Nullable
    public String getApertureValueDescription() {
        Double d = this._directory.getDoubleObject(37378);
        if (d == null) {
            return null;
        }
        double d2 = PhotographicConversions.apertureToFStop(d);
        return ExifDescriptorBase.getFStopDescription(d2);
    }

    @Nullable
    public String getExposureProgramDescription() {
        return this.getIndexedDescription(34850, 1, "Manual control", "Program normal", "Aperture priority", "Shutter priority", "Program creative (slow program)", "Program action (high-speed program)", "Portrait mode", "Landscape mode");
    }

    @Nullable
    public String getFocalPlaneXResolutionDescription() {
        Rational rational = this._directory.getRational(41486);
        if (rational == null) {
            return null;
        }
        String string = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (string == null ? "" : " " + string.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneYResolutionDescription() {
        Rational rational = this._directory.getRational(41487);
        if (rational == null) {
            return null;
        }
        String string = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (string == null ? "" : " " + string.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneResolutionUnitDescription() {
        return this.getIndexedDescription(41488, 1, "(No unit)", "Inches", "cm");
    }

    @Nullable
    public String getExifImageWidthDescription() {
        Integer n = this._directory.getInteger(40962);
        return n == null ? null : n + " pixels";
    }

    @Nullable
    public String getExifImageHeightDescription() {
        Integer n = this._directory.getInteger(40963);
        return n == null ? null : n + " pixels";
    }

    @Nullable
    public String getColorSpaceDescription() {
        Integer n = this._directory.getInteger(40961);
        if (n == null) {
            return null;
        }
        if (n == 1) {
            return "sRGB";
        }
        if (n == 65535) {
            return "Undefined";
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational rational = this._directory.getRational(37386);
        return rational == null ? null : ExifDescriptorBase.getFocalLengthDescription(rational.doubleValue());
    }

    @Nullable
    public String getFlashDescription() {
        Integer n = this._directory.getInteger(37385);
        if (n == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("Flash fired");
        } else {
            stringBuilder.append("Flash did not fire");
        }
        if ((n & 4) != 0) {
            if ((n & 2) != 0) {
                stringBuilder.append(", return detected");
            } else {
                stringBuilder.append(", return not detected");
            }
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append(", auto");
        }
        if ((n & 0x40) != 0) {
            stringBuilder.append(", red-eye reduction");
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = this._directory.getInteger(37384);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Florescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Flash";
            }
            case 9: {
                return "Fine Weather";
            }
            case 10: {
                return "Cloudy";
            }
            case 11: {
                return "Shade";
            }
            case 12: {
                return "Daylight Fluorescent";
            }
            case 13: {
                return "Day White Fluorescent";
            }
            case 14: {
                return "Cool White Fluorescent";
            }
            case 15: {
                return "White Fluorescent";
            }
            case 16: {
                return "Warm White Fluorescent";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 23: {
                return "D50";
            }
            case 24: {
                return "Studio Tungsten";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer n = this._directory.getInteger(37383);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getCompressionDescription() {
        Integer n = this._directory.getInteger(259);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT 1D";
            }
            case 3: {
                return "T4/Group 3 Fax";
            }
            case 4: {
                return "T6/Group 4 Fax";
            }
            case 5: {
                return "LZW";
            }
            case 6: {
                return "JPEG (old-style)";
            }
            case 7: {
                return "JPEG";
            }
            case 8: {
                return "Adobe Deflate";
            }
            case 9: {
                return "JBIG B&W";
            }
            case 10: {
                return "JBIG Color";
            }
            case 99: {
                return "JPEG";
            }
            case 262: {
                return "Kodak 262";
            }
            case 32766: {
                return "Next";
            }
            case 32767: {
                return "Sony ARW Compressed";
            }
            case 32769: {
                return "Packed RAW";
            }
            case 32770: {
                return "Samsung SRW Compressed";
            }
            case 32771: {
                return "CCIRLEW";
            }
            case 32772: {
                return "Samsung SRW Compressed 2";
            }
            case 32773: {
                return "PackBits";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 32867: {
                return "Kodak KDC Compressed";
            }
            case 32895: {
                return "IT8CTPAD";
            }
            case 32896: {
                return "IT8LW";
            }
            case 32897: {
                return "IT8MP";
            }
            case 32898: {
                return "IT8BL";
            }
            case 32908: {
                return "PixarFilm";
            }
            case 32909: {
                return "PixarLog";
            }
            case 32946: {
                return "Deflate";
            }
            case 32947: {
                return "DCS";
            }
            case 34661: {
                return "JBIG";
            }
            case 34676: {
                return "SGILog";
            }
            case 34677: {
                return "SGILog24";
            }
            case 34712: {
                return "JPEG 2000";
            }
            case 34713: {
                return "Nikon NEF Compressed";
            }
            case 34715: {
                return "JBIG2 TIFF FX";
            }
            case 34718: {
                return "Microsoft Document Imaging (MDI) Binary Level Codec";
            }
            case 34719: {
                return "Microsoft Document Imaging (MDI) Progressive Transform Codec";
            }
            case 34720: {
                return "Microsoft Document Imaging (MDI) Vector";
            }
            case 34892: {
                return "Lossy JPEG";
            }
            case 65000: {
                return "Kodak DCR Compressed";
            }
            case 65535: {
                return "Pentax PEF Compressed";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSubjectDistanceDescription() {
        Rational rational = this._directory.getRational(37382);
        if (rational == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        return decimalFormat.format(rational.doubleValue()) + " metres";
    }

    @Nullable
    public String getCompressedAverageBitsPerPixelDescription() {
        Rational rational = this._directory.getRational(37122);
        if (rational == null) {
            return null;
        }
        String string = rational.toSimpleString(true);
        return rational.isInteger() && rational.intValue() == 1 ? string + " bit/pixel" : string + " bits/pixel";
    }

    @Nullable
    public String getExposureTimeDescription() {
        String string = this._directory.getString(33434);
        return string == null ? null : string + " sec";
    }

    @Nullable
    public String getShutterSpeedDescription() {
        Float f = this._directory.getFloatObject(37377);
        if (f == null) {
            return null;
        }
        if (f.floatValue() <= 1.0f) {
            float f2 = (float)(1.0 / Math.exp((double)f.floatValue() * Math.log(2.0)));
            long l = Math.round((double)f2 * 10.0);
            float f3 = (float)l / 10.0f;
            DecimalFormat decimalFormat = new DecimalFormat("0.##");
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            return decimalFormat.format(f3) + " sec";
        }
        int n = (int)Math.exp((double)f.floatValue() * Math.log(2.0));
        return "1/" + n + " sec";
    }

    @Nullable
    public String getFNumberDescription() {
        Rational rational = this._directory.getRational(33437);
        if (rational == null) {
            return null;
        }
        return ExifDescriptorBase.getFStopDescription(rational.doubleValue());
    }

    @Nullable
    public String getSensingMethodDescription() {
        return this.getIndexedDescription(41495, 1, "(Not defined)", "One-chip color area sensor", "Two-chip color area sensor", "Three-chip color area sensor", "Color sequential area sensor", null, "Trilinear sensor", "Color sequential linear sensor");
    }

    @Nullable
    public String getComponentConfigurationDescription() {
        int[] nArray = this._directory.getIntArray(37121);
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(4, nArray.length); ++i) {
            int n = nArray[i];
            if (n <= 0 || n >= stringArray.length) continue;
            stringBuilder.append(stringArray[n]);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getJpegProcDescription() {
        Integer n = this._directory.getInteger(512);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Baseline";
            }
            case 14: {
                return "Lossless";
            }
        }
        return "Unknown (" + n + ")";
    }
}

