/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.ico.IcoMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.pcx.PcxMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.raf.RafMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.file.FileMetadataReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ImageMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws ImageProcessingException, IOException {
        return ImageMetadataReader.readMetadata(inputStream, -1L);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, long l) throws ImageProcessingException, IOException {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        FileType fileType = FileTypeDetector.detectFileType(bufferedInputStream);
        if (fileType == FileType.Jpeg) {
            return JpegMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Tiff || fileType == FileType.Arw || fileType == FileType.Cr2 || fileType == FileType.Nef || fileType == FileType.Orf || fileType == FileType.Rw2) {
            return TiffMetadataReader.readMetadata(new RandomAccessStreamReader(bufferedInputStream, 2048, l));
        }
        if (fileType == FileType.Psd) {
            return PsdMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Png) {
            return PngMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Bmp) {
            return BmpMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Gif) {
            return GifMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Ico) {
            return IcoMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Pcx) {
            return PcxMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Riff) {
            return WebpMetadataReader.readMetadata(bufferedInputStream);
        }
        if (fileType == FileType.Raf) {
            return RafMetadataReader.readMetadata(bufferedInputStream);
        }
        throw new ImageProcessingException("File format is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        Metadata metadata;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            metadata = ImageMetadataReader.readMetadata(fileInputStream, file.length());
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        new FileMetadataReader().read(file, metadata);
        return metadata;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] stringArray) throws MetadataException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = arrayList.remove("-thumb");
        boolean bl2 = arrayList.remove("-markdown");
        boolean bl3 = arrayList.remove("-hex");
        if (arrayList.size() < 1) {
            String string = ImageMetadataReader.class.getPackage().getImplementationVersion();
            System.out.println("metadata-extractor version " + (String)string);
            System.out.println();
            System.out.println(String.format("Usage: java -jar metadata-extractor-%s.jar <filename> [<filename>] [-thumb] [-markdown] [-hex]", string == null ? "a.b.c" : string));
            System.exit(1);
        }
        for (String string : arrayList) {
            Object object;
            Object object2;
            long l = System.nanoTime();
            File file = new File(string);
            if (!bl2 && arrayList.size() > 1) {
                System.out.printf("\n***** PROCESSING: %s\n%n", string);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            long l2 = System.nanoTime() - l;
            if (!bl2) {
                System.out.printf("Processed %.3f MB file in %.2f ms%n%n", (double)file.length() / 1048576.0, (double)l2 / 1000000.0);
            }
            if (bl2) {
                object2 = file.getName();
                String string2 = StringUtil.urlEncode(string);
                object = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                Iterator<String> iterator = object == null ? "" : ((Directory)object).getString(271);
                String string3 = object == null ? "" : ((Directory)object).getString(272);
                System.out.println();
                System.out.println("---");
                System.out.println();
                System.out.printf("# %s - %s%n", iterator, string3);
                System.out.println();
                System.out.printf("<a href=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\">%n", string2);
                System.out.printf("<img src=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\" width=\"300\"/><br/>%n", string2);
                System.out.println((String)object2);
                System.out.println("</a>");
                System.out.println();
                System.out.println("Directory | Tag Id | Tag Name | Extracted Value");
                System.out.println(":--------:|-------:|----------|----------------");
            }
            for (Directory directory : metadata.getDirectories()) {
                object = directory.getName();
                for (Tag tag : directory.getTags()) {
                    String string4 = tag.getTagName();
                    String string5 = tag.getDescription();
                    if (string5 != null && string5.length() > 1024) {
                        string5 = string5.substring(0, 1024) + "...";
                    }
                    if (bl2) {
                        System.out.printf("%s|0x%s|%s|%s%n", object, Integer.toHexString(tag.getTagType()), string4, string5);
                        continue;
                    }
                    if (bl3) {
                        System.out.printf("[%s - %s] %s = %s%n", object, tag.getTagTypeHex(), string4, string5);
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", object, string4, string5);
                }
                for (String string6 : directory.getErrors()) {
                    System.err.println("ERROR: " + string6);
                }
            }
            if (stringArray.length <= 1 || !bl) continue;
            object2 = metadata.getFirstDirectoryOfType(ExifThumbnailDirectory.class);
            if (object2 != null && ((ExifThumbnailDirectory)object2).hasThumbnailData()) {
                System.out.println("Writing thumbnail...");
                ((ExifThumbnailDirectory)object2).writeThumbnail(stringArray[0].trim() + ".thumb.jpg");
                continue;
            }
            System.out.println("No thumbnail data exists in this image");
        }
    }
}

